/*
 * Decompiled with CFR 0.152.
 */
package com.github.shoothzj.javatool.util;

import com.github.shoothzj.javatool.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvUtil {
    private static final Logger log = LoggerFactory.getLogger(EnvUtil.class);
    private static final String userHome = System.getProperty("user.home");
    private static final String osName = System.getProperty("os.name");
    private static final String osVersion = System.getProperty("os.version");
    private static final String userDir = System.getProperty("user.dir");

    public static boolean getBooleanVar(String property, String env, boolean defaultVal) {
        String prop = System.getProperty(property);
        if (StringUtil.isNotEmpty((CharSequence)prop)) {
            return Boolean.parseBoolean(prop);
        }
        String envVal = System.getenv(env);
        if (StringUtil.isNotEmpty((CharSequence)envVal)) {
            return Boolean.parseBoolean(envVal);
        }
        return defaultVal;
    }

    public static int getIntVar(String property, String env, int defaultVal) {
        String prop = System.getProperty(property);
        if (StringUtil.isNotEmpty((CharSequence)prop)) {
            return Integer.parseInt(prop);
        }
        String envVal = System.getenv(env);
        if (StringUtil.isNotEmpty((CharSequence)envVal)) {
            return Integer.parseInt(envVal);
        }
        return defaultVal;
    }

    public static float getFloatVar(String property, String env, float defaultVal) {
        String prop = System.getProperty(property);
        if (StringUtil.isNotEmpty((CharSequence)prop)) {
            return Float.parseFloat(prop);
        }
        String envVal = System.getenv(env);
        if (StringUtil.isNotEmpty((CharSequence)envVal)) {
            return Float.parseFloat(envVal);
        }
        return defaultVal;
    }

    public static double getDoubleVar(String property, String env, double defaultVal) {
        String prop = System.getProperty(property);
        if (StringUtil.isNotEmpty((CharSequence)prop)) {
            return Double.parseDouble(prop);
        }
        String envVal = System.getenv(env);
        if (StringUtil.isNotEmpty((CharSequence)envVal)) {
            return Double.parseDouble(envVal);
        }
        return defaultVal;
    }

    public static String getStringVar(String property, String env, String defaultVal) {
        String prop = System.getProperty(property);
        if (StringUtil.isNotEmpty((CharSequence)prop)) {
            return prop;
        }
        String envVal = System.getenv(env);
        if (StringUtil.isNotEmpty((CharSequence)envVal)) {
            return envVal;
        }
        return defaultVal;
    }

    public static String getUserHome() {
        return userHome;
    }

    public static String getOsName() {
        return osName;
    }

    public static String getOsVersion() {
        return osVersion;
    }

    public static String getHostName() {
        return System.getenv("HOSTNAME");
    }

    public static String getUserDir() {
        return userDir;
    }

    public static String getServiceName() {
        return System.getenv("SERVICE_NAME");
    }

    public static void listAll() {
        log.info("userHome is {}", (Object)userHome);
        log.info("osName is {}", (Object)osName);
        log.info("osVersion is {}", (Object)osVersion);
    }
}

