package com.github.shoothzj.javatool.util;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;

/**
 * @author hezhangjian
 */
public class LogUtil {
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(LogUtil.class);

    public static void configureLog() {
        String logLevel = System.getenv("LOG_LEVEL");
        if (StringUtil.isEmpty(logLevel)) {
            Configurator.setRootLevel(Level.INFO);
            return;
        }
        switch (logLevel) {
        case "DEBUG": 
            Configurator.setRootLevel(Level.DEBUG);
            break;
        case "ERROR": 
            Configurator.setRootLevel(Level.ERROR);
            break;
        default: 
            Configurator.setRootLevel(Level.INFO);
        }
    }
}
