/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallmenu.fun;

import com.github.smallmenu.Fun;
import com.github.smallmenu.fun.ArrayFun;
import com.github.smallmenu.fun.CharFun;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StringFun {
    public static final int INDEX_NOT_FOUND = -1;
    public static final String EMPTY = "";
    public static final String EMPTY_JSON = "{}";
    public static final String SPACE = " ";
    public static final String TAB = "\t";
    public static final String DOT = ".";
    public static final String DOUBLE_DOT = "..";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String UNDERLINE = "_";
    public static final String DASHED = "-";
    public static final String COMMA = ",";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String CRLF = "\r\n";
    public static final String COLON = ":";
    public static final String SHARP = "#";
    public static final String AT = "@";
    public static final String HTML_NBSP = "&nbsp;";
    public static final String HTML_AMP = "&amp;";
    public static final String HTML_LT = "&lt;";
    public static final String HTML_GT = "&gt;";
    public static final int PAD_LIMIT = 8192;

    private StringFun() {
        throw new AssertionError();
    }

    public static boolean isString(Object value) {
        return value instanceof CharSequence;
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int start, boolean ignoreCase) {
        int endLimit;
        if (str == null || searchStr == null) {
            return -1;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > (endLimit = str.length() - searchStr.length() + 1)) {
            return -1;
        }
        if (searchStr.length() == 0) {
            return start;
        }
        if (!ignoreCase) {
            return str.toString().indexOf(searchStr.toString(), start);
        }
        for (int i = start; i < endLimit; ++i) {
            if (!StringFun.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length);
    }

    public static String trim(CharSequence str) {
        return StringFun.trim(str, null, 0);
    }

    public static String trim(CharSequence str, CharSequence trimStr, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            if (trimStr == null) {
                for (start = 0; start < end && CharFun.isBlankChar(str.charAt(start)); ++start) {
                }
            } else {
                while (start < end && trimStr.toString().indexOf(str.charAt(start)) != -1) {
                    ++start;
                }
            }
        }
        if (mode >= 0) {
            if (trimStr == null) {
                while (start < end && CharFun.isBlankChar(str.charAt(end - 1))) {
                    --end;
                }
            } else {
                while (start < end && trimStr.toString().indexOf(str.charAt(end - 1)) != -1) {
                    --end;
                }
            }
        }
        if (start > 0 || end < length) {
            return str.toString().substring(start, end);
        }
        return str.toString();
    }

    public static boolean startsWith(CharSequence str, CharSequence prefix, boolean isIgnoreCase) {
        if (null == str || null == prefix) {
            return null == str && null == prefix;
        }
        if (isIgnoreCase) {
            return str.toString().toLowerCase().startsWith(prefix.toString().toLowerCase());
        }
        return str.toString().startsWith(prefix.toString());
    }

    public static boolean endsWith(CharSequence str, CharSequence suffix, boolean isIgnoreCase) {
        if (null == str || null == suffix) {
            return null == str && null == suffix;
        }
        if (isIgnoreCase) {
            return str.toString().toLowerCase().endsWith(suffix.toString().toLowerCase());
        }
        return str.toString().endsWith(suffix.toString());
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.toString().contentEquals(str2);
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replaceStr, int max, boolean ignoreCase) {
        int end;
        if (Fun.empty(str) || Fun.empty(searchStr) || replaceStr == null || max == 0) {
            return Fun.toStr(str);
        }
        if (ignoreCase) {
            searchStr = searchStr.toString().toLowerCase();
        }
        int start = 0;
        int n = end = ignoreCase ? Fun.indexOfIgnoreCase(str, searchStr, start) : StringFun.indexOf(str, searchStr, start, false);
        if (end == -1) {
            return str.toString();
        }
        int replLength = searchStr.length();
        int increase = Math.max(searchStr.length() - replLength, 0);
        StringBuilder buf = new StringBuilder(str.length() + (increase *= max < 0 ? 16 : Math.min(max, 64)));
        while (end != -1) {
            buf.append(str, start, end).append(replaceStr);
            start = end + replLength;
            if (--max == 0) break;
            end = ignoreCase ? Fun.indexOfIgnoreCase(str, searchStr, start) : StringFun.indexOf(str, searchStr, start, false);
        }
        buf.append(str, start, str.length());
        return buf.toString();
    }

    public static List<String> splitToList(String str, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (Fun.empty(str)) {
            return Collections.emptyList();
        }
        if (limit == 1) {
            return StringFun.splitAddList(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (!CharFun.isBlankChar(str.charAt(i))) continue;
            StringFun.splitAddList(list, str.substring(start, i), isTrim, ignoreEmpty);
            start = i + 1;
            if (limit > 0 && list.size() > limit - 2) break;
        }
        return StringFun.splitAddList(list, str.substring(start, len), true, true);
    }

    public static List<String> splitToList(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (Fun.empty(str)) {
            return Collections.emptyList();
        }
        if (limit == 1) {
            return StringFun.splitAddList(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        ArrayList<String> list = new ArrayList<String>(limit > 0 ? limit : 16);
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (!CharFun.equals(separator, str.charAt(i), ignoreCase)) continue;
            StringFun.splitAddList(list, str.substring(start, i), isTrim, ignoreEmpty);
            start = i + 1;
            if (limit > 0 && list.size() > limit - 2) break;
        }
        return StringFun.splitAddList(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static List<String> splitToList(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (Fun.empty(str)) {
            return Collections.emptyList();
        }
        if (limit == 1) {
            return StringFun.splitAddList(new ArrayList<String>(1), str, isTrim, ignoreEmpty);
        }
        if (Fun.empty(separator)) {
            return StringFun.splitToList(str, limit, isTrim, ignoreEmpty);
        }
        if (separator.length() == 1) {
            return StringFun.splitToList(str, separator.charAt(0), limit, isTrim, ignoreEmpty, ignoreCase);
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = str.length();
        int separatorLen = separator.length();
        int start = 0;
        int i = 0;
        while (i < len && (i = StringFun.indexOf(str, separator, start, ignoreCase)) > -1) {
            StringFun.splitAddList(list, str.substring(start, i), isTrim, ignoreEmpty);
            start = i + separatorLen;
            if (limit <= 0 || list.size() <= limit - 2) continue;
            break;
        }
        return StringFun.splitAddList(list, str.substring(start, len), isTrim, ignoreEmpty);
    }

    public static String[] split(String str, int limit, boolean isTrim, boolean ignoreEmpty) {
        List<String> list = StringFun.splitToList(str, limit, isTrim, ignoreEmpty);
        return list.toArray(ArrayFun.EMPTY_STRING);
    }

    public static String[] split(String str, String separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        List<String> list = StringFun.splitToList(str, separator, limit, isTrim, ignoreEmpty, ignoreCase);
        return list.toArray(ArrayFun.EMPTY_STRING);
    }

    public static String[] split(String str, char separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        List<String> list = StringFun.splitToList(str, separator, limit, isTrim, ignoreEmpty, ignoreCase);
        return list.toArray(ArrayFun.EMPTY_STRING);
    }

    private static List<String> splitAddList(List<String> list, String str, boolean trim, boolean ignoreEmpty) {
        if (trim) {
            str = Fun.trim(str);
        }
        if (!ignoreEmpty || !Fun.empty(str)) {
            list.add(str);
        }
        return list;
    }
}

