/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.comment.UneditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.UneditableJavaSingleLineComment;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.field.UneditableJavaField;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javaclass.UneditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.UneditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.method.UneditableJavaMethod;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestClassTest {
    @Test
    public void testFindClassDifferencesNone() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").build(), (JavaClass)EditableJavaClass.builder().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesBothNull() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findClassDifferences(null, null));
    }

    @Test
    public void testFindClassDifferencesClass1NullClass2Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the classes is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findClassDifferences(null, (JavaClass)EditableJavaClass.builder().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesClass2NullClass1Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the classes is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").build(), null));
    }

    @Test
    public void testFindClassDifferencesEditable() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)UneditableJavaClass.builder().className("Test").build(), (JavaClass)EditableJavaClass.builder().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesInnerClass() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Inner Class is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").build(), (JavaClass)EditableJavaClass.builder().innerClass().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesPackageDeclaration() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Package Declaration differs:\n\tPackage Name is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().packageName("com.test").className("Test").build(), (JavaClass)EditableJavaClass.builder().packageName("com.example").className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesImportStatementsLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Import Statements length is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").build(), (JavaClass)EditableJavaClass.builder().importName("com.example.Thing", false).className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesImportStatementsLength1() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Import Statements length is different!", "Import Statements differs on #1!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().importName("com.example.Thing", false).className("Test").build(), (JavaClass)EditableJavaClass.builder().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesImportStatementsContent() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Import Statements differs on #1:\n\tStatic is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().importName("com.example.Thing", false).className("Test").build(), (JavaClass)EditableJavaClass.builder().importName("com.example.Thing", true).className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesJavadoc() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().javadoc(EditableJavadoc.builder().build()).className("Test").build(), (JavaClass)EditableJavaClass.builder().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesAnnotationsLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Annotations length is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).className("Test").build(), (JavaClass)EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesAnnotationsLength1() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Annotations length is different!", "Annotations differs on #2!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).className("Test").build(), (JavaClass)EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesAnnotationsContent() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Annotations differs on #1:\n\tName is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).className("Test").build(), (JavaClass)EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getDerp").build()).className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesVisibility() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Visibility is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().visibility(Visibility.PUBLIC).className("Test").build(), (JavaClass)EditableJavaClass.builder().visibility(Visibility.PRIVATE).className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesAbstract() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Abstract is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().isAbstract().className("Test").build(), (JavaClass)EditableJavaClass.builder().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesStatic() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Static is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().innerClass().isStatic().className("Test").build(), (JavaClass)EditableJavaClass.builder().innerClass().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesFinal() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Final is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().isFinal().className("Test").build(), (JavaClass)EditableJavaClass.builder().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesClassName() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Class Name is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").build(), (JavaClass)EditableJavaClass.builder().className("Derp").build()));
    }

    @Test
    public void testFindClassDifferencesSuperClassName() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Super Class Name is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").superClassName("Something").build(), (JavaClass)EditableJavaClass.builder().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesImplementsInterfaceNames() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Implements Interface Names differs on #1!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").build(), (JavaClass)EditableJavaClass.builder().className("Test").implementsInterfaceName("SomethingElse").build()));
    }

    @Test
    public void testFindClassDifferencesImplementsInterfaceNamesLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Implements Interface Names length is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").build(), (JavaClass)EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").implementsInterfaceName("SomethingElse").build()));
    }

    @Test
    public void testFindClassDifferencesImplementsInterfaceNamesLength1Longer() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Implements Interface Names length is different!", "Implements Interface Names differs on #2!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").implementsInterfaceName("SomethingElse").build(), (JavaClass)EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").build()));
    }

    @Test
    public void testFindClassDifferencesSingleLineComments() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Single Line Comments differs on #1:\n\tContent is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").singleLineComment(EditableJavaSingleLineComment.builder().content("Something useful").build()).build(), (JavaClass)EditableJavaClass.builder().className("Test").singleLineComment(EditableJavaSingleLineComment.builder().content("Something different").build()).build()));
    }

    @Test
    public void testFindClassDifferencesSingleLineCommentsLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Single Line Comments length is different!", "Inner Elements Order length is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").build(), (JavaClass)EditableJavaClass.builder().className("Test").singleLineComment(EditableJavaSingleLineComment.builder().content("Something different").build()).build()));
    }

    @Test
    public void testFindClassDifferencesSingleLineCommentsLength1Longer() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Single Line Comments length is different!", "Single Line Comments differs on #1!", "Inner Elements Order length is different!", "Inner Elements Order differs on #1!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").singleLineComment(EditableJavaSingleLineComment.builder().content("Something different").build()).build(), (JavaClass)EditableJavaClass.builder().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesMultiLineComments() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Multi Line Comments differs on #1:\n\tContent differs on #1!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").multiLineComment(EditableJavaMultiLineComment.builder().content("Something useful").build()).build(), (JavaClass)EditableJavaClass.builder().className("Test").multiLineComment(EditableJavaMultiLineComment.builder().content("Something different").build()).build()));
    }

    @Test
    public void testFindClassDifferencesMultiLineCommentsLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Multi Line Comments length is different!", "Inner Elements Order length is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").build(), (JavaClass)EditableJavaClass.builder().className("Test").multiLineComment(EditableJavaMultiLineComment.builder().content("Something different").build()).build()));
    }

    @Test
    public void testFindClassDifferencesMultiLineCommentsLength1Longer() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Multi Line Comments length is different!", "Multi Line Comments differs on #1!", "Inner Elements Order length is different!", "Inner Elements Order differs on #1!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").multiLineComment(EditableJavaMultiLineComment.builder().content("Something different").build()).build(), (JavaClass)EditableJavaClass.builder().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesInnerClasses() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Inner Classes differs on #1:\n\tClass Name is different!", "Inner Elements Order differs on #1!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("Something").build()).build(), (JavaClass)EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("SomethingElse").build()).build()));
    }

    @Test
    public void testFindClassDifferencesInnerClassesLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Inner Classes length is different!", "Inner Elements Order length is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").build(), (JavaClass)EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("Something").build()).build()));
    }

    @Test
    public void testFindClassDifferencesInnerClassesLength1Longer() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Inner Classes length is different!", "Inner Classes differs on #1!", "Inner Elements Order length is different!", "Inner Elements Order differs on #1!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("Something").build()).build(), (JavaClass)EditableJavaClass.builder().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesFields() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Fields differs on #1:\n\tName is different!", "Inner Elements Order differs on #1!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("version").build()).build(), (JavaClass)EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("test").build()).build()));
    }

    @Test
    public void testFindClassDifferencesFieldsLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Fields length is different!", "Inner Elements Order length is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").build(), (JavaClass)EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("test").build()).build()));
    }

    @Test
    public void testFindClassDifferencesFieldsLength1Longer() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Fields length is different!", "Fields differs on #1!", "Inner Elements Order length is different!", "Inner Elements Order differs on #1!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("test").build()).build(), (JavaClass)EditableJavaClass.builder().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesMethods() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Methods differs on #1:\n\tName is different!", "Inner Elements Order differs on #1!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("getVersion").build()).build(), (JavaClass)EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("getTest").build()).build()));
    }

    @Test
    public void testFindClassDifferencesMethodsLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Methods length is different!", "Inner Elements Order length is different!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").build(), (JavaClass)EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("getTest").build()).build()));
    }

    @Test
    public void testFindClassDifferencesMethodsLength1Longer() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Methods length is different!", "Methods differs on #1!", "Inner Elements Order length is different!", "Inner Elements Order differs on #1!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("getTest").build()).build(), (JavaClass)EditableJavaClass.builder().className("Test").build()));
    }

    @Test
    public void testFindClassDifferencesAll() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!", "Inner Class is different!", "Package Declaration differs:\n\tOne of the package declarations is null, and the other isn't!", "Import Statements length is different!", "Import Statements differs on #1!", "Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!", "Annotations length is different!", "Annotations differs on #1:\n\tEditable is different!\n\tName is different!", "Annotations differs on #2!", "Visibility is different!", "Abstract is different!", "Static is different!", "Final is different!", "Class Name is different!", "Super Class Name is different!", "Implements Interface Names length is different!", "Implements Interface Names differs on #2!", "Single Line Comments length is different!", "Single Line Comments differs on #1!", "Multi Line Comments length is different!", "Multi Line Comments differs on #1!", "Inner Classes length is different!", "Inner Classes differs on #1!", "Fields length is different!", "Fields differs on #1!", "Methods length is different!", "Methods differs on #1!", "Inner Elements Order length is different!", "Inner Elements Order differs on #1!", "Inner Elements Order differs on #2!", "Inner Elements Order differs on #3!", "Inner Elements Order differs on #4!", "Inner Elements Order differs on #5!"}), (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)UneditableJavaClass.builder().packageName("com.test").importName("com.example.Thing", false).javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).annotation(UneditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PUBLIC).isAbstract().className("Test").superClassName("Something").implementsInterfaceName("Something").implementsInterfaceName("SomethingElse").singleLineComment(UneditableJavaSingleLineComment.builder().content("Something different").build()).multiLineComment(UneditableJavaMultiLineComment.builder().content("Something different").build()).innerClass(UneditableJavaClass.builder().innerClass().className("Something").build()).field(UneditableJavaField.builder().type("String").name("test").build()).method(UneditableJavaMethod.builder().returnType("String").name("getTest").build()).build(), (JavaClass)EditableJavaClass.builder().innerClass().annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().className("Derp").implementsInterfaceName("Something").build()));
    }

    @Test
    public void testAssertClassEqualsNone() {
        JavaCodeTypeTest.assertClassEquals((JavaClass)EditableJavaClass.builder().className("Test").build(), (JavaClass)EditableJavaClass.builder().className("Test").build());
    }

    @Test
    public void testAssertClassEqualsBothNull() {
        JavaCodeTypeTest.assertClassEquals(null, null);
    }

    @Test
    public void testAssertClassEqualsClass1NullClass2Not() {
        JavaClass class2 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals(null, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the classes is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError(null, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsClass2NullClass1Not() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, null);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the classes is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError((Object)class1, null)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsEditable() {
        JavaClass class1 = UneditableJavaClass.builder().className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsInnerClass() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().innerClass().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Inner Class is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsPackageDeclaration() {
        JavaClass class1 = EditableJavaClass.builder().packageName("com.test").className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().packageName("com.example").className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Package Declaration differs:\n\tPackage Name is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsImportStatementsLength() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().importName("com.example.Thing", false).className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Import Statements length is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsImportStatementsLength1() {
        JavaClass class1 = EditableJavaClass.builder().importName("com.example.Thing", false).className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Import Statements length is different!\nImport Statements differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsImportStatementsContent() {
        JavaClass class1 = EditableJavaClass.builder().importName("com.example.Thing", false).className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().importName("com.example.Thing", true).className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Import Statements differs on #1:\n\tStatic is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsJavadoc() {
        JavaClass class1 = EditableJavaClass.builder().javadoc(EditableJavadoc.builder().build()).className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsAnnotationsLength() {
        JavaClass class1 = EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Annotations length is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsAnnotationsLength1() {
        JavaClass class1 = EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Annotations length is different!\nAnnotations differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsAnnotationsContent() {
        JavaClass class1 = EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getDerp").build()).className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Annotations differs on #1:\n\tName is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsVisibility() {
        JavaClass class1 = EditableJavaClass.builder().visibility(Visibility.PUBLIC).className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().visibility(Visibility.PRIVATE).className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Visibility is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsAbstract() {
        JavaClass class1 = EditableJavaClass.builder().isAbstract().className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Abstract is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsStatic() {
        JavaClass class1 = EditableJavaClass.builder().innerClass().isStatic().className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Inner Class is different!\nStatic is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsFinal() {
        JavaClass class1 = EditableJavaClass.builder().isFinal().className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Final is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsClassName() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().className("Derp").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Class Name is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsSuperClassName() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").superClassName("Something").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Super Class Name is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsImplementsInterfaceNames() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").implementsInterfaceName("SomethingElse").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Implements Interface Names differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsImplementsInterfaceNamesLength() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").implementsInterfaceName("SomethingElse").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Implements Interface Names length is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsImplementsInterfaceNamesLength1Longer() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").implementsInterfaceName("SomethingElse").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Implements Interface Names length is different!\nImplements Interface Names differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsSingleLineComments() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").singleLineComment(EditableJavaSingleLineComment.builder().content("Something useful").build()).build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").singleLineComment(EditableJavaSingleLineComment.builder().content("Something different").build()).build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Single Line Comments differs on #1:\n\tContent is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsSingleLineCommentsLength() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").singleLineComment(EditableJavaSingleLineComment.builder().content("Something different").build()).build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Single Line Comments length is different!\nInner Elements Order length is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsSingleLineCommentsLength1Longer() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").singleLineComment(EditableJavaSingleLineComment.builder().content("Something different").build()).build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Single Line Comments length is different!\nSingle Line Comments differs on #1!\nInner Elements Order length is different!\nInner Elements Order differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsMultiLineComments() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").multiLineComment(EditableJavaMultiLineComment.builder().content("Something useful").build()).build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").multiLineComment(EditableJavaMultiLineComment.builder().content("Something different").build()).build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Multi Line Comments differs on #1:\n\tContent differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsMultiLineCommentsLength() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").multiLineComment(EditableJavaMultiLineComment.builder().content("Something different").build()).build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Multi Line Comments length is different!\nInner Elements Order length is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsMultiLineCommentsLength1Longer() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").multiLineComment(EditableJavaMultiLineComment.builder().content("Something different").build()).build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Multi Line Comments length is different!\nMulti Line Comments differs on #1!\nInner Elements Order length is different!\nInner Elements Order differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsInnerClasses() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("Something").build()).build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("SomethingElse").build()).build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Inner Classes differs on #1:\n\tClass Name is different!\nInner Elements Order differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsInnerClassesLength() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("Something").build()).build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Inner Classes length is different!\nInner Elements Order length is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsInnerClassesLength1Longer() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("Something").build()).build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Inner Classes length is different!\nInner Classes differs on #1!\nInner Elements Order length is different!\nInner Elements Order differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsFields() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("version").build()).build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("test").build()).build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Fields differs on #1:\n\tName is different!\nInner Elements Order differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsFieldsLength() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("test").build()).build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Fields length is different!\nInner Elements Order length is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsFieldsLength1Longer() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("test").build()).build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Fields length is different!\nFields differs on #1!\nInner Elements Order length is different!\nInner Elements Order differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsMethods() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("getVersion").build()).build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("getTest").build()).build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Methods differs on #1:\n\tName is different!\nInner Elements Order differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsMethodsLength() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("getTest").build()).build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Methods length is different!\nInner Elements Order length is different!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsMethodsLength1Longer() {
        JavaClass class1 = EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("getTest").build()).build();
        JavaClass class2 = EditableJavaClass.builder().className("Test").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Methods length is different!\nMethods differs on #1!\nInner Elements Order length is different!\nInner Elements Order differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertClassEqualsAll() {
        JavaClass class1 = UneditableJavaClass.builder().packageName("com.test").importName("com.example.Thing", false).javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).annotation(UneditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PUBLIC).isAbstract().className("Test").superClassName("Something").implementsInterfaceName("Something").implementsInterfaceName("SomethingElse").singleLineComment(UneditableJavaSingleLineComment.builder().content("Something different").build()).multiLineComment(UneditableJavaMultiLineComment.builder().content("Something different").build()).innerClass(UneditableJavaClass.builder().innerClass().className("Something").build()).field(UneditableJavaField.builder().type("String").name("test").build()).method(UneditableJavaMethod.builder().returnType("String").name("getTest").build()).build();
        JavaClass class2 = EditableJavaClass.builder().innerClass().annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().className("Derp").implementsInterfaceName("Something").build();
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)class1, (JavaClass)class2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!\nInner Class is different!\nPackage Declaration differs:\n\tOne of the package declarations is null, and the other isn't!\nImport Statements length is different!\nImport Statements differs on #1!\nJavadoc differs:\n\tOne of the Javadocs is null, and the other isn't!\nAnnotations length is different!\nAnnotations differs on #1:\n\tEditable is different!\n\tName is different!\nAnnotations differs on #2!\nVisibility is different!\nAbstract is different!\nStatic is different!\nFinal is different!\nClass Name is different!\nSuper Class Name is different!\nImplements Interface Names length is different!\nImplements Interface Names differs on #2!\nSingle Line Comments length is different!\nSingle Line Comments differs on #1!\nMulti Line Comments length is different!\nMulti Line Comments differs on #1!\nInner Classes length is different!\nInner Classes differs on #1!\nFields length is different!\nFields differs on #1!\nMethods length is different!\nMethods differs on #1!\nInner Elements Order length is different!\nInner Elements Order differs on #1!\nInner Elements Order differs on #2!\nInner Elements Order differs on #3!\nInner Elements Order differs on #4!\nInner Elements Order differs on #5!", (String)AssertionFailedErrors.buildAssertError((Object)class1, (Object)class2)), (Object)e.getMessage());
        }
    }
}

