/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.importstatement.EditableJavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.importstatement.UneditableJavaImportStatement;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestImportStatementTest {
    @Test
    public void testFindImportStatementDifferencesNone() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findImportStatementDifferences((JavaImportStatement)EditableJavaImportStatement.builder().isStatic().importName("com.test").build(), (JavaImportStatement)EditableJavaImportStatement.builder().isStatic().importName("com.test").build()));
    }

    @Test
    public void testFindImportStatementDifferencesEditable() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!"}), (Object)JavaCodeTypeTest.findImportStatementDifferences((JavaImportStatement)UneditableJavaImportStatement.builder().isStatic().importName("com.test").build(), (JavaImportStatement)EditableJavaImportStatement.builder().isStatic().importName("com.test").build()));
    }

    @Test
    public void testFindImportStatementDifferencesStatic() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Static is different!"}), (Object)JavaCodeTypeTest.findImportStatementDifferences((JavaImportStatement)EditableJavaImportStatement.builder().isStatic(false).importName("com.test").build(), (JavaImportStatement)EditableJavaImportStatement.builder().isStatic().importName("com.test").build()));
    }

    @Test
    public void testFindImportStatementDifferencesImportName() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Import Name is different!"}), (Object)JavaCodeTypeTest.findImportStatementDifferences((JavaImportStatement)EditableJavaImportStatement.builder().isStatic().importName("com.example").build(), (JavaImportStatement)EditableJavaImportStatement.builder().isStatic().importName("com.test").build()));
    }

    @Test
    public void testFindImportStatementDifferencesAll() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!", "Static is different!", "Import Name is different!"}), (Object)JavaCodeTypeTest.findImportStatementDifferences((JavaImportStatement)UneditableJavaImportStatement.builder().isStatic(false).importName("com.example").build(), (JavaImportStatement)EditableJavaImportStatement.builder().isStatic().importName("com.test").build()));
    }

    @Test
    public void testAssertImportStatementEqualsNone() {
        JavaCodeTypeTest.assertImportStatementEquals((JavaImportStatement)EditableJavaImportStatement.builder().isStatic().importName("com.test").build(), (JavaImportStatement)EditableJavaImportStatement.builder().isStatic().importName("com.test").build());
    }

    @Test
    public void testAssertImportStatementEqualsEditable() {
        JavaImportStatement importStatement1 = UneditableJavaImportStatement.builder().isStatic().importName("com.test").build();
        JavaImportStatement importStatement2 = EditableJavaImportStatement.builder().isStatic().importName("com.test").build();
        try {
            JavaCodeTypeTest.assertImportStatementEquals((JavaImportStatement)importStatement1, (JavaImportStatement)importStatement2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!", (String)AssertionFailedErrors.buildAssertError((Object)importStatement1, (Object)importStatement2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertImportStatementEqualsStatic() {
        JavaImportStatement importStatement1 = EditableJavaImportStatement.builder().isStatic(false).importName("com.test").build();
        JavaImportStatement importStatement2 = EditableJavaImportStatement.builder().isStatic().importName("com.test").build();
        try {
            JavaCodeTypeTest.assertImportStatementEquals((JavaImportStatement)importStatement1, (JavaImportStatement)importStatement2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Static is different!", (String)AssertionFailedErrors.buildAssertError((Object)importStatement1, (Object)importStatement2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertImportStatementEqualsImportName() {
        JavaImportStatement importStatement1 = EditableJavaImportStatement.builder().isStatic().importName("com.example").build();
        JavaImportStatement importStatement2 = EditableJavaImportStatement.builder().isStatic().importName("com.test").build();
        try {
            JavaCodeTypeTest.assertImportStatementEquals((JavaImportStatement)importStatement1, (JavaImportStatement)importStatement2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Import Name is different!", (String)AssertionFailedErrors.buildAssertError((Object)importStatement1, (Object)importStatement2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertImportStatementEqualsAll() {
        JavaImportStatement importStatement1 = UneditableJavaImportStatement.builder().isStatic(false).importName("com.example").build();
        JavaImportStatement importStatement2 = EditableJavaImportStatement.builder().isStatic().importName("com.test").build();
        try {
            JavaCodeTypeTest.assertImportStatementEquals((JavaImportStatement)importStatement1, (JavaImportStatement)importStatement2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!\nStatic is different!\nImport Name is different!", (String)AssertionFailedErrors.buildAssertError((Object)importStatement1, (Object)importStatement2)), (Object)e.getMessage());
        }
    }
}

