/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.method.UneditableJavaMethod;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestMethodTest {
    @Test
    public void testFindMethodDifferencesNone() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().returnType("String").name("getTest").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getTest").build()));
    }

    @Test
    public void testFindMethodDifferencesBothNull() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findMethodDifferences(null, null));
    }

    @Test
    public void testFindMethodDifferencesMethod1NullMethod2Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the methods is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findMethodDifferences(null, (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getTest").build()));
    }

    @Test
    public void testFindMethodDifferencesMethod2NullMethod1Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the methods is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().returnType("String").name("getTest").build(), null));
    }

    @Test
    public void testFindMethodDifferencesEditable() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)UneditableJavaMethod.builder().returnType("String").name("getTest").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getTest").build()));
    }

    @Test
    public void testFindMethodDifferencesJavadoc() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().build()).returnType("String").name("getTest").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getTest").build()));
    }

    @Test
    public void testFindMethodDifferencesAnnotationsLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Annotations length is different!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).returnType("String").name("getTest").build(), (JavaMethod)EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).returnType("String").name("getTest").build()));
    }

    @Test
    public void testFindMethodDifferencesAnnotationsLength1() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Annotations length is different!", "Annotations differs on #2!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).returnType("String").name("getTest").build(), (JavaMethod)EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).returnType("String").name("getTest").build()));
    }

    @Test
    public void testFindMethodDifferencesAnnotationsContent() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Annotations differs on #1:\n\tName is different!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).returnType("String").name("getTest").build(), (JavaMethod)EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getDerp").build()).returnType("String").name("getTest").build()));
    }

    @Test
    public void testFindMethodDifferencesVisibility() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Visibility is different!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).returnType("String").name("getTest").build(), (JavaMethod)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).returnType("String").name("getTest").build()));
    }

    @Test
    public void testFindMethodDifferencesAbstract() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Abstract is different!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().isAbstract().returnType("String").name("getTest").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getTest").build()));
    }

    @Test
    public void testFindMethodDifferencesStatic() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Static is different!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().isStatic().returnType("String").name("getTest").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getTest").build()));
    }

    @Test
    public void testFindMethodDifferencesFinal() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Final is different!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().isFinal().returnType("String").name("getTest").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getTest").build()));
    }

    @Test
    public void testFindMethodDifferencesReturnType() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Return Type is different!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().returnType("int").name("getTest").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getTest").build()));
    }

    @Test
    public void testFindMethodDifferencesName() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Name is different!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getTest").build()));
    }

    @Test
    public void testFindMethodDifferencesParamsLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Parameters length is different!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").parameter("String", "version").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").parameter("String", "version").parameter("int", "version").build()));
    }

    @Test
    public void testFindMethodDifferencesParamsLength1Longer() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Parameters length is different!", "Parameters differs on #2!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").parameter("String", "version").parameter("int", "version").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").parameter("String", "version").build()));
    }

    @Test
    public void testFindMethodDifferencesThrowsTypes() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Throw Types differs on #1!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("NoException").build()));
    }

    @Test
    public void testFindMethodDifferencesThrowsTypesLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Throw Types length is different!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").throwType("NoException").build()));
    }

    @Test
    public void testFindMethodDifferencesThrowsTypesLength1Longer() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Throw Types length is different!", "Throw Types differs on #2!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").throwType("NoException").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").build()));
    }

    @Test
    public void testFindMethodDifferencesContent() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Content differs on #1!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").line("return this;").build()));
    }

    @Test
    public void testFindMethodDifferencesContentLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Content length is different!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").line("return this;").build()));
    }

    @Test
    public void testFindMethodDifferencesContentLength1Longer() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Content length is different!", "Content differs on #2!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").line("return this;").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").build()));
    }

    @Test
    public void testFindMethodDifferencesAll() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!", "Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!", "Annotations length is different!", "Annotations differs on #1:\n\tEditable is different!\n\tName is different!", "Annotations differs on #2!", "Visibility is different!", "Abstract is different!", "Return Type is different!", "Name is different!", "Parameters length is different!", "Parameters differs on #2!", "Throw Types length is different!", "Throw Types differs on #2!"}), (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().build()).annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).visibility(Visibility.PUBLIC).isAbstract().returnType("int").name("getVersion").parameter("String", "version").parameter("int", "version").throwType("Exception").throwType("NoException").build(), (JavaMethod)UneditableJavaMethod.builder().annotation(UneditableJavaAnnotation.builder().name("getDerp").build()).visibility(Visibility.PRIVATE).returnType("String").name("getTest").parameter("String", "version").throwType("Exception").build()));
    }

    @Test
    public void testAssertMethodEqualsNone() {
        JavaCodeTypeTest.assertMethodEquals((JavaMethod)EditableJavaMethod.builder().returnType("String").name("getTest").build(), (JavaMethod)EditableJavaMethod.builder().returnType("String").name("getTest").build());
    }

    @Test
    public void testAssertMethodEqualsBothNull() {
        JavaCodeTypeTest.assertMethodEquals(null, null);
    }

    @Test
    public void testAssertMethodEqualsMethod1NullMethod2Not() {
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getTest").build();
        try {
            JavaCodeTypeTest.assertMethodEquals(null, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the methods is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError(null, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsMethod2NullMethod1Not() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("getTest").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, null);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the methods is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError((Object)method1, null)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsEditable() {
        JavaMethod method1 = UneditableJavaMethod.builder().returnType("String").name("getTest").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getTest").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsJavadoc() {
        JavaMethod method1 = EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().build()).returnType("String").name("getTest").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getTest").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsAnnotationsLength() {
        JavaMethod method1 = EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).returnType("String").name("getTest").build();
        JavaMethod method2 = EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).returnType("String").name("getTest").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Annotations length is different!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsAnnotationsLength1() {
        JavaMethod method1 = EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).returnType("String").name("getTest").build();
        JavaMethod method2 = EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).returnType("String").name("getTest").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Annotations length is different!\nAnnotations differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsAnnotationsContent() {
        JavaMethod method1 = EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).returnType("String").name("getTest").build();
        JavaMethod method2 = EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getDerp").build()).returnType("String").name("getTest").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Annotations differs on #1:\n\tName is different!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsVisibility() {
        JavaMethod method1 = EditableJavaMethod.builder().visibility(Visibility.PUBLIC).returnType("String").name("getTest").build();
        JavaMethod method2 = EditableJavaMethod.builder().visibility(Visibility.PRIVATE).returnType("String").name("getTest").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Visibility is different!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsAbstract() {
        JavaMethod method1 = EditableJavaMethod.builder().isAbstract().returnType("String").name("getTest").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getTest").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Abstract is different!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsStatic() {
        JavaMethod method1 = EditableJavaMethod.builder().isStatic().returnType("String").name("getTest").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getTest").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Static is different!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsFinal() {
        JavaMethod method1 = EditableJavaMethod.builder().isFinal().returnType("String").name("getTest").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getTest").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Final is different!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsReturnType() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("int").name("getTest").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getTest").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Return Type is different!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsName() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("getVersion").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getTest").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Name is different!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsParamsLength() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("getVersion").parameter("String", "version").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getVersion").parameter("String", "version").parameter("int", "version").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Parameters length is different!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsParamsLength1Longer() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("getVersion").parameter("String", "version").parameter("int", "version").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getVersion").parameter("String", "version").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Parameters length is different!\nParameters differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsThrowsTypes() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("NoException").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Throw Types differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsThrowsTypesLength() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").throwType("NoException").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Throw Types length is different!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsThrowsTypesLength1Longer() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").throwType("NoException").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Throw Types length is different!\nThrow Types differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsContent() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getVersion").line("return this;").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Content differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsContentLength() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").line("return this;").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Content length is different!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsContentLength1Longer() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").line("return this;").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Content length is different!\nContent differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMethodEqualsAll() {
        JavaMethod method1 = EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().build()).annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).visibility(Visibility.PUBLIC).isAbstract().returnType("int").name("getVersion").parameter("String", "version").parameter("int", "version").throwType("Exception").throwType("NoException").build();
        JavaMethod method2 = UneditableJavaMethod.builder().annotation(UneditableJavaAnnotation.builder().name("getDerp").build()).visibility(Visibility.PRIVATE).returnType("String").name("getTest").parameter("String", "version").throwType("Exception").build();
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)method1, (JavaMethod)method2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!\nJavadoc differs:\n\tOne of the Javadocs is null, and the other isn't!\nAnnotations length is different!\nAnnotations differs on #1:\n\tEditable is different!\n\tName is different!\nAnnotations differs on #2!\nVisibility is different!\nAbstract is different!\nReturn Type is different!\nName is different!\nParameters length is different!\nParameters differs on #2!\nThrow Types length is different!\nThrow Types differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)method1, (Object)method2)), (Object)e.getMessage());
        }
    }
}

