/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.comment.UneditableJavaSingleLineComment;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestSingleLineCommentTest {
    @Test
    public void testFindSingleLineCommentDifferencesNone() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findSingleLineCommentDifferences((JavaSingleLineComment)EditableJavaSingleLineComment.builder().content("Something useful").build(), (JavaSingleLineComment)EditableJavaSingleLineComment.builder().content("Something useful").build()));
    }

    @Test
    public void testFindSingleLineCommentDifferencesBothNull() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findSingleLineCommentDifferences(null, null));
    }

    @Test
    public void testFindSingleLineCommentDifferencesComment1NullComment2Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the single-line comments is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findSingleLineCommentDifferences(null, (JavaSingleLineComment)EditableJavaSingleLineComment.builder().content("Something useful").build()));
    }

    @Test
    public void testFindSingleLineCommentDifferencesComment2NullComment1Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the single-line comments is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findSingleLineCommentDifferences((JavaSingleLineComment)EditableJavaSingleLineComment.builder().content("Something useful").build(), null));
    }

    @Test
    public void testFindSingleLineCommentDifferencesEditable() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!"}), (Object)JavaCodeTypeTest.findSingleLineCommentDifferences((JavaSingleLineComment)UneditableJavaSingleLineComment.builder().content("Something useful").build(), (JavaSingleLineComment)EditableJavaSingleLineComment.builder().content("Something useful").build()));
    }

    @Test
    public void testFindSingleLineCommentDifferencesContent() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Content is different!"}), (Object)JavaCodeTypeTest.findSingleLineCommentDifferences((JavaSingleLineComment)EditableJavaSingleLineComment.builder().content("Something useful").build(), (JavaSingleLineComment)EditableJavaSingleLineComment.builder().content("Something else useful").build()));
    }

    @Test
    public void testFindSingleLineCommentDifferencesAll() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!", "Content is different!"}), (Object)JavaCodeTypeTest.findSingleLineCommentDifferences((JavaSingleLineComment)UneditableJavaSingleLineComment.builder().content("Something useful").build(), (JavaSingleLineComment)EditableJavaSingleLineComment.builder().content("Something else useful").build()));
    }

    @Test
    public void testAssertSingleLineCommentEqualsNone() {
        JavaCodeTypeTest.assertSingleLineCommentEquals((JavaSingleLineComment)EditableJavaSingleLineComment.builder().content("Something useful").build(), (JavaSingleLineComment)EditableJavaSingleLineComment.builder().content("Something useful").build());
    }

    @Test
    public void testAssertSingleLineCommentEqualsBothNull() {
        JavaCodeTypeTest.assertSingleLineCommentEquals(null, null);
    }

    @Test
    public void testAssertSingleLineCommentEqualsComment1NullComment2Not() {
        JavaSingleLineComment comment2 = EditableJavaSingleLineComment.builder().content("Something useful").build();
        try {
            JavaCodeTypeTest.assertSingleLineCommentEquals(null, (JavaSingleLineComment)comment2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the single-line comments is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError(null, (Object)comment2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertSingleLineCommentEqualsComment2NullComment1Not() {
        JavaSingleLineComment comment1 = EditableJavaSingleLineComment.builder().content("Something useful").build();
        try {
            JavaCodeTypeTest.assertSingleLineCommentEquals((JavaSingleLineComment)comment1, null);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the single-line comments is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError((Object)comment1, null)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertSingleLineCommentEqualsEditable() {
        JavaSingleLineComment comment1 = UneditableJavaSingleLineComment.builder().content("Something useful").build();
        JavaSingleLineComment comment2 = EditableJavaSingleLineComment.builder().content("Something useful").build();
        try {
            JavaCodeTypeTest.assertSingleLineCommentEquals((JavaSingleLineComment)comment1, (JavaSingleLineComment)comment2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!", (String)AssertionFailedErrors.buildAssertError((Object)comment1, (Object)comment2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertSingleLineCommentEqualsContent() {
        JavaSingleLineComment comment1 = EditableJavaSingleLineComment.builder().content("Something useful").build();
        JavaSingleLineComment comment2 = EditableJavaSingleLineComment.builder().content("Something else useful").build();
        try {
            JavaCodeTypeTest.assertSingleLineCommentEquals((JavaSingleLineComment)comment1, (JavaSingleLineComment)comment2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Content is different!", (String)AssertionFailedErrors.buildAssertError((Object)comment1, (Object)comment2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertSingleLineCommentEqualsAll() {
        JavaSingleLineComment comment1 = UneditableJavaSingleLineComment.builder().content("Something useful").build();
        JavaSingleLineComment comment2 = EditableJavaSingleLineComment.builder().content("Something else useful").build();
        try {
            JavaCodeTypeTest.assertSingleLineCommentEquals((JavaSingleLineComment)comment1, (JavaSingleLineComment)comment2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!\nContent is different!", (String)AssertionFailedErrors.buildAssertError((Object)comment1, (Object)comment2)), (Object)e.getMessage());
        }
    }
}

