/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing.form.field;

import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.testing.JavaClassParsingTest;
import org.junit.jupiter.api.Disabled;

@Disabled
public class FormFieldBuilderTest
extends JavaClassParsingTest {
    protected FormFieldBuilderTest() {
        super("package com.github.tadukoo.view.form.field.annotation;\n\nimport com.github.tadukoo.java.JavaCodeTypes;\nimport com.github.tadukoo.java.annotation.EditableJavaAnnotation;\nimport com.github.tadukoo.java.comment.EditableJavaMultiLineComment;\nimport com.github.tadukoo.java.field.JavaField;\nimport com.github.tadukoo.java.javaclass.EditableJavaClass;\nimport com.github.tadukoo.java.javaclass.JavaClass;\nimport com.github.tadukoo.java.Visibility;\nimport com.github.tadukoo.java.javaclass.JavaClassBuilder;\nimport com.github.tadukoo.java.javadoc.EditableJavadoc;\nimport com.github.tadukoo.java.javadoc.Javadoc;\nimport com.github.tadukoo.java.javadoc.JavadocBuilder;\nimport com.github.tadukoo.java.method.EditableJavaMethod;\nimport com.github.tadukoo.java.method.JavaMethod;\nimport com.github.tadukoo.java.method.JavaMethodBuilder;\nimport com.github.tadukoo.ultimatepower.UltimatePowerProcessor;\nimport com.github.tadukoo.util.ListUtil;\nimport com.github.tadukoo.util.StringUtil;\nimport com.github.tadukoo.util.logger.EasyLogger;\nimport com.github.tadukoo.util.map.HashMultiMap;\nimport com.github.tadukoo.util.map.MultiMap;\nimport com.github.tadukoo.util.tuple.Pair;\nimport com.github.tadukoo.util.tuple.Triple;\nimport com.github.tadukoo.view.font.FontFamily;\nimport com.github.tadukoo.view.font.FontResourceLoader;\nimport com.github.tadukoo.view.form.field.FieldType;\nimport com.github.tadukoo.view.form.field.LabelType;\nimport com.github.tadukoo.view.paint.SizablePaint;\nimport com.github.tadukoo.view.shapes.ShapeInfo;\n\nimport javax.swing.border.Border;\nimport java.awt.GraphicsEnvironment;\nimport java.lang.annotation.Annotation;\nimport java.util.ArrayList;\nimport java.util.List;\n\npublic class FormFieldBuilderProcessor implements UltimatePowerProcessor{\n\t\n\t/** {@inheritDoc} */\n\t@Override\n\tpublic List<Class<? extends Annotation>> getAnnotations(){\n\t\treturn ListUtil.createList(FormFieldBuilder.class);\n\t}\n\t\n\tpublic record Parameter(\n\t\t\tString name, String description, String defaultValueOrRequired, String type,\n\t\t\tList<Parameter> params){ }\n\t\n\tprivate FormFieldBuilder verifyAnnotation(List<? extends Annotation> annotations){\n\t\tif(annotations.size() > 1){\n\t\t\tthrow new IllegalArgumentException(\"Expecting a single annotation!\");\n\t\t}\n\t\tif(!(annotations.get(0) instanceof FormFieldBuilder annotation)){\n\t\t\tClass<?> annotationClass = annotations.get(0).getClass();\n\t\t\tthrow new IllegalArgumentException(\"Expecting the FormFieldBuilder (\" +\n\t\t\t\t\tFormFieldBuilder.class.getCanonicalName() + \") annotation, not \" + annotationClass.getName() +\n\t\t\t\t\t\"(\" + annotationClass.getCanonicalName() + \")\");\n\t\t}\n\t\treturn annotation;\n\t}\n\t\n\t@Override\n\tpublic List<JavaClass> generateInnerClasses(List<? extends Annotation> annotations, JavaClass javaClass){\n\t\t// Grab the pieces of the annotation\n\t\tFormFieldBuilder annotation = verifyAnnotation(annotations);\n\t\tClass<?> type = annotation.type();\n\t\tString defaultDefaultValue = annotation.defaultDefaultValue();\n\t\tLabelType defaultLabelType = annotation.defaultLabelType();\n\t\t\n\t\t// Grab values needed for the builder class\n\t\tString className = javaClass.getClassName();\n\t\tString builderClassName = className + \"Builder\";\n\t\tString valueType = type.getSimpleName();\n\t\t\n\t\t// Grab author and version from the Javadoc of the class or use defaults\n\t\tString author = \"FormFieldBuilderProcessor\";\n\t\tString version = \"Placeholder\";\n\t\tif(javaClass.getJavadoc() != null){\n\t\t\tJavadoc javadoc = javaClass.getJavadoc();\n\t\t\tif(StringUtil.isNotBlank(javadoc.getAuthor())){\n\t\t\t\tauthor = javadoc.getAuthor();\n\t\t\t}\n\t\t\tif(StringUtil.isNotBlank(javadoc.getVersion())){\n\t\t\t\tversion = javadoc.getVersion();\n\t\t\t}\n\t\t}\n\t\t\n\t\t// Grab the parameters we need\n\t\tTriple<List<String>, List<Parameter>, MultiMap<String, Parameter>> parameterInfo = getParameters(valueType);\n\t\tList<String> parameterCategories = parameterInfo.getLeft();\n\t\tList<Parameter> parametersInOrder = parameterInfo.getMiddle();\n\t\tMultiMap<String, Parameter> parameterMap = parameterInfo.getRight();\n\t\t\n\t\t// Start building builder class\n\t\tJavaClassBuilder<EditableJavaClass> builderClass = EditableJavaClass.builder()\n\t\t\t\t.innerClass()\n\t\t\t\t// Javadoc\n\t\t\t\t.javadoc(EditableJavadoc.builder()\n\t\t\t\t\t\t.content(createBuilderJavadocContent(className, parametersInOrder))\n\t\t\t\t\t\t.author(author)\n\t\t\t\t\t\t.version(version)\n\t\t\t\t\t\t.build())\n\t\t\t\t// Class Declaration\n\t\t\t\t.visibility(Visibility.PUBLIC)\n\t\t\t\t.isStatic().className(builderClassName).superClassName(\"FormFieldBuilder<\" + valueType + \">\");\n\t\t\n\t\t// Start the Constructor\n\t\tJavaMethodBuilder<EditableJavaMethod> constructorMethod = EditableJavaMethod.builder()\n\t\t\t\t\t\t.javadoc(EditableJavadoc.builder()\n\t\t\t\t\t\t\t\t.condensed()\n\t\t\t\t\t\t\t\t.content(\"Can't create \" + builderClassName + \" outside \" + className)\n\t\t\t\t\t\t\t\t.build())\n\t\t\t\t\t\t.visibility(Visibility.PRIVATE)\n\t\t\t\t\t\t.returnType(builderClassName)\n\t\t\t\t\t\t.line(\"super();\")\n\t\t\t\t\t\t.line(\"defaultValue = \" + defaultDefaultValue +\";\");\n\t\tif(defaultLabelType != FormFieldBuilder.DEFAULT_defaultLabelType){\n\t\t\tconstructorMethod.line(\"labelType = LabelType.\" + defaultLabelType.name() + \";\");\n\t\t}\n\t\t// Add the constructor to the class\n\t\tbuilderClass.method(constructorMethod.build());\n\t\t\n\t\t// Handle parameters\n\t\tfor(String parameterCategory: parameterCategories){\n\t\t\t// Add section comment\n\t\t\tbuilderClass.multiLineComment(EditableJavaMultiLineComment.builder()\n\t\t\t\t\t.content(parameterCategory)\n\t\t\t\t\t.build());\n\t\t\t\n\t\t\t// Grab parameters and add them\n\t\t\tfor(Parameter parameter: parameterMap.get(parameterCategory)){\n\t\t\t\tJavaMethodBuilder<EditableJavaMethod> parameterMethod = EditableJavaMethod.builder()\n\t\t\t\t\t\t.javadoc(EditableJavadoc.builder()\n\t\t\t\t\t\t\t\t.condensed()\n\t\t\t\t\t\t\t\t.content(\"{@inheritDoc}\")\n\t\t\t\t\t\t\t\t.build())\n\t\t\t\t\t\t.annotation(EditableJavaAnnotation.builder()\n\t\t\t\t\t\t\t\t.name(\"Override\")\n\t\t\t\t\t\t\t\t.build())\n\t\t\t\t\t\t.visibility(Visibility.PUBLIC)\n\t\t\t\t\t\t.returnType(builderClassName).name(parameter.name());\n\t\t\t\t\n\t\t\t\t// Parameters can vary\n\t\t\t\tif(ListUtil.isNotBlank(parameter.params())){\n\t\t\t\t\tStringBuilder superMethodCallParams = new StringBuilder();\n\t\t\t\t\tfor(Parameter param: parameter.params()){\n\t\t\t\t\t\tparameterMethod.parameter(param.type(), param.name());\n\t\t\t\t\t\tsuperMethodCallParams.append(param.name()).append(\", \");\n\t\t\t\t\t}\n\t\t\t\t\tsuperMethodCallParams.delete(superMethodCallParams.length()-2, superMethodCallParams.length());\n\t\t\t\t\tparameterMethod.line(\"super.\" + parameter.name() + \"(\" + superMethodCallParams + \");\");\n\t\t\t\t}else{\n\t\t\t\t\tparameterMethod.parameter(parameter.type(), parameter.name());\n\t\t\t\t\tparameterMethod.line(\"super.\" + parameter.name() + \"(\" + parameter.name() + \");\");\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\t// Finish the method and add to builder class\n\t\t\t\tbuilderClass.method(parameterMethod.line(\"return this;\")\n\t\t\t\t\t\t.build());\n\t\t\t}\n\t\t}\n\t\t\n\t\t// Create the build method\n\t\tJavaMethodBuilder<EditableJavaMethod> buildMethod = EditableJavaMethod.builder()\n\t\t\t\t.javadoc(EditableJavadoc.builder()\n\t\t\t\t\t\t.condensed()\n\t\t\t\t\t\t.content(\"{@inheritDoc}\")\n\t\t\t\t\t\t.build())\n\t\t\t\t.annotation(EditableJavaAnnotation.builder()\n\t\t\t\t\t\t.name(\"Override\")\n\t\t\t\t\t\t.build())\n\t\t\t\t.visibility(Visibility.PUBLIC).returnType(className).name(\"build\");\n\t\tfor(int i = 0; i < parameterCategories.size(); i++){\n\t\t\tString parameterCategory = parameterCategories.get(i);\n\t\t\tStringBuilder start;\n\t\t\tif(i == 0){\n\t\t\t\tstart = new StringBuilder(\"return new \" + className + \"(\");\n\t\t\t}else{\n\t\t\t\tstart = new StringBuilder(\"\\t\\t\");\n\t\t\t}\n\t\t\tfor(Parameter parameter: parameterMap.get(parameterCategory)){\n\t\t\t\tif(ListUtil.isBlank(parameter.params())){\n\t\t\t\t\tstart.append(parameter.name()).append(\", \");\n\t\t\t\t}else{\n\t\t\t\t\tfor(Parameter param: parameter.params()){\n\t\t\t\t\t\tstart.append(param.name()).append(\", \");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\t\n\t\t\tif(i == parameterCategories.size() - 1){\n\t\t\t\tstart.delete(start.length()-2, start.length());\n\t\t\t\tstart.append(\");\");\n\t\t\t}else{\n\t\t\t\tstart.delete(start.length()-1, start.length());\n\t\t\t}\n\t\t\t\n\t\t\tbuildMethod.line(start.toString());\n\t\t}\n\t\tbuilderClass.method(buildMethod.build());\n\t\t\n\t\treturn ListUtil.createList(builderClass.build());\n\t}\n\t\n\tprivate Triple<List<String>, List<Parameter>, MultiMap<String, Parameter>> getParameters(String valueType){\n\t\tList<String> parameterCategories = new ArrayList<>();\n\t\tList<Parameter> parametersInOrder = new ArrayList<>();\n\t\tMultiMap<String, Parameter> parameterMap = new HashMultiMap<>();\n\t\t\n\t\t/*\n\t\t * The Basics\n\t\t */\n\t\tString theBasicsCategory = \"The Basics\";\n\t\tparameterCategories.add(theBasicsCategory);\n\t\tParameter key = new Parameter(\"key\", \"The name of the field (used as a key in forms)\",\n\t\t\t\t\"Required\", \"String\", null);\n\t\tparametersInOrder.add(key);\n\t\tparameterMap.put(theBasicsCategory, key);\n\t\t\n\t\tParameter defaultValue = new Parameter(\"defaultValue\", \"The starting value of the field\",\n\t\t\t\t\"Defaults to the empty String\", valueType, null);\n\t\tparametersInOrder.add(defaultValue);\n\t\tparameterMap.put(theBasicsCategory, defaultValue);\n\t\t\n\t\t/*\n\t\t * Label Settings\n\t\t */\n\t\tString labelSettingsCategory = \"Label Settings\";\n\t\tparameterCategories.add(labelSettingsCategory);\n\t\tParameter labelType = new Parameter(\"labelType\", \"The {@link LabelType} to use for the field\",\n\t\t\t\t\"Defaults to {@link LabelType#NONE}\", \"LabelType\", null);\n\t\tparametersInOrder.add(labelType);\n\t\tparameterMap.put(labelSettingsCategory, labelType);\n\t\t\n\t\tParameter labelForegroundPaint = new Parameter(\"labelForegroundPaint\",\n\t\t\t\t\"The {@link SizablePaint} for the foreground of the Label\",\n\t\t\t\t\"Defaults to null (to use the Look &amp; Feel's default Label foreground paint)\",\n\t\t\t\t\"SizablePaint\", null);\n\t\tparametersInOrder.add(labelForegroundPaint);\n\t\tparameterMap.put(labelSettingsCategory, labelForegroundPaint);\n\t\t\n\t\tParameter labelBackgroundPaint = new Parameter(\"labelBackgroundPaint\",\n\t\t\t\t\"The {@link SizablePaint} for the background of the Label\",\n\t\t\t\t\"Defaults to null (to use the Look &amp; Feel's default Label background paint)\",\n\t\t\t\t\"SizablePaint\", null);\n\t\tparametersInOrder.add(labelBackgroundPaint);\n\t\tparameterMap.put(labelSettingsCategory, labelBackgroundPaint);\n\t\t\n\t\tParameter labelFont = new Parameter(\"labelFont\",\n\t\t\t\t\"The font to use for the Label - specified as a {@link FontFamily}, style, and size\",\n\t\t\t\t\"Defaults to null (to use the Look &amp; Feel's default Label font)\",\n\t\t\t\tnull, ListUtil.createList(\n\t\t\t\t\t\tnew Parameter(\"labelFontFamily\", \"The {@link FontFamily} for the Label's font\",\n\t\t\t\t\t\t\t\tnull, \"FontFamily\", null),\n\t\t\t\t\t\tnew Parameter(\"labelFontStyle\", \"The font style for the Label\",\n\t\t\t\t\t\t\t\tnull, \"int\", null),\n\t\t\t\t\t\tnew Parameter(\"labelFontSize\", \"The font size for the Label\",\n\t\t\t\t\t\t\t\tnull, \"int\", null)));\n\t\tparametersInOrder.add(labelFont);\n\t\tparameterMap.put(labelSettingsCategory, labelFont);\n\t\t\n\t\tParameter labelShape = new Parameter(\"labelShape\",\n\t\t\t\t\"The {@link ShapeInfo} to use for the Label\",\n\t\t\t\t\"Defaults to null (to use the Look &amp; Feel's default Label shape)\",\n\t\t\t\t\"ShapeInfo\", null);\n\t\tparametersInOrder.add(labelShape);\n\t\tparameterMap.put(labelSettingsCategory, labelShape);\n\t\t\n\t\tParameter labelBorder = new Parameter(\"labelBorder\",\n\t\t\t\t\"The {@link Border} to use for the Label\",\n\t\t\t\t\"Defaults to null (to use the Look &amp; Feel's default Label border)\",\n\t\t\t\t\"Border\", null);\n\t\tparametersInOrder.add(labelBorder);\n\t\tparameterMap.put(labelSettingsCategory, labelBorder);\n\t\t\n\t\t/*\n\t\t * Positioning\n\t\t */\n\t\tString positioningCategory = \"Positioning\";\n\t\tparameterCategories.add(positioningCategory);\n\t\tParameter rowPos = new Parameter(\"rowPos\",\n\t\t\t\t\"The row position of the field\", \"Required\",\n\t\t\t\t\"int\", null);\n\t\tparametersInOrder.add(rowPos);\n\t\tparameterMap.put(positioningCategory, rowPos);\n\t\t\n\t\tParameter colPos = new Parameter(\"colPos\",\n\t\t\t\t\"The column position of the field\", \"Required\",\n\t\t\t\t\"int\", null);\n\t\tparametersInOrder.add(colPos);\n\t\tparameterMap.put(positioningCategory, colPos);\n\t\t\n\t\tParameter rowSpan = new Parameter(\"rowSpan\",\n\t\t\t\t\"The row span of the field\", \"Defaults to 1\",\n\t\t\t\t\"int\", null);\n\t\tparametersInOrder.add(rowSpan);\n\t\tparameterMap.put(positioningCategory, rowSpan);\n\t\t\n\t\tParameter colSpan = new Parameter(\"colSpan\",\n\t\t\t\t\"The column span of the field\", \"Defaults to 1\",\n\t\t\t\t\"int\", null);\n\t\tparametersInOrder.add(colSpan);\n\t\tparameterMap.put(positioningCategory, colSpan);\n\t\t\n\t\t/*\n\t\t * Font Resource Loading\n\t\t */\n\t\tString fontResourceLoadingCategory = \"Font Resource Loading\";\n\t\tparameterCategories.add(fontResourceLoadingCategory);\n\t\tParameter logFontResourceLoaderWarnings = new Parameter(\"logFontResourceLoaderWarnings\",\n\t\t\t\t\"Whether to log warnings generated by the FontResourceLoader\\n\" +\n\t\t\t\t\t\t\"- can be ignored if you specify your own FontResourceLoader\",\n\t\t\t\t\"false\", \"boolean\", null);\n\t\tparametersInOrder.add(logFontResourceLoaderWarnings);\n\t\tparameterMap.put(fontResourceLoadingCategory, logFontResourceLoaderWarnings);\n\t\t\n\t\tParameter logger = new Parameter(\"logger\",\n\t\t\t\t\"An {@link EasyLogger} that will be sent to the FontResourceLoader by default\\n\" +\n\t\t\t\t\t\t\"- can be ignored if you specify your own FontResourceLoader\",\n\t\t\t\t\"null (since logging warnings is set to false by default)\",\n\t\t\t\t\"EasyLogger\", null);\n\t\tparametersInOrder.add(logger);\n\t\tparameterMap.put(fontResourceLoadingCategory, logger);\n\t\t\n\t\tParameter graphEnv = new Parameter(\"graphEnv\",\n\t\t\t\t\"The {@link GraphicsEnvironment} to load fonts to in the FontResourceLoader\\n\" +\n\t\t\t\t\t\t\"- can be ignored if you specify your own FontResourceLoader\",\n\t\t\t\t\"{@link GraphicsEnvironment#getLocalGraphicsEnvironment()}\",\n\t\t\t\t\"GraphicsEnvironment\", null);\n\t\tparametersInOrder.add(graphEnv);\n\t\tparameterMap.put(fontResourceLoadingCategory, graphEnv);\n\t\t\n\t\tParameter fontFolder = new Parameter(\"fontFolder\",\n\t\t\t\t\"The path to the fonts folder to find font files in if needed in the FontResourceLoader\\n\" +\n\t\t\t\t\t\t\"- can be ignored if you specify your own FontResourceLoader\",\n\t\t\t\t\"\\\"fonts/\\\"\",\n\t\t\t\t\"String\", null);\n\t\tparametersInOrder.add(fontFolder);\n\t\tparameterMap.put(fontResourceLoadingCategory, fontFolder);\n\t\t\n\t\tParameter fontResourceLoader = new Parameter(\"fontResourceLoader\",\n\t\t\t\t\"The {@link FontResourceLoader} to use in loading fonts and/or ensuring they're in the system\",\n\t\t\t\t\"a new FontResourceLoader with the specified values for {@link #logFontResourceLoaderWarnings},\\n\" +\n\t\t\t\t\t\t\"{@link #logger}, {@link #graphEnv}, and {@link #fontFolder}\",\n\t\t\t\t\"FontResourceLoader\", null);\n\t\tparametersInOrder.add(fontResourceLoader);\n\t\tparameterMap.put(fontResourceLoadingCategory, fontResourceLoader);\n\t\t\n\t\treturn Triple.of(parameterCategories, parametersInOrder, parameterMap);\n\t}\n\t\n\tprivate List<String> createBuilderJavadocContent(String className, List<Parameter> parameters){\n\t\tList<String> content = ListUtil.createList(\n\t\t\t\t\"Builder to be used to create a {@link \" + className + \"}. \" +\n\t\t\t\t\t\t\"It has the following parameters:\",\n\t\t\t\t\"\",\n\t\t\t\t\"<table>\",\n\t\t\t\t\"\\t<caption>\" + className + \" Parameters</caption>\",\n\t\t\t\t\"\\t<tr>\",\n\t\t\t\t\"\\t\\t<th>Name</th>\",\n\t\t\t\t\"\\t\\t<th>Description</th>\",\n\t\t\t\t\"\\t\\t<th>Default Value or Required</th>\",\n\t\t\t\t\"\\t</tr>\"\n\t\t);\n\t\t\n\t\tfor(Parameter parameter: parameters){\n\t\t\tcontent.add(\"\\t<tr>\");\n\t\t\tcontent.add(\"\\t\\t<td>\" + parameter.name() + \"</td>\");\n\t\t\tcontent.add(\"\\t\\t<td>\" + parameter.description().replace(\"\\n\", \"\\n * \\t\\t\") + \"</td>\");\n\t\t\tcontent.add(\"\\t\\t<td>\" + parameter.defaultValueOrRequired().replace(\"\\n\", \"\\n * \\t\\t\") + \"</td>\");\n\t\t\tcontent.add(\"\\t</tr>\");\n\t\t}\n\t\t\n\t\tcontent.add(\"</table>\");\n\t\treturn content;\n\t}\n\t\n\t@Override\n\tpublic List<JavaField> generateFields(List<? extends Annotation> annotations, JavaClass javaClass){\n\t\treturn new ArrayList<>();\n\t}\n\t\n\t@Override\n\tpublic List<JavaMethod> generateMethods(List<? extends Annotation> annotations, JavaClass javaClass){\n\t\t// Grab the pieces of the annotation\n\t\tFormFieldBuilder annotation = verifyAnnotation(annotations);\n\t\tClass<?> type = annotation.type();\n\t\t\n\t\t// Grab class name from the class\n\t\tString className = javaClass.getClassName();\n\t\tString builderClassName = className + \"Builder\";\n\t\t\n\t\t// Grab parameters\n\t\tTriple<List<String>, List<Parameter>, MultiMap<String, Parameter>> parameterInfo = getParameters(type.getSimpleName());\n\t\tList<String> parameterCategories = parameterInfo.getLeft();\n\t\tList<Parameter> parametersInOrder = parameterInfo.getMiddle();\n\t\tMultiMap<String, Parameter> parameterMap = parameterInfo.getRight();\n\t\t\n\t\t// Create start of the constructor Javadoc and constructor method\n\t\tJavadocBuilder<EditableJavadoc> constructorJavadoc = EditableJavadoc.builder()\n\t\t\t\t.content(\"Creates a new \" + className + \" with the given parameters.\");\n\t\tJavaMethodBuilder<EditableJavaMethod> constructor = EditableJavaMethod.builder()\n\t\t\t\t.visibility(Visibility.PRIVATE).returnType(className);\n\t\t\n\t\t// Handle parameters\n\t\tfor(Parameter parameter: parametersInOrder){\n\t\t\tif(ListUtil.isBlank(parameter.params())){\n\t\t\t\tconstructorJavadoc.param(parameter.name(), parameter.description().replace(\"\\n\", \"\\n * \"));\n\t\t\t\tconstructor.parameter(parameter.type(), parameter.name());\n\t\t\t}else{\n\t\t\t\tfor(Parameter param: parameter.params()){\n\t\t\t\t\tconstructorJavadoc.param(param.name(), param.description().replace(\"\\n\", \"\\n * \"));\n\t\t\t\t\tconstructor.parameter(param.type(), param.name());\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tfor(int i = 0; i < parameterCategories.size(); i++){\n\t\t\tString parameterCategory = parameterCategories.get(i);\n\t\t\tStringBuilder start;\n\t\t\tif(i == 0){\n\t\t\t\tstart = new StringBuilder(\"super(FieldType.LABEL, \");\n\t\t\t}else{\n\t\t\t\tstart = new StringBuilder(\"\\t\\t\");\n\t\t\t}\n\t\t\tfor(Parameter parameter: parameterMap.get(parameterCategory)){\n\t\t\t\tif(ListUtil.isBlank(parameter.params())){\n\t\t\t\t\tstart.append(parameter.name()).append(\", \");\n\t\t\t\t}else{\n\t\t\t\t\tfor(Parameter param: parameter.params()){\n\t\t\t\t\t\tstart.append(param.name()).append(\", \");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\t\n\t\t\tif(i == parameterCategories.size() - 1){\n\t\t\t\tstart.delete(start.length()-2, start.length());\n\t\t\t\tstart.append(\");\");\n\t\t\t}else{\n\t\t\t\tstart.delete(start.length()-1, start.length());\n\t\t\t}\n\t\t\t\n\t\t\tconstructor.line(start.toString());\n\t\t}\n\t\t\n\t\t// Complete the constructor\n\t\tJavaMethod constructorMethod = constructor.javadoc(constructorJavadoc.build())\n\t\t\t\t.build();\n\t\t\n\t\t// Create builder method\n\t\tJavaMethod builderMethod = EditableJavaMethod.builder()\n\t\t\t\t.javadoc(EditableJavadoc.builder()\n\t\t\t\t\t\t.returnVal(\"A {@link \" + builderClassName + \" builder} to use to build a {@link \" + className + \"}\")\n\t\t\t\t\t\t.build())\n\t\t\t\t.visibility(Visibility.PUBLIC).isStatic()\n\t\t\t\t.returnType(builderClassName).name(\"builder\")\n\t\t\t\t.line(\"return new \" + builderClassName + \"();\")\n\t\t\t\t.build();\n\t\t\n\t\treturn ListUtil.createList(constructorMethod, builderMethod);\n\t}\n\t\n\t@Override\n\tpublic JavaClass makeOtherChanges(List<? extends Annotation> annotations, JavaClass javaClass){\n\t\t// Grab the pieces of the annotation\n\t\tFormFieldBuilder annotation = verifyAnnotation(annotations);\n\t\tClass<?> type = annotation.type();\n\t\t\n\t\t// Ensure we have an EditableJavaClass\n\t\tif(!(javaClass instanceof EditableJavaClass clazz)){\n\t\t\tthrow new IllegalArgumentException(\"Java Class should be EditableJavaClass!\");\n\t\t}\n\t\t\n\t\t// Add needed imports\n\t\tclazz.addImportNames(ListUtil.createList(\n\t\t\t\tEasyLogger.class.getCanonicalName(),\n\t\t\t\tFontFamily.class.getCanonicalName(),\n\t\t\t\tFontResourceLoader.class.getCanonicalName(),\n\t\t\t\tFieldType.class.getCanonicalName(),\n\t\t\t\tLabelType.class.getCanonicalName(),\n\t\t\t\tSizablePaint.class.getCanonicalName(),\n\t\t\t\tShapeInfo.class.getCanonicalName(),\n\t\t\t\tBorder.class.getCanonicalName(),\n\t\t\t\tGraphicsEnvironment.class.getCanonicalName()),\n\t\t\t\tfalse);\n\t\t\n\t\t// Grab parameters and determine constructor method signature\n\t\tList<Parameter> parametersInOrder = getParameters(type.getSimpleName()).getMiddle();\n\t\tStringBuilder constructorSignature = new StringBuilder(\"init(\");\n\t\tfor(Parameter parameter: parametersInOrder){\n\t\t\tif(ListUtil.isBlank(parameter.params())){\n\t\t\t\tconstructorSignature.append(parameter.type()).append(' ').append(parameter.name()).append(\", \");\n\t\t\t}else{\n\t\t\t\tfor(Parameter param: parameter.params()){\n\t\t\t\t\tconstructorSignature.append(param.type()).append(' ').append(param.name()).append(\", \");\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tconstructorSignature.delete(constructorSignature.length()-2, constructorSignature.length());\n\t\tconstructorSignature.append(')');\n\t\t\n\t\t// Change the order of methods\n\t\tList<Pair<JavaCodeTypes, String>> innerElementsOrder = clazz.getInnerElementsOrder();\n\t\tString builderClassName = javaClass.getClassName() + \"Builder\";\n\t\tPair<JavaCodeTypes, String> builderClass = null, constructorMethod = null, builderMethod = null;\n\t\tfor(Pair<JavaCodeTypes, String> elementInfo: innerElementsOrder){\n\t\t\tif(elementInfo.getLeft() == JavaCodeTypes.CLASS &&\n\t\t\t\t\tStringUtil.equalsIgnoreCase(elementInfo.getRight(), builderClassName)){\n\t\t\t\tbuilderClass = elementInfo;\n\t\t\t}else if(elementInfo.getLeft() == JavaCodeTypes.METHOD){\n\t\t\t\tif(StringUtil.equalsIgnoreCase(elementInfo.getRight(), constructorSignature.toString())){\n\t\t\t\t\tconstructorMethod = elementInfo;\n\t\t\t\t}else if(StringUtil.equalsIgnoreCase(elementInfo.getRight(), \"builder()\")){\n\t\t\t\t\tbuilderMethod = elementInfo;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\t// Create new order\n\t\tList<Pair<JavaCodeTypes, String>> newElementsOrder = new ArrayList<>();\n\t\tif(builderClass != null){\n\t\t\tnewElementsOrder.add(builderClass);\n\t\t\tinnerElementsOrder.remove(builderClass);\n\t\t}\n\t\tif(constructorMethod != null){\n\t\t\tnewElementsOrder.add(constructorMethod);\n\t\t\tinnerElementsOrder.remove(constructorMethod);\n\t\t}\n\t\tif(builderMethod != null){\n\t\t\tnewElementsOrder.add(builderMethod);\n\t\t\tinnerElementsOrder.remove(builderMethod);\n\t\t}\n\t\tnewElementsOrder.addAll(innerElementsOrder);\n\t\tclazz.setInnerElementsOrder(newElementsOrder);\n\t\t\n\t\treturn clazz;\n\t}\n}\n", EditableJavaClass.builder().packageName("com.github.tadukoo.view.form.field.annotation").importName("com.github.tadukoo.java.JavaCodeTypes", false).importName("import com.github.tadukoo.java.annotation.EditableJavaAnnotation", false).importName("com.github.tadukoo.java.comment.EditableJavaMultiLineComment", false).importName("com.github.tadukoo.java.field.JavaField", false).importName("com.github.tadukoo.java.javaclass.EditableJavaClass", false).importName("com.github.tadukoo.java.javaclass.JavaClass", false).importName("com.github.tadukoo.java.Visibility", false).importName("com.github.tadukoo.java.javaclass.JavaClassBuilder", false).importName("com.github.tadukoo.java.javadoc.EditableJavadoc", false).importName("com.github.tadukoo.java.javadoc.Javadoc", false).importName("com.github.tadukoo.java.javadoc.JavadocBuilder", false).importName("com.github.tadukoo.java.method.EditableJavaMethod", false).importName("com.github.tadukoo.java.method.JavaMethod", false).importName("com.github.tadukoo.java.method.JavaMethodBuilder", false).importName("com.github.tadukoo.ultimatepower.UltimatePowerProcessor", false).importName("com.github.tadukoo.util.ListUtil", false).importName("com.github.tadukoo.util.StringUtil", false).importName("com.github.tadukoo.util.logger.EasyLogger", false).importName("com.github.tadukoo.util.map.HashMultiMap", false).importName("com.github.tadukoo.util.map.MultiMap", false).importName("com.github.tadukoo.util.tuple.Pair", false).importName("com.github.tadukoo.util.tuple.Triple", false).importName("com.github.tadukoo.view.font.FontFamily", false).importName("com.github.tadukoo.view.font.FontResourceLoader", false).importName("com.github.tadukoo.view.form.field.FieldType", false).importName("com.github.tadukoo.view.form.field.LabelType", false).importName("com.github.tadukoo.view.paint.SizablePaint", false).importName("com.github.tadukoo.view.shapes.ShapeInfo", false).importName("javax.swing.border.Border", false).importName("java.awt.GraphicsEnvironment", false).importName("java.lang.annotation.Annotation", false).importName("java.util.ArrayList", false).importName("java.util.List", false).build());
    }
}

