/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing.util.download;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.testing.JavaClassParsingTest;

public class ProgressReadableByteChannelWrapperTest
extends JavaClassParsingTest {
    public ProgressReadableByteChannelWrapperTest() {
        super("package com.github.tadukoo.util.download;\n\nimport java.io.IOException;\nimport java.nio.ByteBuffer;\nimport java.nio.channels.ReadableByteChannel;\n\n/**\n * Progress Readable Byte Channel Wrapper is a wrapper around {@link ReadableByteChannel} that will send\n * progress updates to a {@link ProgressRBCWrapperListener}, which is keeping track of progress.\n * \n * @author Logan Ferree (Tadukoo)\n * @version Beta v.0.5\n */\npublic class ProgressReadableByteChannelWrapper implements ReadableByteChannel{\n\t\n\t/** The underlying {@link ReadableByteChannel} to use for reading */\n\tprivate final ReadableByteChannel byteChannel;\n\t/** The {@link ProgressRBCWrapperListener} that is keeping track of progress */\n\tprivate final ProgressRBCWrapperListener listener;\n\t/** The expected total size in bytes to be read */\n\tprivate final long expectedSize;\n\t/** The amount of bytes read so far */\n\tprivate long readSoFar;\n\t\n\t/**\n\t * Wraps the given {@link ReadableByteChannel} so we can send progress updates to the given\n\t * {@link ProgressRBCWrapperListener}, which is keeping track of progress\n\t * \n\t * @param byteChannel The underlying {@link ReadableByteChannel} to be wrapped\n\t * @param listener The {@link ProgressRBCWrapperListener} which will track progress\n\t * @param expectedSize The expected total size in bytes to be read\n\t */\n\tpublic ProgressReadableByteChannelWrapper(\n\t\t\tReadableByteChannel byteChannel, ProgressRBCWrapperListener listener, long expectedSize){\n\t\tthis.byteChannel = byteChannel;\n\t\tthis.listener = listener;\n\t\tthis.expectedSize = expectedSize;\n\t}\n\t\n\t/**\n\t * Closes the underlying {@link #byteChannel}\n\t * \n\t * @throws IOException If anything goes wrong in closing the byte channel\n\t */\n\t@Override\n\tpublic void close() throws IOException{\n\t\tbyteChannel.close();\n\t}\n\t\n\t/**\n\t * @return Whether the underlying {@link #byteChannel} is open or not\n\t */\n\t@Override\n\tpublic boolean isOpen(){\n\t\treturn byteChannel.isOpen();\n\t}\n\t\n\t/**\n\t * Reads bytes from the underlying {@link #byteChannel} into the given {@link ByteBuffer} and\n\t * will send a progress update to the {@link #listener} that is keeping track of progress\n\t * \n\t * @param bb The {@link ByteBuffer} to be read into\n\t * @return The number of bytes read, possibly 0 or -1 if we're at the end of stream\n\t * @throws IOException If anything goes wrong in reading bytes\n\t */\n\t@Override\n\tpublic int read(ByteBuffer bb) throws IOException{\n\t\tint n;\n\t\tdouble progress;\n\t\t\n\t\tif((n = byteChannel.read(bb)) > 0 && listener != null){\n\t\t\treadSoFar += n;\n\t\t\tprogress = expectedSize > 0 ? (double) readSoFar/(double) expectedSize * 100.0:-1.0;\n\t\t\tlistener.progressUpdate(progress, readSoFar, expectedSize);\n\t\t}\n\t\t\n\t\treturn n;\n\t}\n}\n", EditableJavaClass.builder().packageName("com.github.tadukoo.util.download").importName("java.io.IOException", false).importName("java.nio.ByteBuffer", false).importName("java.nio.channels.ReadableByteChannel", false).javadoc(EditableJavadoc.builder().content("Progress Readable Byte Channel Wrapper is a wrapper around {@link ReadableByteChannel} that will send").content("progress updates to a {@link ProgressRBCWrapperListener}, which is keeping track of progress.").author("Logan Ferree (Tadukoo)").version("Beta v.0.5").build()).visibility(Visibility.PUBLIC).className("ProgressReadableByteChannelWrapper").implementsInterfaceName("ReadableByteChannel").field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("The underlying {@link ReadableByteChannel} to use for reading").build()).visibility(Visibility.PRIVATE).isFinal().type("ReadableByteChannel").name("byteChannel").build()).field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("The {@link ProgressRBCWrapperListener} that is keeping track of progress").build()).visibility(Visibility.PRIVATE).isFinal().type("ProgressRBCWrapperListener").name("listener").build()).field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("The expected total size in bytes to be read").build()).visibility(Visibility.PRIVATE).isFinal().type("long").name("expectedSize").build()).field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("The amount of bytes read so far").build()).visibility(Visibility.PRIVATE).type("long").name("readSoFar").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Wraps the given {@link ReadableByteChannel} so we can send progress updates to the given").content("{@link ProgressRBCWrapperListener}, which is keeping track of progress").param("byteChannel", "The underlying {@link ReadableByteChannel} to be wrapped").param("listener", "The {@link ProgressRBCWrapperListener} which will track progress").param("expectedSize", "The expected total size in bytes to be read").build()).visibility(Visibility.PUBLIC).returnType("ProgressReadableByteChannelWrapper").parameter("ReadableByteChannel", "byteChannel").parameter("ProgressRBCWrapperListener", "listener").parameter("long", "expectedSize").line("this.byteChannel = byteChannel;").line("this.listener = listener;").line("this.expectedSize = expectedSize;").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Closes the underlying {@link #byteChannel}").throwsInfo("IOException", "If anything goes wrong in closing the byte channel").build()).annotation(EditableJavaAnnotation.builder().name("Override").build()).visibility(Visibility.PUBLIC).returnType("void").name("close").throwType("IOException").line("byteChannel.close();").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().returnVal("Whether the underlying {@link #byteChannel} is open or not").build()).annotation(EditableJavaAnnotation.builder().name("Override").build()).visibility(Visibility.PUBLIC).returnType("boolean").name("isOpen").line("return byteChannel.isOpen();").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Reads bytes from the underlying {@link #byteChannel} into the given {@link ByteBuffer} and").content("will send a progress update to the {@link #listener} that is keeping track of progress").param("bb", "The {@link ByteBuffer} to be read into").returnVal("The number of bytes read, possibly 0 or -1 if we're at the end of stream").throwsInfo("IOException", "If anything goes wrong in reading bytes").build()).annotation(EditableJavaAnnotation.builder().name("Override").build()).visibility(Visibility.PUBLIC).returnType("int").name("read").parameter("ByteBuffer", "bb").throwType("IOException").line("int n;").line("double progress;").line("").line("if((n = byteChannel.read(bb)) > 0 && listener != null){").line("\treadSoFar += n;").line("\tprogress = expectedSize > 0 ? (double) readSoFar/(double) expectedSize * 100.0:-1.0;").line("\tlistener.progressUpdate(progress, readSoFar, expectedSize);").line("}").line("").line("return n;").build()).build());
    }
}

