/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.code.staticcodeblock.EditableJavaStaticCodeBlock;
import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.comment.UneditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.UneditableJavaSingleLineComment;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.field.UneditableJavaField;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javaclass.UneditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.UneditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.method.UneditableJavaMethod;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestClassTest {
    @ParameterizedTest
    @MethodSource(value={"getClassDifferences"})
    public void testFindClassDifferences(JavaClass expectedClass, JavaClass actualClass, List<String> differences) {
        Assertions.assertEquals(differences, (Object)JavaCodeTypeTest.findClassDifferences((JavaClass)expectedClass, (JavaClass)actualClass));
    }

    @ParameterizedTest
    @MethodSource(value={"getClassDifferences"})
    public void testAssertClassEquals(JavaClass expectedClass, JavaClass actualClass, List<String> differences) {
        try {
            JavaCodeTypeTest.assertClassEquals((JavaClass)expectedClass, (JavaClass)actualClass);
            if (ListUtil.isNotBlank(differences)) {
                Assertions.fail();
            }
        }
        catch (AssertionFailedError e) {
            if (ListUtil.isBlank(differences)) {
                throw e;
            }
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines(differences), (String)AssertionFailedErrors.buildAssertError((Object)expectedClass, (Object)actualClass)), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getClassDifferences() {
        return Stream.of(Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").build(), EditableJavaClass.builder().className("Test").build(), new ArrayList()}), Arguments.of((Object[])new Object[]{null, null, new ArrayList()}), Arguments.of((Object[])new Object[]{null, EditableJavaClass.builder().className("Test").build(), ListUtil.createList((Object[])new String[]{"One of the classes is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").build(), null, ListUtil.createList((Object[])new String[]{"One of the classes is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{UneditableJavaClass.builder().className("Test").build(), EditableJavaClass.builder().className("Test").build(), ListUtil.createList((Object[])new String[]{"Editable is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").build(), EditableJavaClass.builder().innerClass().className("Test").build(), ListUtil.createList((Object[])new String[]{"Inner Class is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().packageName("com.test").className("Test").build(), EditableJavaClass.builder().packageName("com.example").className("Test").build(), ListUtil.createList((Object[])new String[]{"Package Declaration differs:\n\tPackage Name is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").build(), EditableJavaClass.builder().importName("com.example.Thing", false).className("Test").build(), ListUtil.createList((Object[])new String[]{"Import Statements length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().importName("com.example.Thing", false).className("Test").build(), EditableJavaClass.builder().className("Test").build(), ListUtil.createList((Object[])new String[]{"Import Statements length is different!", "Import Statements differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().importName("com.example.Thing", false).className("Test").build(), EditableJavaClass.builder().importName("com.example.Thing", true).className("Test").build(), ListUtil.createList((Object[])new String[]{"Import Statements differs on #1:\n\tStatic is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().javadoc(EditableJavadoc.builder().build()).className("Test").build(), EditableJavaClass.builder().className("Test").build(), ListUtil.createList((Object[])new String[]{"Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).className("Test").build(), EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).className("Test").build(), ListUtil.createList((Object[])new String[]{"Annotations length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).className("Test").build(), EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).className("Test").build(), ListUtil.createList((Object[])new String[]{"Annotations length is different!", "Annotations differs on #2!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).className("Test").build(), EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("getDerp").build()).className("Test").build(), ListUtil.createList((Object[])new String[]{"Annotations differs on #1:\n\tName is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().visibility(Visibility.PUBLIC).className("Test").build(), EditableJavaClass.builder().visibility(Visibility.PRIVATE).className("Test").build(), ListUtil.createList((Object[])new String[]{"Visibility is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().isAbstract().className("Test").build(), EditableJavaClass.builder().className("Test").build(), ListUtil.createList((Object[])new String[]{"Abstract is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().innerClass().isStatic().className("Test").build(), EditableJavaClass.builder().innerClass().className("Test").build(), ListUtil.createList((Object[])new String[]{"Static is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().isFinal().className("Test").build(), EditableJavaClass.builder().className("Test").build(), ListUtil.createList((Object[])new String[]{"Final is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").build(), EditableJavaClass.builder().className("Derp").build(), ListUtil.createList((Object[])new String[]{"Class Name differs:\n\tBase Type is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").superClassName("Something").build(), EditableJavaClass.builder().className("Test").build(), ListUtil.createList((Object[])new String[]{"Super Class Name differs:\n\tOne of the types is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").build(), EditableJavaClass.builder().className("Test").implementsInterfaceName("SomethingElse").build(), ListUtil.createList((Object[])new String[]{"Implements Interface Names differs on #1:\n\tBase Type is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").build(), EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").implementsInterfaceName("SomethingElse").build(), ListUtil.createList((Object[])new String[]{"Implements Interface Names length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").implementsInterfaceName("SomethingElse").build(), EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").build(), ListUtil.createList((Object[])new String[]{"Implements Interface Names length is different!", "Implements Interface Names differs on #2!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").staticCodeBlock(EditableJavaStaticCodeBlock.builder().line("doSomething();").build()).build(), EditableJavaClass.builder().className("Test").staticCodeBlock(EditableJavaStaticCodeBlock.builder().line("doSomethingElse();").build()).build(), ListUtil.createList((Object[])new String[]{"Static Code Blocks differs on #1:\n\tLines differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").build(), EditableJavaClass.builder().className("Test").staticCodeBlock(EditableJavaStaticCodeBlock.builder().line("doSomethingElse();").build()).build(), ListUtil.createList((Object[])new String[]{"Static Code Blocks length is different!", "Inner Elements Order length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").staticCodeBlock(EditableJavaStaticCodeBlock.builder().line("doSomethingElse();").build()).build(), EditableJavaClass.builder().className("Test").build(), ListUtil.createList((Object[])new String[]{"Static Code Blocks length is different!", "Static Code Blocks differs on #1!", "Inner Elements Order length is different!", "Inner Elements Order differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").singleLineComment(EditableJavaSingleLineComment.builder().content("Something useful").build()).build(), EditableJavaClass.builder().className("Test").singleLineComment(EditableJavaSingleLineComment.builder().content("Something different").build()).build(), ListUtil.createList((Object[])new String[]{"Single Line Comments differs on #1:\n\tContent is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").build(), EditableJavaClass.builder().className("Test").singleLineComment(EditableJavaSingleLineComment.builder().content("Something different").build()).build(), ListUtil.createList((Object[])new String[]{"Single Line Comments length is different!", "Inner Elements Order length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").singleLineComment(EditableJavaSingleLineComment.builder().content("Something different").build()).build(), EditableJavaClass.builder().className("Test").build(), ListUtil.createList((Object[])new String[]{"Single Line Comments length is different!", "Single Line Comments differs on #1!", "Inner Elements Order length is different!", "Inner Elements Order differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").multiLineComment(EditableJavaMultiLineComment.builder().content("Something useful").build()).build(), EditableJavaClass.builder().className("Test").multiLineComment(EditableJavaMultiLineComment.builder().content("Something different").build()).build(), ListUtil.createList((Object[])new String[]{"Multi Line Comments differs on #1:\n\tContent differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").build(), EditableJavaClass.builder().className("Test").multiLineComment(EditableJavaMultiLineComment.builder().content("Something different").build()).build(), ListUtil.createList((Object[])new String[]{"Multi Line Comments length is different!", "Inner Elements Order length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").multiLineComment(EditableJavaMultiLineComment.builder().content("Something different").build()).build(), EditableJavaClass.builder().className("Test").build(), ListUtil.createList((Object[])new String[]{"Multi Line Comments length is different!", "Multi Line Comments differs on #1!", "Inner Elements Order length is different!", "Inner Elements Order differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("Something").build()).build(), EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("SomethingElse").build()).build(), ListUtil.createList((Object[])new String[]{"Inner Classes differs on #1:\n\tClass Name differs:\n\tBase Type is different!", "Inner Elements Order differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").build(), EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("Something").build()).build(), ListUtil.createList((Object[])new String[]{"Inner Classes length is different!", "Inner Elements Order length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("Something").build()).build(), EditableJavaClass.builder().className("Test").build(), ListUtil.createList((Object[])new String[]{"Inner Classes length is different!", "Inner Classes differs on #1!", "Inner Elements Order length is different!", "Inner Elements Order differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("version").build()).build(), EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("test").build()).build(), ListUtil.createList((Object[])new String[]{"Fields differs on #1:\n\tName is different!", "Inner Elements Order differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").build(), EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("test").build()).build(), ListUtil.createList((Object[])new String[]{"Fields length is different!", "Inner Elements Order length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("test").build()).build(), EditableJavaClass.builder().className("Test").build(), ListUtil.createList((Object[])new String[]{"Fields length is different!", "Fields differs on #1!", "Inner Elements Order length is different!", "Inner Elements Order differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("getVersion").build()).build(), EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("getTest").build()).build(), ListUtil.createList((Object[])new String[]{"Methods differs on #1:\n\tName is different!", "Inner Elements Order differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").build(), EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("getTest").build()).build(), ListUtil.createList((Object[])new String[]{"Methods length is different!", "Inner Elements Order length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("getTest").build()).build(), EditableJavaClass.builder().className("Test").build(), ListUtil.createList((Object[])new String[]{"Methods length is different!", "Methods differs on #1!", "Inner Elements Order length is different!", "Inner Elements Order differs on #1!"})}), Arguments.of((Object[])new Object[]{UneditableJavaClass.builder().packageName("com.test").importName("com.example.Thing", false).javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).annotation(UneditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PUBLIC).isAbstract().className("Test").superClassName("Something").implementsInterfaceName("Something").implementsInterfaceName("SomethingElse").singleLineComment(UneditableJavaSingleLineComment.builder().content("Something different").build()).multiLineComment(UneditableJavaMultiLineComment.builder().content("Something different").build()).innerClass(UneditableJavaClass.builder().innerClass().className("Something").build()).field(UneditableJavaField.builder().type("String").name("test").build()).method(UneditableJavaMethod.builder().returnType("String").name("getTest").build()).build(), EditableJavaClass.builder().innerClass().annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().className("Derp").implementsInterfaceName("Something").build(), ListUtil.createList((Object[])new String[]{"Editable is different!", "Inner Class is different!", "Package Declaration differs:\n\tOne of the package declarations is null, and the other isn't!", "Import Statements length is different!", "Import Statements differs on #1!", "Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!", "Annotations length is different!", "Annotations differs on #1:\n\tEditable is different!\n\tName is different!", "Annotations differs on #2!", "Visibility is different!", "Abstract is different!", "Static is different!", "Final is different!", "Class Name differs:\n\tBase Type is different!", "Super Class Name differs:\n\tOne of the types is null, and the other isn't!", "Implements Interface Names length is different!", "Implements Interface Names differs on #2!", "Single Line Comments length is different!", "Single Line Comments differs on #1!", "Multi Line Comments length is different!", "Multi Line Comments differs on #1!", "Inner Classes length is different!", "Inner Classes differs on #1!", "Fields length is different!", "Fields differs on #1!", "Methods length is different!", "Methods differs on #1!", "Inner Elements Order length is different!", "Inner Elements Order differs on #1!", "Inner Elements Order differs on #2!", "Inner Elements Order differs on #3!", "Inner Elements Order differs on #4!", "Inner Elements Order differs on #5!"})}));
    }
}

