/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.importstatement.EditableJavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.importstatement.UneditableJavaImportStatement;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestImportStatementTest {
    @ParameterizedTest
    @MethodSource(value={"getImportStatementDifferences"})
    public void testFindImportStatementDifferences(JavaImportStatement expectedImportStatement, JavaImportStatement actualImportStatement, List<String> differences) {
        Assertions.assertEquals(differences, (Object)JavaCodeTypeTest.findImportStatementDifferences((JavaImportStatement)expectedImportStatement, (JavaImportStatement)actualImportStatement));
    }

    @ParameterizedTest
    @MethodSource(value={"getImportStatementDifferences"})
    public void testAssertImportStatementEquals(JavaImportStatement expectedImportStatement, JavaImportStatement actualImportStatement, List<String> differences) {
        try {
            JavaCodeTypeTest.assertImportStatementEquals((JavaImportStatement)expectedImportStatement, (JavaImportStatement)actualImportStatement);
            if (ListUtil.isNotBlank(differences)) {
                Assertions.fail();
            }
        }
        catch (AssertionFailedError e) {
            if (ListUtil.isBlank(differences)) {
                throw e;
            }
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines(differences), (String)AssertionFailedErrors.buildAssertError((Object)expectedImportStatement, (Object)actualImportStatement)), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getImportStatementDifferences() {
        return Stream.of(Arguments.of((Object[])new Object[]{EditableJavaImportStatement.builder().isStatic().importName("com.test").build(), EditableJavaImportStatement.builder().isStatic().importName("com.test").build(), new ArrayList()}), Arguments.of((Object[])new Object[]{UneditableJavaImportStatement.builder().isStatic().importName("com.test").build(), EditableJavaImportStatement.builder().isStatic().importName("com.test").build(), ListUtil.createList((Object[])new String[]{"Editable is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaImportStatement.builder().isStatic(false).importName("com.test").build(), EditableJavaImportStatement.builder().isStatic().importName("com.test").build(), ListUtil.createList((Object[])new String[]{"Static is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaImportStatement.builder().isStatic().importName("com.example").build(), EditableJavaImportStatement.builder().isStatic().importName("com.test").build(), ListUtil.createList((Object[])new String[]{"Import Name is different!"})}), Arguments.of((Object[])new Object[]{UneditableJavaImportStatement.builder().isStatic(false).importName("com.example").build(), EditableJavaImportStatement.builder().isStatic().importName("com.test").build(), ListUtil.createList((Object[])new String[]{"Editable is different!", "Static is different!", "Import Name is different!"})}));
    }
}

