/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.method.UneditableJavaMethod;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestMethodTest {
    @ParameterizedTest
    @MethodSource(value={"getMethodDifferences"})
    public void testFindMethodDifferences(JavaMethod expectedMethod, JavaMethod actualMethod, List<String> differences) {
        Assertions.assertEquals(differences, (Object)JavaCodeTypeTest.findMethodDifferences((JavaMethod)expectedMethod, (JavaMethod)actualMethod));
    }

    @ParameterizedTest
    @MethodSource(value={"getMethodDifferences"})
    public void testAssertMethodEquals(JavaMethod expectedMethod, JavaMethod actualMethod, List<String> differences) {
        try {
            JavaCodeTypeTest.assertMethodEquals((JavaMethod)expectedMethod, (JavaMethod)actualMethod);
            if (ListUtil.isNotBlank(differences)) {
                Assertions.fail();
            }
        }
        catch (AssertionFailedError e) {
            if (ListUtil.isBlank(differences)) {
                throw e;
            }
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines(differences), (String)AssertionFailedErrors.buildAssertError((Object)expectedMethod, (Object)actualMethod)), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getMethodDifferences() {
        return Stream.of(Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("String").name("getTest").build(), EditableJavaMethod.builder().returnType("String").name("getTest").build(), new ArrayList()}), Arguments.of((Object[])new Object[]{null, null, new ArrayList()}), Arguments.of((Object[])new Object[]{null, EditableJavaMethod.builder().returnType("String").name("getTest").build(), ListUtil.createList((Object[])new String[]{"One of the methods is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("String").name("getTest").build(), null, ListUtil.createList((Object[])new String[]{"One of the methods is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{UneditableJavaMethod.builder().returnType("String").name("getTest").build(), EditableJavaMethod.builder().returnType("String").name("getTest").build(), ListUtil.createList((Object[])new String[]{"Editable is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().build()).returnType("String").name("getTest").build(), EditableJavaMethod.builder().returnType("String").name("getTest").build(), ListUtil.createList((Object[])new String[]{"Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).returnType("String").name("getTest").build(), EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).returnType("String").name("getTest").build(), ListUtil.createList((Object[])new String[]{"Annotations length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).returnType("String").name("getTest").build(), EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).returnType("String").name("getTest").build(), ListUtil.createList((Object[])new String[]{"Annotations length is different!", "Annotations differs on #2!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getTest").build()).returnType("String").name("getTest").build(), EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("getDerp").build()).returnType("String").name("getTest").build(), ListUtil.createList((Object[])new String[]{"Annotations differs on #1:\n\tName is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().visibility(Visibility.PUBLIC).returnType("String").name("getTest").build(), EditableJavaMethod.builder().visibility(Visibility.PRIVATE).returnType("String").name("getTest").build(), ListUtil.createList((Object[])new String[]{"Visibility is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().isAbstract().returnType("String").name("getTest").build(), EditableJavaMethod.builder().returnType("String").name("getTest").build(), ListUtil.createList((Object[])new String[]{"Abstract is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().isStatic().returnType("String").name("getTest").build(), EditableJavaMethod.builder().returnType("String").name("getTest").build(), ListUtil.createList((Object[])new String[]{"Static is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().isFinal().returnType("String").name("getTest").build(), EditableJavaMethod.builder().returnType("String").name("getTest").build(), ListUtil.createList((Object[])new String[]{"Final is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("String").name("getVersion").addTypeParameters("T").build(), EditableJavaMethod.builder().returnType("String").name("getVersion").addTypeParameters("T, U").build(), ListUtil.createList((Object[])new String[]{"Type Parameters length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("String").name("getVersion").addTypeParameters("T, U").build(), EditableJavaMethod.builder().returnType("String").name("getVersion").addTypeParameters("T").build(), ListUtil.createList((Object[])new String[]{"Type Parameters length is different!", "Type Parameters differs on #2!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("int").name("getTest").build(), EditableJavaMethod.builder().returnType("String").name("getTest").build(), ListUtil.createList((Object[])new String[]{"Return Type differs:\n\tBase Type is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("String").name("getVersion").build(), EditableJavaMethod.builder().returnType("String").name("getTest").build(), ListUtil.createList((Object[])new String[]{"Name is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("String").name("getVersion").parameter("String version").build(), EditableJavaMethod.builder().returnType("String").name("getVersion").parameter("String version").parameter("int version").build(), ListUtil.createList((Object[])new String[]{"Parameters length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("String").name("getVersion").parameter("String version").parameter("int version").build(), EditableJavaMethod.builder().returnType("String").name("getVersion").parameter("String version").build(), ListUtil.createList((Object[])new String[]{"Parameters length is different!", "Parameters differs on #2!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").build(), EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("NoException").build(), ListUtil.createList((Object[])new String[]{"Throw Types differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").build(), EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").throwType("NoException").build(), ListUtil.createList((Object[])new String[]{"Throw Types length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").throwType("NoException").build(), EditableJavaMethod.builder().returnType("String").name("getVersion").throwType("Exception").build(), ListUtil.createList((Object[])new String[]{"Throw Types length is different!", "Throw Types differs on #2!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").build(), EditableJavaMethod.builder().returnType("String").name("getVersion").line("return this;").build(), ListUtil.createList((Object[])new String[]{"Content differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").build(), EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").line("return this;").build(), ListUtil.createList((Object[])new String[]{"Content length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").line("return this;").build(), EditableJavaMethod.builder().returnType("String").name("getVersion").line("return version;").build(), ListUtil.createList((Object[])new String[]{"Content length is different!", "Content differs on #2!"})}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().build()).annotation(EditableJavaAnnotation.builder().name("getTest").build()).annotation(EditableJavaAnnotation.builder().name("getDerp").build()).visibility(Visibility.PUBLIC).isAbstract().addTypeParameters("T, U").returnType("int").name("getVersion").parameter("String version").parameter("int version").throwType("Exception").throwType("NoException").build(), UneditableJavaMethod.builder().annotation(UneditableJavaAnnotation.builder().name("getDerp").build()).visibility(Visibility.PRIVATE).addTypeParameters("T").returnType("String").name("getTest").parameter("String version").throwType("Exception").build(), ListUtil.createList((Object[])new String[]{"Editable is different!", "Javadoc differs:\n\tOne of the Javadocs is null, and the other isn't!", "Annotations length is different!", "Annotations differs on #1:\n\tEditable is different!\n\tName is different!", "Annotations differs on #2!", "Visibility is different!", "Abstract is different!", "Type Parameters length is different!", "Type Parameters differs on #2!", "Return Type differs:\n\tBase Type is different!", "Name is different!", "Parameters length is different!", "Parameters differs on #2!", "Throw Types length is different!", "Throw Types differs on #2!"})}));
    }
}

