/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.packagedeclaration.EditableJavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.UneditableJavaPackageDeclaration;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestPackageDeclarationTest {
    @ParameterizedTest
    @MethodSource(value={"getPackageDeclarationDifferences"})
    public void testFindPackageDeclarationDifferences(JavaPackageDeclaration expectedPackageDeclaration, JavaPackageDeclaration actualPackageDeclaration, List<String> differences) {
        Assertions.assertEquals(differences, (Object)JavaCodeTypeTest.findPackageDeclarationDifferences((JavaPackageDeclaration)expectedPackageDeclaration, (JavaPackageDeclaration)actualPackageDeclaration));
    }

    @ParameterizedTest
    @MethodSource(value={"getPackageDeclarationDifferences"})
    public void testAssertPackageDeclarationEquals(JavaPackageDeclaration expectedPackageDeclaration, JavaPackageDeclaration actualPackageDeclaration, List<String> differences) {
        try {
            JavaCodeTypeTest.assertPackageDeclarationEquals((JavaPackageDeclaration)expectedPackageDeclaration, (JavaPackageDeclaration)actualPackageDeclaration);
            if (ListUtil.isNotBlank(differences)) {
                Assertions.fail();
            }
        }
        catch (AssertionFailedError e) {
            if (ListUtil.isBlank(differences)) {
                throw e;
            }
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines(differences), (String)AssertionFailedErrors.buildAssertError((Object)expectedPackageDeclaration, (Object)actualPackageDeclaration)), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getPackageDeclarationDifferences() {
        return Stream.of(Arguments.of((Object[])new Object[]{EditableJavaPackageDeclaration.builder().packageName("com.test").build(), EditableJavaPackageDeclaration.builder().packageName("com.test").build(), new ArrayList()}), Arguments.of((Object[])new Object[]{null, null, new ArrayList()}), Arguments.of((Object[])new Object[]{null, EditableJavaPackageDeclaration.builder().packageName("com.test").build(), ListUtil.createList((Object[])new String[]{"One of the package declarations is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavaPackageDeclaration.builder().packageName("com.test").build(), null, ListUtil.createList((Object[])new String[]{"One of the package declarations is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavaPackageDeclaration.builder().packageName("com.test").build(), UneditableJavaPackageDeclaration.builder().packageName("com.test").build(), ListUtil.createList((Object[])new String[]{"Editable is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaPackageDeclaration.builder().packageName("com.test").build(), EditableJavaPackageDeclaration.builder().packageName("com.derp").build(), ListUtil.createList((Object[])new String[]{"Package Name is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaPackageDeclaration.builder().packageName("com.test").build(), UneditableJavaPackageDeclaration.builder().packageName("com.derp").build(), ListUtil.createList((Object[])new String[]{"Editable is different!", "Package Name is different!"})}));
    }
}

