/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.code.staticcodeblock.EditableJavaStaticCodeBlock;
import com.github.tadukoo.java.code.staticcodeblock.JavaStaticCodeBlock;
import com.github.tadukoo.java.code.staticcodeblock.UneditableJavaStaticCodeBlock;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestStaticCodeBlockTest {
    @ParameterizedTest
    @MethodSource(value={"getStaticCodeBlockDifferences"})
    public void testFindStaticCodeBlockDifferences(JavaStaticCodeBlock expectedStaticCodeBlock, JavaStaticCodeBlock actualStaticCodeBlock, List<String> differences) {
        Assertions.assertEquals(differences, (Object)JavaCodeTypeTest.findStaticCodeBlockDifferences((JavaStaticCodeBlock)expectedStaticCodeBlock, (JavaStaticCodeBlock)actualStaticCodeBlock));
    }

    @ParameterizedTest
    @MethodSource(value={"getStaticCodeBlockDifferences"})
    public void testAssertStaticCodeBlockEquals(JavaStaticCodeBlock expectedStaticCodeBlock, JavaStaticCodeBlock actualStaticCodeBlock, List<String> differences) {
        try {
            JavaCodeTypeTest.assertStaticCodeBlockEquals((JavaStaticCodeBlock)expectedStaticCodeBlock, (JavaStaticCodeBlock)actualStaticCodeBlock);
            if (ListUtil.isNotBlank(differences)) {
                Assertions.fail();
            }
        }
        catch (AssertionFailedError e) {
            if (ListUtil.isBlank(differences)) {
                throw e;
            }
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines(differences), (String)AssertionFailedErrors.buildAssertError((Object)expectedStaticCodeBlock, (Object)actualStaticCodeBlock)), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getStaticCodeBlockDifferences() {
        return Stream.of(Arguments.of((Object[])new Object[]{EditableJavaStaticCodeBlock.builder().line("doSomething();").build(), EditableJavaStaticCodeBlock.builder().line("doSomething();").build(), new ArrayList()}), Arguments.of((Object[])new Object[]{null, null, new ArrayList()}), Arguments.of((Object[])new Object[]{null, EditableJavaStaticCodeBlock.builder().line("doSomething();").build(), ListUtil.createList((Object[])new String[]{"One of the static code blocks is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavaStaticCodeBlock.builder().line("doSomething();").build(), null, ListUtil.createList((Object[])new String[]{"One of the static code blocks is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{UneditableJavaStaticCodeBlock.builder().line("doSomething();").build(), EditableJavaStaticCodeBlock.builder().line("doSomething();").build(), ListUtil.createList((Object[])new String[]{"Editable is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaStaticCodeBlock.builder().line("doSomething();").build(), EditableJavaStaticCodeBlock.builder().line("doSomethingElse();").build(), ListUtil.createList((Object[])new String[]{"Lines differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaStaticCodeBlock.builder().line("doSomething();").line("doA3rdThing();").build(), EditableJavaStaticCodeBlock.builder().line("doSomething();").build(), ListUtil.createList((Object[])new String[]{"Lines length is different!", "Lines differs on #2!"})}), Arguments.of((Object[])new Object[]{UneditableJavaStaticCodeBlock.builder().line("doSomething();").build(), EditableJavaStaticCodeBlock.builder().line("doSomethingElse();").line("doA3rdThing();").build(), ListUtil.createList((Object[])new String[]{"Editable is different!", "Lines length is different!", "Lines differs on #1!"})}));
    }
}

