/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javaclass.UneditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestTest {
    @Test
    public void testCheckBooleanSuccess() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().className("Test").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkBoolean((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Editable", JavaClass::isEditable);
        Assertions.assertTrue((boolean)differences.isEmpty());
    }

    @Test
    public void testCheckBooleanFailure() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").build();
        JavaClass clazz2 = UneditableJavaClass.builder().className("Test").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkBoolean((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Editable", JavaClass::isEditable);
        Assertions.assertEquals((int)1, (int)differences.size());
        Assertions.assertEquals((Object)"Editable is different!", differences.get(0));
    }

    @Test
    public void testCheckStringSuccess() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("test").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("test").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkString((JavaCodeType)method1, (JavaCodeType)method2, differences, (String)"Name", JavaMethod::getName);
        Assertions.assertTrue((boolean)differences.isEmpty());
    }

    @Test
    public void testCheckStringBlankSuccess() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name(null).build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkString((JavaCodeType)method1, (JavaCodeType)method2, differences, (String)"Name", JavaMethod::getName);
        Assertions.assertTrue((boolean)differences.isEmpty());
    }

    @Test
    public void testCheckStringFailure() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("something").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("String").name("nothing").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkString((JavaCodeType)method1, (JavaCodeType)method2, differences, (String)"Name", JavaMethod::getName);
        Assertions.assertEquals((int)1, (int)differences.size());
        Assertions.assertEquals((Object)"Name is different!", differences.get(0));
    }

    @Test
    public void testRunParserForClassSuccess() throws JavaParsingException {
        EditableJavaClass clazz = JavaCodeTypeTest.runParserForClass((String)"class Test{ }");
        Assertions.assertEquals((Object)clazz, (Object)EditableJavaClass.builder().className("Test").build());
    }

    @Test
    public void testCheckListSuccessBothEmpty() {
        Javadoc doc1 = EditableJavadoc.builder().build();
        Javadoc doc2 = EditableJavadoc.builder().build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkList((JavaCodeType)doc1, (JavaCodeType)doc2, differences, (String)"Content", Javadoc::getContent, StringUtil::equals);
        Assertions.assertTrue((boolean)differences.isEmpty());
    }

    @Test
    public void testCheckListFailureFirstEmpty() {
        Javadoc doc1 = EditableJavadoc.builder().build();
        Javadoc doc2 = EditableJavadoc.builder().content("something").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkList((JavaCodeType)doc1, (JavaCodeType)doc2, differences, (String)"Content", Javadoc::getContent, StringUtil::equals);
        Assertions.assertEquals((int)1, (int)differences.size());
        Assertions.assertEquals((Object)"Content length is different!", differences.get(0));
    }

    @Test
    public void testCheckListSuccessNotEmpty() {
        Javadoc doc1 = EditableJavadoc.builder().content("Something").build();
        Javadoc doc2 = EditableJavadoc.builder().content("Something").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkList((JavaCodeType)doc1, (JavaCodeType)doc2, differences, (String)"Content", Javadoc::getContent, StringUtil::equals);
        Assertions.assertTrue((boolean)differences.isEmpty());
    }

    @Test
    public void testCheckListFailure() {
        Javadoc doc1 = EditableJavadoc.builder().content("SomethingElse").build();
        Javadoc doc2 = EditableJavadoc.builder().content("Something").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkList((JavaCodeType)doc1, (JavaCodeType)doc2, differences, (String)"Content", Javadoc::getContent, StringUtil::equals);
        Assertions.assertEquals((int)1, (int)differences.size());
        Assertions.assertEquals((Object)"Content differs on #1!", differences.get(0));
    }

    @Test
    public void testCheckEnumSuccess() {
        JavaClass clazz1 = EditableJavaClass.builder().visibility(Visibility.PUBLIC).className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().visibility(Visibility.PUBLIC).className("Test").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkEnum((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Visibility", JavaClass::getVisibility);
        Assertions.assertTrue((boolean)differences.isEmpty());
    }

    @Test
    public void testCheckEnumFailure() {
        JavaClass clazz1 = EditableJavaClass.builder().visibility(Visibility.PUBLIC).className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().visibility(Visibility.PRIVATE).className("Test").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkEnum((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Visibility", JavaClass::getVisibility);
        Assertions.assertEquals((int)1, (int)differences.size());
        Assertions.assertEquals((Object)"Visibility is different!", differences.get(0));
    }

    @Test
    public void testRunParserForClassNotAClass() throws JavaParsingException {
        try {
            JavaCodeTypeTest.runParserForClass((String)"String test;");
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildAssertError((Object)JavaCodeTypes.CLASS, (Object)JavaCodeTypes.FIELD), (Object)e.getMessage());
        }
    }
}

