/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.JavaTypeParameter;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestTypeTest {
    @ParameterizedTest
    @MethodSource(value={"getTypeDifferences"})
    public void testFindTypeDifferences(JavaType expectedType, JavaType actualType, List<String> differences) {
        Assertions.assertEquals(differences, (Object)JavaCodeTypeTest.findTypeDifferences((JavaType)expectedType, (JavaType)actualType));
    }

    @ParameterizedTest
    @MethodSource(value={"getTypeDifferences"})
    public void testAssertTypeEquals(JavaType expectedType, JavaType actualType, List<String> differences) {
        try {
            JavaCodeTypeTest.assertTypeEquals((JavaType)expectedType, (JavaType)actualType);
            if (ListUtil.isNotBlank(differences)) {
                Assertions.fail();
            }
        }
        catch (AssertionFailedError e) {
            if (ListUtil.isBlank(differences)) {
                throw e;
            }
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines(differences), (String)AssertionFailedErrors.buildAssertError((Object)expectedType, (Object)actualType)), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getTypeDifferences() {
        return Stream.of(Arguments.of((Object[])new Object[]{JavaType.builder().baseType("String").build(), JavaType.builder().baseType("String").build(), new ArrayList()}), Arguments.of((Object[])new Object[]{null, null, new ArrayList()}), Arguments.of((Object[])new Object[]{null, JavaType.builder().baseType("String").build(), ListUtil.createList((Object[])new String[]{"One of the types is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{JavaType.builder().baseType("String").build(), null, ListUtil.createList((Object[])new String[]{"One of the types is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{JavaType.builder().baseType("String").build(), JavaType.builder().baseType("int").build(), ListUtil.createList((Object[])new String[]{"Base Type is different!"})}), Arguments.of((Object[])new Object[]{JavaType.builder().baseType("List").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).build(), JavaType.builder().baseType("List").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("int").build()).build()).build(), ListUtil.createList((Object[])new String[]{"Type Parameters differs on #1:\n\tBase Type differs:\n\tBase Type is different!"})}), Arguments.of((Object[])new Object[]{JavaType.builder().baseType("List").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).build(), JavaType.builder().baseType("List").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("int").build()).build()).build(), ListUtil.createList((Object[])new String[]{"Type Parameters length is different!"})}), Arguments.of((Object[])new Object[]{JavaType.builder().baseType("String").canonicalName(String.class.getCanonicalName()).build(), JavaType.builder().baseType("String").canonicalName("com.tadukoo.String").build(), ListUtil.createList((Object[])new String[]{"Canonical Name is different!"})}), Arguments.of((Object[])new Object[]{JavaType.builder().baseType("List").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).canonicalName(String.class.getCanonicalName()).build(), JavaType.builder().baseType("String").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("int").build()).build()).typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).build(), ListUtil.createList((Object[])new String[]{"Base Type is different!", "Type Parameters length is different!", "Type Parameters differs on #1:\n\tBase Type differs:\n\tBase Type is different!", "Canonical Name is different!"})}));
    }
}

