/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing.util;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.testing.JavaClassParsingTest;

public class BooleanUtilTest
extends JavaClassParsingTest {
    public BooleanUtilTest() {
        super("package com.github.tadukoo.util;\n\n/**\n * Util functions for dealing with Booleans.\n * \n * @author Logan Ferree (Tadukoo)\n * @version 0.1-Alpha-SNAPSHOT\n */\npublic final class BooleanUtil{\n\t\n\t/** Not allowed to create a BooleanUtil */\n\tprivate BooleanUtil(){ }\n\t\n\t/**\n\t * Checks that the given Boolean is true, properly handling cases of\n\t * null as false (meaning returning a false result).\n\t * \n\t * @param bool The Boolean to check\n\t * @return If the Boolean is true\n\t */\n\tpublic static boolean isTrue(Boolean bool){\n\t\treturn bool != null && bool;\n\t}\n\t\n\t/**\n\t * Checks that the given Boolean is false, properly handling cases of\n\t * null as false (meaning returning a false result).\n\t * \n\t * @param bool The Boolean to check\n\t * @return If the Boolean is false\n\t */\n\tpublic static boolean isFalse(Boolean bool){\n\t\treturn bool != null && !bool;\n\t}\n\t\n\t/**\n\t * Checks that the given Boolean is not true, meaning that a Boolean\n\t * that's false or a null Boolean will both return a true result.\n\t * \n\t * @param bool The Boolean to check\n\t * @return If the Boolean is not true\n\t */\n\tpublic static boolean isNotTrue(Boolean bool){\n\t\treturn bool == null || !bool;\n\t}\n\t\n\t/**\n\t * Checks that the given Boolean is not false, meaning that a Boolean\n\t * that's true or a null Boolean will both return a true result.\n\t * \n\t * @param bool The Boolean to check\n\t * @return If the Boolean is not false\n\t */\n\tpublic static boolean isNotFalse(Boolean bool){\n\t\treturn bool == null || bool;\n\t}\n}\n", EditableJavaClass.builder().packageName("com.github.tadukoo.util").javadoc(EditableJavadoc.builder().content("Util functions for dealing with Booleans.").author("Logan Ferree (Tadukoo)").version("0.1-Alpha-SNAPSHOT").build()).visibility(Visibility.PUBLIC).isFinal().className("BooleanUtil").method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("Not allowed to create a BooleanUtil").build()).visibility(Visibility.PRIVATE).returnType("BooleanUtil").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Checks that the given Boolean is true, properly handling cases of").content("null as false (meaning returning a false result).").param("bool", "The Boolean to check").returnVal("If the Boolean is true").build()).visibility(Visibility.PUBLIC).isStatic().returnType("boolean").name("isTrue").parameter("Boolean bool").line("return bool != null && bool;").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Checks that the given Boolean is false, properly handling cases of").content("null as false (meaning returning a false result).").param("bool", "The Boolean to check").returnVal("If the Boolean is false").build()).visibility(Visibility.PUBLIC).isStatic().returnType("boolean").name("isFalse").parameter("Boolean bool").line("return bool != null && !bool;").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Checks that the given Boolean is not true, meaning that a Boolean").content("that's false or a null Boolean will both return a true result.").param("bool", "The Boolean to check").returnVal("If the Boolean is not true").build()).visibility(Visibility.PUBLIC).isStatic().returnType("boolean").name("isNotTrue").parameter("Boolean bool").line("return bool == null || !bool;").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Checks that the given Boolean is not false, meaning that a Boolean").content("that's true or a null Boolean will both return a true result.").param("bool", "The Boolean to check").returnVal("If the Boolean is not false").build()).visibility(Visibility.PUBLIC).isStatic().returnType("boolean").name("isNotFalse").parameter("Boolean bool").line("return bool == null || bool;").build()).build());
    }
}

