/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaAnnotationBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaAnnotationTest {
    private JavaAnnotation annotation;
    private String name;

    @BeforeEach
    public void setup() {
        this.name = "Test";
        this.annotation = new TestJavaAnnotationBuilder(true).name(this.name).build();
    }

    @Test
    public void testIsEditable() {
        Assertions.assertTrue((boolean)this.annotation.isEditable());
    }

    @Test
    public void testSetNotEditable() {
        this.annotation = new TestJavaAnnotationBuilder(false).name(this.name).build();
        Assertions.assertFalse((boolean)this.annotation.isEditable());
    }

    @Test
    public void testGetName() {
        Assertions.assertEquals((Object)this.name, (Object)this.annotation.getName());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"@Test", (Object)this.annotation.toString());
    }

    @Test
    public void testEquals() {
        JavaAnnotation otherAnnotation = new TestJavaAnnotationBuilder(true).name(this.name).build();
        Assertions.assertEquals((Object)this.annotation, (Object)otherAnnotation);
    }

    @Test
    public void testEqualsNotEqual() {
        JavaAnnotation otherAnnotation = new TestJavaAnnotationBuilder(true).name("Testing").build();
        Assertions.assertNotEquals((Object)this.annotation, (Object)otherAnnotation);
    }

    @Test
    public void testEqualsDifferentType() {
        Assertions.assertNotEquals((Object)this.annotation, (Object)"testing");
    }

    private static class TestJavaAnnotationBuilder
    extends JavaAnnotationBuilder<TestJavaAnnotation> {
        private final boolean editable;

        private TestJavaAnnotationBuilder(boolean editable) {
            this.editable = editable;
        }

        protected TestJavaAnnotation constructAnnotation() {
            return new TestJavaAnnotation(this.editable, this.name);
        }
    }

    private static class TestJavaAnnotation
    extends JavaAnnotation {
        private TestJavaAnnotation(boolean editable, String name) {
            super(editable, name);
        }
    }
}

