/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class JavaCodeTypesTest {

    @Nested
    public class CLASSTest
    extends BaseJavaCodeTypesTest {
        public CLASSTest() {
            super(JavaCodeTypes.CLASS, "CLASS", JavaClass.class, "class");
        }
    }

    @Nested
    public class METHODTest
    extends BaseJavaCodeTypesTest {
        public METHODTest() {
            super(JavaCodeTypes.METHOD, "METHOD", JavaMethod.class, "method");
        }
    }

    @Nested
    public class FIELDTest
    extends BaseJavaCodeTypesTest {
        public FIELDTest() {
            super(JavaCodeTypes.FIELD, "FIELD", JavaField.class, "field");
        }
    }

    @Nested
    public class TYPE_WITH_MODIFIERSTest
    extends BaseJavaCodeTypesTest {
        public TYPE_WITH_MODIFIERSTest() {
            super(JavaCodeTypes.TYPE_WITH_MODIFIERS, "TYPE_WITH_MODIFIERS", null, "type with modifiers");
        }
    }

    @Nested
    public class ANNOTATIONTest
    extends BaseJavaCodeTypesTest {
        public ANNOTATIONTest() {
            super(JavaCodeTypes.ANNOTATION, "ANNOTATION", JavaAnnotation.class, "annotation");
        }
    }

    @Nested
    public class SINGLE_LINE_COMMENTTest
    extends BaseJavaCodeTypesTest {
        public SINGLE_LINE_COMMENTTest() {
            super(JavaCodeTypes.SINGLE_LINE_COMMENT, "SINGLE_LINE_COMMENT", JavaSingleLineComment.class, "single-line comment");
        }
    }

    @Nested
    public class MULTI_LINE_COMMENTTest
    extends BaseJavaCodeTypesTest {
        public MULTI_LINE_COMMENTTest() {
            super(JavaCodeTypes.MULTI_LINE_COMMENT, "MULTI_LINE_COMMENT", JavaMultiLineComment.class, "multi-line comment");
        }
    }

    @Nested
    public class JAVADOCTest
    extends BaseJavaCodeTypesTest {
        public JAVADOCTest() {
            super(JavaCodeTypes.JAVADOC, "JAVADOC", Javadoc.class, "Javadoc");
        }
    }

    @Nested
    public class IMPORT_STATEMENTTest
    extends BaseJavaCodeTypesTest {
        public IMPORT_STATEMENTTest() {
            super(JavaCodeTypes.IMPORT_STATEMENT, "IMPORT_STATEMENT", JavaImportStatement.class, "import statement");
        }
    }

    @Nested
    public class PACKAGE_DECLARATIONTest
    extends BaseJavaCodeTypesTest {
        public PACKAGE_DECLARATIONTest() {
            super(JavaCodeTypes.PACKAGE_DECLARATION, "PACKAGE_DECLARATION", JavaPackageDeclaration.class, "package declaration");
        }
    }

    @Nested
    public class UNKNOWNTest
    extends BaseJavaCodeTypesTest {
        public UNKNOWNTest() {
            super(JavaCodeTypes.UNKNOWN, "UNKNOWN", null, "unknown");
        }
    }

    private static abstract class BaseJavaCodeTypesTest {
        private final JavaCodeTypes type;
        private final String toString;
        private final Class<?> javaTypeClass;
        private final String standardName;

        protected BaseJavaCodeTypesTest(JavaCodeTypes type, String toString, Class<?> javaTypeClass, String standardName) {
            this.type = type;
            this.toString = toString;
            this.javaTypeClass = javaTypeClass;
            this.standardName = standardName;
        }

        @Test
        public void testToString() {
            Assertions.assertEquals((Object)this.toString, (Object)this.type.toString());
        }

        @Test
        public void testJavaTypeClass() {
            Assertions.assertEquals(this.javaTypeClass, (Object)this.type.getJavaTypeClass());
        }

        @Test
        public void testStandardName() {
            Assertions.assertEquals((Object)this.standardName, (Object)this.type.getStandardName());
        }
    }
}

