/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaCodeUtil;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JavaCodeUtilTest {
    @Test
    public void testConvertToJavaStringNull() {
        Assertions.assertNull((Object)JavaCodeUtil.convertToJavaString(null));
    }

    @Test
    public void testConvertToJavaStringString() {
        Assertions.assertEquals((Object)"testing", (Object)JavaCodeUtil.convertToJavaString((Object)"testing"));
    }

    @Test
    public void testConvertToJavaStringEnum() {
        Assertions.assertEquals((Object)"JavaCodeTypes.CLASS", (Object)JavaCodeUtil.convertToJavaString((Object)JavaCodeTypes.CLASS));
    }

    @Test
    public void testConvertToJavaStringAssertion() {
        JavaAnnotation annotation = EditableJavaAnnotation.builder().name("Test").build();
        Assertions.assertEquals((Object)annotation.toString(), (Object)JavaCodeUtil.convertToJavaString((Object)annotation));
    }

    @Test
    public void testEscapeString() {
        String theString = "test something \t\n \r\n \t\t\t";
        Assertions.assertEquals((Object)"test something \\t\\n \\r\\n \\t\\t\\t", (Object)JavaCodeUtil.escapeString((String)theString));
    }
}

