/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.annotation;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotationBuilder;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.NoException;
import com.github.tadukoo.util.functional.supplier.ThrowingSupplier;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DefaultJavaAnnotationTest<AnnotationType extends JavaAnnotation> {
    private final Class<AnnotationType> clazz;
    private final ThrowingSupplier<JavaAnnotationBuilder<AnnotationType>, NoException> builder;
    protected String name;
    protected AnnotationType annotation;

    protected DefaultJavaAnnotationTest(Class<AnnotationType> clazz, ThrowingSupplier<JavaAnnotationBuilder<AnnotationType>, NoException> builder) {
        this.clazz = clazz;
        this.builder = builder;
    }

    @BeforeEach
    public void setup() {
        this.name = "Test";
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).build();
    }

    @Test
    public void testGetType() {
        Assertions.assertEquals((Object)JavaCodeTypes.ANNOTATION, (Object)this.annotation.getJavaCodeType());
    }

    @Test
    public void testBuilderDefaultParameters() {
        Assertions.assertEquals(new ArrayList(), (Object)this.annotation.getParameters());
    }

    @Test
    public void testBuilderCopy() {
        JavaAnnotation otherAnnotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).canonicalName("something.Test").parameter("test", "true").parameter("derp", "false").build();
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).copy(otherAnnotation).build();
        Assertions.assertEquals(this.annotation, (Object)otherAnnotation);
        Assertions.assertEquals((Object)this.annotation.getCanonicalName(), (Object)otherAnnotation.getCanonicalName());
    }

    @Test
    public void testBuilderName() {
        Assertions.assertEquals((Object)this.name, (Object)this.annotation.getName());
    }

    @Test
    public void testBuilderCanonicalName() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).canonicalName("something.Test").build();
        Assertions.assertEquals((Object)"something.Test", (Object)this.annotation.getCanonicalName());
    }

    @Test
    public void testBuilderAddParameterPieces() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).parameter("test", "true").parameter("derp", "false").build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true"), Pair.of((Object)"derp", (Object)"false")}), (Object)this.annotation.getParameters());
    }

    @Test
    public void testBuilderAddParameterPair() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).parameter(Pair.of((Object)"test", (Object)"true")).parameter(Pair.of((Object)"derp", (Object)"false")).build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true"), Pair.of((Object)"derp", (Object)"false")}), (Object)this.annotation.getParameters());
    }

    @Test
    public void testBuilderSetParameters() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).parameters(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true"), Pair.of((Object)"derp", (Object)"false")})).build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true"), Pair.of((Object)"derp", (Object)"false")}), (Object)this.annotation.getParameters());
    }

    @Test
    public void testBuilderMissingName() {
        try {
            this.annotation = ((JavaAnnotationBuilder)this.builder.get()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify name!", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetParametersMap() {
        Map parameters = this.annotation.getParametersMap();
        Assertions.assertTrue((boolean)parameters.isEmpty());
    }

    @Test
    public void testGetParametersMapSingleParam() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).parameter("test", "something").build();
        Map parameters = this.annotation.getParametersMap();
        Assertions.assertEquals((int)1, (int)parameters.size());
        Assertions.assertEquals((Object)"something", parameters.get("test"));
    }

    @Test
    public void testGetParametersMapMultipleParams() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).parameter("test", "something").parameter("derp", "something else").build();
        Map parameters = this.annotation.getParametersMap();
        Assertions.assertEquals((int)2, (int)parameters.size());
        Assertions.assertEquals((Object)"something", parameters.get("test"));
        Assertions.assertEquals((Object)"something else", parameters.get("derp"));
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"@Test", (Object)this.annotation.toString());
    }

    @Test
    public void testToStringSingleParameter() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).parameter("test", "true").build();
        Assertions.assertEquals((Object)"@Test(test = true)", (Object)this.annotation.toString());
    }

    @Test
    public void testToStringValueParameter() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).parameter("value", "true").build();
        Assertions.assertEquals((Object)"@Test(true)", (Object)this.annotation.toString());
    }

    @Test
    public void testToStringMultipleParameters() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).parameter("test", "true").parameter("derp", "String.class").build();
        Assertions.assertEquals((Object)"@Test(test = true, derp = String.class)", (Object)this.annotation.toString());
    }

    @Test
    public void testToStringMultipleParametersOneIsValue() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).parameter("value", "true").parameter("derp", "String.class").build();
        Assertions.assertEquals((Object)"@Test(value = true, derp = String.class)", (Object)this.annotation.toString());
    }

    @Test
    public void testEquals() {
        JavaAnnotation otherAnnotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).build();
        Assertions.assertEquals(this.annotation, (Object)otherAnnotation);
    }

    @Test
    public void testEqualsNotEqual() {
        JavaAnnotation otherAnnotation = ((JavaAnnotationBuilder)this.builder.get()).name("Testing").build();
        Assertions.assertNotEquals(this.annotation, (Object)otherAnnotation);
    }

    @Test
    public void testEqualsDifferentType() {
        Assertions.assertNotEquals(this.annotation, (Object)"testing");
    }

    @Test
    public void testToBuilderCode() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.name(\"" + this.name + "\")\n\t\t.build()"), (Object)this.annotation.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithCanonicalName() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).canonicalName("some.canon.name").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.name(\"" + this.name + "\")\n\t\t.canonicalName(\"some.canon.name\")\n\t\t.build()"), (Object)this.annotation.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithOneParameter() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).parameter("test", "5").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.name(\"" + this.name + "\")\n\t\t.parameter(\"test\", \"5\")\n\t\t.build()"), (Object)this.annotation.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithTwoParameters() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).parameter("test", "5").parameter("something", "42").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.name(\"" + this.name + "\")\n\t\t.parameter(\"test\", \"5\")\n\t\t.parameter(\"something\", \"42\")\n\t\t.build()"), (Object)this.annotation.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithEverything() {
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).canonicalName("some.canon.name").parameter("test", "5").parameter("something", "42").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.name(\"" + this.name + "\")\n\t\t.canonicalName(\"some.canon.name\")\n\t\t.parameter(\"test\", \"5\")\n\t\t.parameter(\"something\", \"42\")\n\t\t.build()"), (Object)this.annotation.toBuilderCode());
    }
}

