/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.annotation;

import com.github.tadukoo.java.annotation.DefaultJavaAnnotationTest;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EditableJavaAnnotationTest
extends DefaultJavaAnnotationTest<EditableJavaAnnotation> {
    public EditableJavaAnnotationTest() {
        super(EditableJavaAnnotation.class, EditableJavaAnnotation::builder);
    }

    @Test
    public void testIsEditable() {
        Assertions.assertTrue((boolean)((EditableJavaAnnotation)this.annotation).isEditable());
    }

    @Test
    public void testSetName() {
        Assertions.assertEquals((Object)"Test", (Object)((EditableJavaAnnotation)this.annotation).getName());
        ((EditableJavaAnnotation)this.annotation).setName("Derp");
        Assertions.assertEquals((Object)"Derp", (Object)((EditableJavaAnnotation)this.annotation).getName());
    }

    @Test
    public void testSetCanonicalName() {
        Assertions.assertTrue((boolean)StringUtil.isBlank((String)((EditableJavaAnnotation)this.annotation).getCanonicalName()));
        ((EditableJavaAnnotation)this.annotation).setCanonicalName("something.Test");
        Assertions.assertEquals((Object)"something.Test", (Object)((EditableJavaAnnotation)this.annotation).getCanonicalName());
    }

    @Test
    public void testAddParameterPieces() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaAnnotation)this.annotation).getParameters());
        ((EditableJavaAnnotation)this.annotation).addParameter("test", "true");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true")}), (Object)((EditableJavaAnnotation)this.annotation).getParameters());
        ((EditableJavaAnnotation)this.annotation).addParameter("derp", "String.class");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true"), Pair.of((Object)"derp", (Object)"String.class")}), (Object)((EditableJavaAnnotation)this.annotation).getParameters());
    }

    @Test
    public void testAddParameterPair() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaAnnotation)this.annotation).getParameters());
        ((EditableJavaAnnotation)this.annotation).addParameter(Pair.of((Object)"test", (Object)"true"));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true")}), (Object)((EditableJavaAnnotation)this.annotation).getParameters());
        ((EditableJavaAnnotation)this.annotation).addParameter(Pair.of((Object)"derp", (Object)"String.class"));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true"), Pair.of((Object)"derp", (Object)"String.class")}), (Object)((EditableJavaAnnotation)this.annotation).getParameters());
    }

    @Test
    public void testAddParameters() {
        Pair param1 = Pair.of((Object)"test", (Object)"true");
        Pair param2 = Pair.of((Object)"derp", (Object)"String.class");
        Pair param3 = Pair.of((Object)"yep", (Object)"false");
        Pair param4 = Pair.of((Object)"nah", (Object)"\"\"");
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaAnnotation)this.annotation).getParameters());
        ((EditableJavaAnnotation)this.annotation).addParameters(ListUtil.createList((Object[])new Pair[]{param1, param2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{param1, param2}), (Object)((EditableJavaAnnotation)this.annotation).getParameters());
        ((EditableJavaAnnotation)this.annotation).addParameters(ListUtil.createList((Object[])new Pair[]{param3, param4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{param1, param2, param3, param4}), (Object)((EditableJavaAnnotation)this.annotation).getParameters());
    }

    @Test
    public void testSetParameters() {
        Pair param1 = Pair.of((Object)"test", (Object)"true");
        Pair param2 = Pair.of((Object)"derp", (Object)"String.class");
        Pair param3 = Pair.of((Object)"yep", (Object)"false");
        Pair param4 = Pair.of((Object)"nah", (Object)"\"\"");
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaAnnotation)this.annotation).getParameters());
        ((EditableJavaAnnotation)this.annotation).setParameters(ListUtil.createList((Object[])new Pair[]{param1, param2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{param1, param2}), (Object)((EditableJavaAnnotation)this.annotation).getParameters());
        ((EditableJavaAnnotation)this.annotation).setParameters(ListUtil.createList((Object[])new Pair[]{param3, param4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{param3, param4}), (Object)((EditableJavaAnnotation)this.annotation).getParameters());
    }
}

