/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.comment;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineCommentBuilder;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.NoException;
import com.github.tadukoo.util.functional.supplier.ThrowingSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DefaultJavaMultiLineCommentTest<CommentType extends JavaMultiLineComment> {
    private final Class<CommentType> clazz;
    private final ThrowingSupplier<JavaMultiLineCommentBuilder<CommentType>, NoException> builder;
    protected CommentType comment;

    protected DefaultJavaMultiLineCommentTest(Class<CommentType> clazz, ThrowingSupplier<JavaMultiLineCommentBuilder<CommentType>, NoException> builder) {
        this.clazz = clazz;
        this.builder = builder;
    }

    @BeforeEach
    public void setup() {
        this.comment = ((JavaMultiLineCommentBuilder)this.builder.get()).build();
    }

    @Test
    public void testJavaType() {
        Assertions.assertEquals((Object)JavaCodeTypes.MULTI_LINE_COMMENT, (Object)this.comment.getJavaCodeType());
    }

    @Test
    public void testDefaultContent() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Object[0]), (Object)this.comment.getContent());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"/*\n */", (Object)this.comment.toString());
    }

    @Test
    public void testToStringWithContent() {
        this.comment = ((JavaMultiLineCommentBuilder)this.builder.get()).content("something useful").build();
        Assertions.assertEquals((Object)"/*\n * something useful\n */", (Object)this.comment.toString());
    }

    @Test
    public void testToStringWithMultilineContent() {
        this.comment = ((JavaMultiLineCommentBuilder)this.builder.get()).content("something useful").content("something else").build();
        Assertions.assertEquals((Object)"/*\n * something useful\n * something else\n */", (Object)this.comment.toString());
    }

    @Test
    public void testEquals() {
        JavaMultiLineComment otherComment = ((JavaMultiLineCommentBuilder)this.builder.get()).build();
        Assertions.assertEquals(this.comment, (Object)otherComment);
    }

    @Test
    public void testNotEquals() {
        JavaMultiLineComment otherComment = ((JavaMultiLineCommentBuilder)this.builder.get()).content("something useful").build();
        Assertions.assertNotEquals(this.comment, (Object)otherComment);
    }

    @Test
    public void testEqualsDifferentType() {
        Assertions.assertNotEquals(this.comment, (Object)"testing");
    }

    @Test
    public void testCopy() {
        JavaMultiLineComment otherComment = ((JavaMultiLineCommentBuilder)this.builder.get()).content("something useful").build();
        this.comment = ((JavaMultiLineCommentBuilder)this.builder.get()).copy(otherComment).build();
        Assertions.assertEquals((Object)otherComment, this.comment);
    }

    @Test
    public void testBuilderSetContent() {
        this.comment = ((JavaMultiLineCommentBuilder)this.builder.get()).content("something useful").build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"something useful"}), (Object)this.comment.getContent());
    }

    @Test
    public void testBuilderSetMultiLineContent() {
        this.comment = ((JavaMultiLineCommentBuilder)this.builder.get()).content(ListUtil.createList((Object[])new String[]{"something useful", "something else"})).build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"something useful", "something else"}), (Object)this.comment.getContent());
    }

    @Test
    public void testToBuilderCodeNoContent() {
        this.comment = ((JavaMultiLineCommentBuilder)this.builder.get()).build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.build()"), (Object)this.comment.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeOneContent() {
        this.comment = ((JavaMultiLineCommentBuilder)this.builder.get()).content("something useful").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.content(\"something useful\")\n\t\t.build()"), (Object)this.comment.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeTwoContent() {
        this.comment = ((JavaMultiLineCommentBuilder)this.builder.get()).content("something useful").content("something else").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.content(\"something useful\")\n\t\t.content(\"something else\")\n\t\t.build()"), (Object)this.comment.toBuilderCode());
    }
}

