/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.comment;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineCommentBuilder;
import com.github.tadukoo.util.functional.NoException;
import com.github.tadukoo.util.functional.supplier.ThrowingSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DefaultJavaSingleLineCommentTest<CommentType extends JavaSingleLineComment> {
    private final Class<CommentType> clazz;
    private final ThrowingSupplier<JavaSingleLineCommentBuilder<CommentType>, NoException> builder;
    protected CommentType comment;

    protected DefaultJavaSingleLineCommentTest(Class<CommentType> clazz, ThrowingSupplier<JavaSingleLineCommentBuilder<CommentType>, NoException> builder) {
        this.clazz = clazz;
        this.builder = builder;
    }

    @BeforeEach
    public void setup() {
        this.comment = ((JavaSingleLineCommentBuilder)this.builder.get()).build();
    }

    @Test
    public void testJavaType() {
        Assertions.assertEquals((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, (Object)this.comment.getJavaCodeType());
    }

    @Test
    public void testDefaultContent() {
        Assertions.assertEquals((Object)"", (Object)this.comment.getContent());
    }

    @Test
    public void testCopy() {
        JavaSingleLineComment otherComment = ((JavaSingleLineCommentBuilder)this.builder.get()).content("something useful").build();
        this.comment = ((JavaSingleLineCommentBuilder)this.builder.get()).copy(otherComment).build();
        Assertions.assertEquals((Object)otherComment, this.comment);
    }

    @Test
    public void testBuilderSetContent() {
        this.comment = ((JavaSingleLineCommentBuilder)this.builder.get()).content("something useful").build();
        Assertions.assertEquals((Object)"something useful", (Object)this.comment.getContent());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"// ", (Object)this.comment.toString());
    }

    @Test
    public void testToStringWithContent() {
        this.comment = ((JavaSingleLineCommentBuilder)this.builder.get()).content("something useful").build();
        Assertions.assertEquals((Object)"// something useful", (Object)this.comment.toString());
    }

    @Test
    public void testEquals() {
        JavaSingleLineComment otherComment = ((JavaSingleLineCommentBuilder)this.builder.get()).build();
        Assertions.assertEquals(this.comment, (Object)otherComment);
    }

    @Test
    public void testNotEquals() {
        JavaSingleLineComment otherComment = ((JavaSingleLineCommentBuilder)this.builder.get()).content("something useful").build();
        Assertions.assertNotEquals(this.comment, (Object)otherComment);
    }

    @Test
    public void testEqualsDifferentType() {
        Assertions.assertNotEquals(this.comment, (Object)"testing");
    }

    @Test
    public void testToBuilderCode() {
        this.comment = ((JavaSingleLineCommentBuilder)this.builder.get()).content("something useful").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.content(\"something useful\")\n\t\t.build()"), (Object)this.comment.toBuilderCode());
    }
}

