/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.field;

import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.field.DefaultJavaFieldTest;
import com.github.tadukoo.java.field.UneditableJavaField;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.UneditableJavadoc;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UneditableJavaFieldTest
extends DefaultJavaFieldTest<UneditableJavaField> {
    public UneditableJavaFieldTest() {
        super(UneditableJavaField.class, UneditableJavaField::builder, UneditableJavadoc::builder, UneditableJavaAnnotation::builder);
    }

    @Test
    public void testIsEditable() {
        Assertions.assertFalse((boolean)((UneditableJavaField)this.field).isEditable());
    }

    @Test
    public void testBuilderErrorEditableJavadoc() {
        try {
            UneditableJavaField.builder().type("int").name("test").javadoc(EditableJavadoc.builder().build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not uneditable in this uneditable JavaField", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderErrorEditableAnnotation() {
        try {
            UneditableJavaField.builder().type("int").name("test").annotation(EditableJavaAnnotation.builder().name("Test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some annotations are not uneditable in this uneditable JavaField", (Object)e.getMessage());
        }
    }

    @Override
    @Test
    public void testAllBuilderErrors() {
        try {
            UneditableJavaField.builder().type("int").name("test").javadoc(EditableJavadoc.builder().build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not uneditable in this uneditable JavaField\nsome annotations are not uneditable in this uneditable JavaField", (Object)e.getMessage());
        }
    }
}

