/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.importstatement;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatementBuilder;
import com.github.tadukoo.util.functional.NoException;
import com.github.tadukoo.util.functional.supplier.ThrowingSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DefaultJavaImportStatementTest<ImportStatementType extends JavaImportStatement> {
    private final Class<ImportStatementType> clazz;
    private final ThrowingSupplier<JavaImportStatementBuilder<ImportStatementType>, NoException> builder;
    protected String importName;
    protected ImportStatementType importStatement;

    protected DefaultJavaImportStatementTest(Class<ImportStatementType> clazz, ThrowingSupplier<JavaImportStatementBuilder<ImportStatementType>, NoException> builder) {
        this.clazz = clazz;
        this.builder = builder;
    }

    @BeforeEach
    public void setup() {
        this.importName = "com.example";
        this.importStatement = ((JavaImportStatementBuilder)this.builder.get()).importName(this.importName).build();
    }

    @Test
    public void testGetType() {
        Assertions.assertEquals((Object)JavaCodeTypes.IMPORT_STATEMENT, (Object)this.importStatement.getJavaCodeType());
    }

    @Test
    public void testBuilderCopy() {
        JavaImportStatement otherImportStatement = ((JavaImportStatementBuilder)this.builder.get()).isStatic().importName(this.importName).build();
        this.importStatement = ((JavaImportStatementBuilder)this.builder.get()).copy(otherImportStatement).build();
        Assertions.assertEquals((Object)otherImportStatement, this.importStatement);
    }

    @Test
    public void testBuilderSetImportName() {
        Assertions.assertEquals((Object)this.importName, (Object)this.importStatement.getImportName());
    }

    @Test
    public void testBuilderDefaultIsStatic() {
        Assertions.assertFalse((boolean)this.importStatement.isStatic());
    }

    @Test
    public void testBuilderIsStatic() {
        this.importStatement = ((JavaImportStatementBuilder)this.builder.get()).importName(this.importName).isStatic().build();
        Assertions.assertTrue((boolean)this.importStatement.isStatic());
    }

    @Test
    public void testBuilderSetIsStatic() {
        this.importStatement = ((JavaImportStatementBuilder)this.builder.get()).importName(this.importName).isStatic(true).build();
        Assertions.assertTrue((boolean)this.importStatement.isStatic());
    }

    @Test
    public void testBuilderErrorNoImportName() {
        try {
            ((JavaImportStatementBuilder)this.builder.get()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"importName is required!", (Object)e.getMessage());
        }
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"import com.example;", (Object)this.importStatement.toString());
    }

    @Test
    public void testToStringStatic() {
        this.importStatement = ((JavaImportStatementBuilder)this.builder.get()).importName(this.importName).isStatic().build();
        Assertions.assertEquals((Object)"import static com.example;", (Object)this.importStatement.toString());
    }

    @Test
    public void testEquals() {
        JavaImportStatement otherImportStatement = ((JavaImportStatementBuilder)this.builder.get()).importName(this.importName).build();
        Assertions.assertEquals(this.importStatement, (Object)otherImportStatement);
    }

    @Test
    public void testEqualsNotEqual() {
        JavaImportStatement otherImportStatement = ((JavaImportStatementBuilder)this.builder.get()).importName(this.importName).isStatic().build();
        Assertions.assertNotEquals(this.importStatement, (Object)otherImportStatement);
    }

    @Test
    public void testEqualsDifferentType() {
        Assertions.assertNotEquals(this.importStatement, (Object)"testing");
    }

    @Test
    public void testToBuilderCodeNotStatic() {
        this.importStatement = ((JavaImportStatementBuilder)this.builder.get()).importName(this.importName).build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.importName(\"" + this.importName + "\")\n\t\t.build()"), (Object)this.importStatement.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeStatic() {
        this.importStatement = ((JavaImportStatementBuilder)this.builder.get()).isStatic().importName(this.importName).build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.isStatic()\n\t\t.importName(\"" + this.importName + "\")\n\t\t.build()"), (Object)this.importStatement.toBuilderCode());
    }
}

