/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.javaclass;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotationBuilder;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineCommentBuilder;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineCommentBuilder;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.field.JavaFieldBuilder;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatementBuilder;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javaclass.JavaClassBuilder;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.javadoc.JavadocBuilder;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.method.JavaMethodBuilder;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclarationBuilder;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.NoException;
import com.github.tadukoo.util.functional.supplier.ThrowingSupplier;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DefaultJavaClassTest<ClassType extends JavaClass> {
    private final Class<ClassType> theClazz;
    private final ThrowingSupplier<JavaClassBuilder<ClassType>, NoException> builder;
    private final ThrowingSupplier<JavaPackageDeclarationBuilder<?>, NoException> javaPackageDeclarationBuilder;
    private final ThrowingSupplier<JavaImportStatementBuilder<?>, NoException> javaImportStatementBuilder;
    private final ThrowingSupplier<JavaAnnotationBuilder<?>, NoException> javaAnnotationBuilder;
    private final ThrowingSupplier<JavadocBuilder<?>, NoException> javadocBuilder;
    private final ThrowingSupplier<JavaSingleLineCommentBuilder<?>, NoException> singleLineCommentBuilder;
    private final ThrowingSupplier<JavaMultiLineCommentBuilder<?>, NoException> multiLineCommentBuilder;
    private final ThrowingSupplier<JavaFieldBuilder<?>, NoException> javaFieldBuilder;
    private final ThrowingSupplier<JavaMethodBuilder<?>, NoException> javaMethodBuilder;
    protected ClassType clazz;
    protected String className;

    protected DefaultJavaClassTest(Class<ClassType> theClazz, ThrowingSupplier<JavaClassBuilder<ClassType>, NoException> builder, ThrowingSupplier<JavaPackageDeclarationBuilder<?>, NoException> javaPackageDeclarationBuilder, ThrowingSupplier<JavaImportStatementBuilder<?>, NoException> javaImportStatementBuilder, ThrowingSupplier<JavaAnnotationBuilder<?>, NoException> javaAnnotationBuilder, ThrowingSupplier<JavadocBuilder<?>, NoException> javadocBuilder, ThrowingSupplier<JavaSingleLineCommentBuilder<?>, NoException> singleLineCommentBuilder, ThrowingSupplier<JavaMultiLineCommentBuilder<?>, NoException> multiLineCommentBuilder, ThrowingSupplier<JavaFieldBuilder<?>, NoException> javaFieldBuilder, ThrowingSupplier<JavaMethodBuilder<?>, NoException> javaMethodBuilder) {
        this.theClazz = theClazz;
        this.builder = builder;
        this.javaPackageDeclarationBuilder = javaPackageDeclarationBuilder;
        this.javaImportStatementBuilder = javaImportStatementBuilder;
        this.javaAnnotationBuilder = javaAnnotationBuilder;
        this.javadocBuilder = javadocBuilder;
        this.singleLineCommentBuilder = singleLineCommentBuilder;
        this.multiLineCommentBuilder = multiLineCommentBuilder;
        this.javaFieldBuilder = javaFieldBuilder;
        this.javaMethodBuilder = javaMethodBuilder;
    }

    @BeforeEach
    public void setup() {
        this.className = "AClassName";
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).build();
    }

    @Test
    public void testGetType() {
        Assertions.assertEquals((Object)JavaCodeTypes.CLASS, (Object)this.clazz.getJavaCodeType());
    }

    @Test
    public void testDefaultIsInnerClass() {
        Assertions.assertFalse((boolean)this.clazz.isInnerClass());
    }

    @Test
    public void testDefaultPackageDeclaration() {
        Assertions.assertNull((Object)this.clazz.getPackageDeclaration());
    }

    @Test
    public void testDefaultImportStatements() {
        Assertions.assertEquals(new ArrayList(), (Object)this.clazz.getImportStatements());
    }

    @Test
    public void testDefaultJavadoc() {
        Assertions.assertNull((Object)this.clazz.getJavadoc());
    }

    @Test
    public void testDefaultAnnotations() {
        Assertions.assertNotNull((Object)this.clazz.getAnnotations());
        Assertions.assertTrue((boolean)this.clazz.getAnnotations().isEmpty());
    }

    @Test
    public void testDefaultVisibility() {
        Assertions.assertEquals((Object)Visibility.NONE, (Object)this.clazz.getVisibility());
    }

    @Test
    public void testDefaultIsAbstract() {
        Assertions.assertFalse((boolean)this.clazz.isAbstract());
    }

    @Test
    public void testDefaultIsStatic() {
        Assertions.assertFalse((boolean)this.clazz.isStatic());
    }

    @Test
    public void testDefaultIsFinal() {
        Assertions.assertFalse((boolean)this.clazz.isFinal());
    }

    @Test
    public void testDefaultSuperClassName() {
        Assertions.assertNull((Object)this.clazz.getSuperClassName());
    }

    @Test
    public void testDefaultImplementsInterfaces() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Object[0]), (Object)this.clazz.getImplementsInterfaceNames());
    }

    @Test
    public void testDefaultSingleLineComments() {
        Assertions.assertNotNull((Object)this.clazz.getSingleLineComments());
        Assertions.assertTrue((boolean)this.clazz.getSingleLineComments().isEmpty());
    }

    @Test
    public void testDefaultMultiLineComments() {
        Assertions.assertNotNull((Object)this.clazz.getMultiLineComments());
        Assertions.assertTrue((boolean)this.clazz.getMultiLineComments().isEmpty());
    }

    @Test
    public void testDefaultFields() {
        Assertions.assertNotNull((Object)this.clazz.getFields());
        Assertions.assertTrue((boolean)this.clazz.getFields().isEmpty());
    }

    @Test
    public void testDefaultMethods() {
        Assertions.assertNotNull((Object)this.clazz.getMethods());
        Assertions.assertTrue((boolean)this.clazz.getMethods().isEmpty());
    }

    @Test
    public void testDefaultInnerElementsOrder() {
        Assertions.assertNotNull((Object)this.clazz.getInnerElementsOrder());
        Assertions.assertTrue((boolean)this.clazz.getInnerElementsOrder().isEmpty());
    }

    @Test
    public void testGetInnerClassesMapNoInnerClasses() {
        Assertions.assertTrue((boolean)this.clazz.getInnerClassesMap().isEmpty());
    }

    @Test
    public void testGetInnerClassesMapSingleInnerClass() {
        JavaClass innerClass = ((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass(innerClass).className(this.className).build();
        Map innerClassMap = this.clazz.getInnerClassesMap();
        Assertions.assertEquals((int)1, (int)innerClassMap.size());
        Assertions.assertEquals((Object)innerClass, innerClassMap.get("BClassName"));
    }

    @Test
    public void testGetInnerClassesMapTwoInnerClasses() {
        JavaClass innerClass = ((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build();
        JavaClass innerClass2 = ((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass(innerClass).innerClass(innerClass2).className(this.className).build();
        Map innerClassMap = this.clazz.getInnerClassesMap();
        Assertions.assertEquals((int)2, (int)innerClassMap.size());
        Assertions.assertEquals((Object)innerClass, innerClassMap.get("BClassName"));
        Assertions.assertEquals((Object)innerClass2, innerClassMap.get("CClassName"));
    }

    @Test
    public void testGetFieldsMapNoFields() {
        Assertions.assertTrue((boolean)this.clazz.getFieldsMap().isEmpty());
    }

    @Test
    public void testGetFieldsMapSingleField() {
        JavaField field = ((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("test").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).field(field).build();
        Map fieldMap = this.clazz.getFieldsMap();
        Assertions.assertEquals((int)1, (int)fieldMap.size());
        Assertions.assertEquals((Object)field, fieldMap.get("test"));
    }

    @Test
    public void testGetFieldsMapTwoFields() {
        JavaField field = ((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("test").build();
        JavaField field2 = ((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("version").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).field(field).field(field2).build();
        Map fieldMap = this.clazz.getFieldsMap();
        Assertions.assertEquals((int)2, (int)fieldMap.size());
        Assertions.assertEquals((Object)field, fieldMap.get("test"));
        Assertions.assertEquals((Object)field2, fieldMap.get("version"));
    }

    @Test
    public void testGetMethodsMapNoMethods() {
        Assertions.assertTrue((boolean)this.clazz.getMethodsMap().isEmpty());
    }

    @Test
    public void testGetMethodsMapSingleMethod() {
        JavaMethod method = ((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getType").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).method(method).build();
        Map methodMap = this.clazz.getMethodsMap();
        Assertions.assertEquals((int)1, (int)methodMap.size());
        Assertions.assertEquals((Object)method, methodMap.get("getType()"));
    }

    @Test
    public void testGetMethodsMapTwoMethods() {
        JavaMethod method = ((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getType").build();
        JavaMethod method2 = ((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("int").name("getVersion").parameter("String", "type").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).method(method).method(method2).build();
        Map methodMap = this.clazz.getMethodsMap();
        Assertions.assertEquals((int)2, (int)methodMap.size());
        Assertions.assertEquals((Object)method, methodMap.get("getType()"));
        Assertions.assertEquals((Object)method2, methodMap.get("getVersion(String type)"));
    }

    @Test
    public void testBuilderCopy() {
        JavaClass otherClass = ((JavaClassBuilder)this.builder.get()).packageDeclaration(((JavaPackageDeclarationBuilder)this.javaPackageDeclarationBuilder.get()).packageName("some.package").build()).importStatement(((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("some.classname").build()).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).visibility(Visibility.PUBLIC).isFinal().className(this.className).superClassName("BClassName").implementsInterfaceName("SomeInterface").singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).multiLineComment(((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some content").content("more comment").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("test").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("type").build()).build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).copy(otherClass).build();
        Assertions.assertEquals((Object)otherClass, this.clazz);
    }

    @Test
    public void testBuilderSetIsInnerClass() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).isInnerClass(true).build();
        Assertions.assertTrue((boolean)this.clazz.isInnerClass());
    }

    @Test
    public void testBuilderSetInnerClass() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).innerClass().build();
        Assertions.assertTrue((boolean)this.clazz.isInnerClass());
    }

    @Test
    public void testBuilderSetPackageDeclaration() {
        JavaPackageDeclaration packageDeclaration = ((JavaPackageDeclarationBuilder)this.javaPackageDeclarationBuilder.get()).packageName("some.package").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageDeclaration(packageDeclaration).className(this.className).build();
        Assertions.assertEquals((Object)packageDeclaration, (Object)this.clazz.getPackageDeclaration());
    }

    @Test
    public void testBuilderSetPackageName() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName("some.package").className(this.className).build();
        Assertions.assertEquals((Object)((JavaPackageDeclarationBuilder)this.javaPackageDeclarationBuilder.get()).packageName("some.package").build(), (Object)this.clazz.getPackageDeclaration());
    }

    @Test
    public void testBuilderSetClassName() {
        Assertions.assertEquals((Object)this.className, (Object)this.clazz.getClassName());
    }

    @Test
    public void testBuilderSingleImportStatement() {
        JavaImportStatement importStatement = ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).importStatement(importStatement).className(this.className).build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{importStatement}), (Object)this.clazz.getImportStatements());
    }

    @Test
    public void testBuilderSetImportStatements() {
        List importStatements = ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.other").build()});
        this.clazz = ((JavaClassBuilder)this.builder.get()).importStatements(importStatements).className(this.className).build();
        Assertions.assertEquals((Object)importStatements, (Object)this.clazz.getImportStatements());
    }

    @Test
    public void testBuilderImportName() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).importName("com.example", false).className(this.className).build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example").build()}), (Object)this.clazz.getImportStatements());
    }

    @Test
    public void testBuilderImportNameStatic() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).importName("com.example", true).className(this.className).build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.example").build()}), (Object)this.clazz.getImportStatements());
    }

    @Test
    public void testBuilderSetImportNames() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).importNames(ListUtil.createList((Object[])new String[]{"com.example", "com.other"}), false).className(this.className).build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.other").build()}), (Object)this.clazz.getImportStatements());
    }

    @Test
    public void testBuilderSetImportNamesStatic() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).importNames(ListUtil.createList((Object[])new String[]{"com.example", "com.other"}), true).className(this.className).build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.example").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.other").build()}), (Object)this.clazz.getImportStatements());
    }

    @Test
    public void testBuilderSetJavadoc() {
        Javadoc doc = ((JavadocBuilder)this.javadocBuilder.get()).build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).javadoc(doc).build();
        Assertions.assertEquals((Object)doc, (Object)this.clazz.getJavadoc());
    }

    @Test
    public void testBuilderSetAnnotations() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        List annotations = ListUtil.createList((Object[])new JavaAnnotation[]{test, derp});
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).annotations(annotations).build();
        Assertions.assertEquals((Object)annotations, (Object)this.clazz.getAnnotations());
    }

    @Test
    public void testBuilderSetSingleAnnotation() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).annotation(test).build();
        List annotations = this.clazz.getAnnotations();
        Assertions.assertEquals((int)1, (int)annotations.size());
        Assertions.assertEquals((Object)test, annotations.get(0));
    }

    @Test
    public void testBuilderSetVisibility() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).visibility(Visibility.PRIVATE).build();
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)this.clazz.getVisibility());
    }

    @Test
    public void testBuilderSetIsAbstractNoParam() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).isAbstract().className(this.className).build();
        Assertions.assertTrue((boolean)this.clazz.isAbstract());
    }

    @Test
    public void testBuilderSetIsAbstract() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).isAbstract(true).className(this.className).build();
        Assertions.assertTrue((boolean)this.clazz.isAbstract());
    }

    @Test
    public void testBuilderSetIsStaticNoParam() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().className(this.className).isStatic().build();
        Assertions.assertTrue((boolean)this.clazz.isStatic());
    }

    @Test
    public void testBuilderSetIsStatic() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().className(this.className).isStatic(true).build();
        Assertions.assertTrue((boolean)this.clazz.isStatic());
    }

    @Test
    public void testBuilderSetFinalNoParam() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).isFinal().build();
        Assertions.assertTrue((boolean)this.clazz.isFinal());
    }

    @Test
    public void testBuilderSetIsFinal() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).isFinal(true).build();
        Assertions.assertTrue((boolean)this.clazz.isFinal());
    }

    @Test
    public void testBuilderSetSuperClassName() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).superClassName("AnotherClassName").build();
        Assertions.assertEquals((Object)"AnotherClassName", (Object)this.clazz.getSuperClassName());
    }

    @Test
    public void testBuilderSetImplementsInterfaceName() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).implementsInterfaceName("SomeInterface").build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"SomeInterface"}), (Object)this.clazz.getImplementsInterfaceNames());
    }

    @Test
    public void testBuilderSetMultipleImplementsInterfaceNames() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).implementsInterfaceNames(ListUtil.createList((Object[])new String[]{"SomeInterface", "SomeOtherInterface"})).build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"SomeInterface", "SomeOtherInterface"}), (Object)this.clazz.getImplementsInterfaceNames());
    }

    @Test
    public void testSetSingleLineComments() {
        List comments = ListUtil.createList((Object[])new JavaSingleLineComment[]{((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build(), ((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some more comment").build()});
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComments(comments).build();
        Assertions.assertEquals((Object)comments, (Object)this.clazz.getSingleLineComments());
    }

    @Test
    public void testSet1SingleLineComment() {
        JavaSingleLineComment comment = ((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(comment).build();
        List comments = this.clazz.getSingleLineComments();
        Assertions.assertEquals((int)1, (int)comments.size());
        Assertions.assertEquals((Object)comment, comments.get(0));
    }

    @Test
    public void testSetMultiLineComments() {
        List comments = ListUtil.createList((Object[])new JavaMultiLineComment[]{((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some comment").content("more content").build(), ((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some more comment").build()});
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).multiLineComments(comments).build();
        Assertions.assertEquals((Object)comments, (Object)this.clazz.getMultiLineComments());
    }

    @Test
    public void testSet1MultiLineComment() {
        JavaMultiLineComment comment = ((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some comment").content("more content").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).multiLineComment(comment).build();
        List comments = this.clazz.getMultiLineComments();
        Assertions.assertEquals((int)1, (int)comments.size());
        Assertions.assertEquals((Object)comment, comments.get(0));
    }

    @Test
    public void testBuilderSetInnerClasses() {
        List classes = ListUtil.createList((Object[])new JavaClass[]{((JavaClassBuilder)this.builder.get()).innerClass().className("AClass").build(), ((JavaClassBuilder)this.builder.get()).innerClass().className("BClass").build()});
        this.clazz = ((JavaClassBuilder)this.builder.get()).className("CClassName").innerClasses(classes).build();
        Assertions.assertEquals((Object)classes, (Object)this.clazz.getInnerClasses());
    }

    @Test
    public void testBuilderSet1InnerClass() {
        JavaClass class2 = ((JavaClassBuilder)this.builder.get()).innerClass().className("AClass").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className("BClassName").innerClass(class2).build();
        List innerClasses = this.clazz.getInnerClasses();
        Assertions.assertEquals((int)1, (int)innerClasses.size());
        Assertions.assertEquals((Object)class2, innerClasses.get(0));
    }

    @Test
    public void testBuilderSetFields() {
        List fields = ListUtil.createList((Object[])new JavaField[]{((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build(), ((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()});
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).fields(fields).build();
        Assertions.assertEquals((Object)fields, (Object)this.clazz.getFields());
    }

    @Test
    public void testBuilderSetField() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).build();
        List fields = this.clazz.getFields();
        Assertions.assertEquals((int)1, (int)fields.size());
        JavaField field = (JavaField)fields.get(0);
        Assertions.assertEquals((Object)Visibility.NONE, (Object)field.getVisibility());
        Assertions.assertEquals((Object)"int", (Object)field.getType());
        Assertions.assertEquals((Object)"test", (Object)field.getName());
    }

    @Test
    public void testBuilderSetMethods() {
        List methods = ListUtil.createList((Object[])new JavaMethod[]{((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("int").name("test").build(), ((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("derp").build()});
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).methods(methods).build();
        Assertions.assertEquals((Object)methods, (Object)this.clazz.getMethods());
    }

    @Test
    public void testBuilderSetMethod() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("int").name("someMethod").line("return 42;").build()).build();
        List methods = this.clazz.getMethods();
        Assertions.assertEquals((int)1, (int)methods.size());
        JavaMethod method = (JavaMethod)methods.get(0);
        Assertions.assertEquals((Object)Visibility.NONE, (Object)method.getVisibility());
        Assertions.assertEquals((Object)"int", (Object)method.getReturnType());
        Assertions.assertEquals((Object)"someMethod", (Object)method.getName());
        Assertions.assertTrue((boolean)method.getParameters().isEmpty());
        List lines = method.getLines();
        Assertions.assertEquals((int)1, (int)lines.size());
        Assertions.assertEquals((Object)"return 42;", lines.get(0));
    }

    @Test
    public void testBuilderNullVisibility() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).visibility(null).className("AClassName").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Visibility is required!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderNullClassName() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify className!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAbstractStatic() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).innerClass().isAbstract().isStatic().build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Can't be abstract and static!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAbstractFinal() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).isAbstract().isFinal().build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Can't be abstract and final!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAllAbstractErrors() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).innerClass().isAbstract().isStatic().isFinal().build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Can't be abstract and static!\nCan't be abstract and final!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderInnerClassNotInnerClass() {
        try {
            JavaClass inner = ((JavaClassBuilder)this.builder.get()).className(this.className).build();
            this.clazz = ((JavaClassBuilder)this.builder.get()).className("BClassName").innerClass(inner).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Inner class 'AClassName' is not an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderOuterClassCantBeStatic() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).isStatic().className(this.className).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Only inner classes can be static!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAllOuterClassErrors() {
        try {
            JavaClass inner = ((JavaClassBuilder)this.builder.get()).className(this.className).build();
            this.clazz = ((JavaClassBuilder)this.builder.get()).isStatic().innerClass(inner).visibility(null).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Visibility is required!\nMust specify className!\nInner class 'AClassName' is not an inner class!\nOnly inner classes can be static!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderNullVisibilityInnerClass() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().visibility(null).className("AClassName").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Visibility is required!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderNullClassNameInnerClass() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify className!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderInnerClassNotInnerClassInInnerClass() {
        try {
            JavaClass inner = ((JavaClassBuilder)this.builder.get()).className(this.className).build();
            this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").innerClass(inner).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Inner class 'AClassName' is not an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderSetPackageDeclarationInnerClass() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().packageDeclaration(((JavaPackageDeclarationBuilder)this.javaPackageDeclarationBuilder.get()).packageName("some.package").build()).className(this.className).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Not allowed to have package declaration for an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderSetImportStatementInnerClass() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().className(this.className).importStatement(((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Not allowed to have import statements for an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAllInnerClassBuilderErrors() {
        try {
            JavaClass inner = ((JavaClassBuilder)this.builder.get()).packageDeclaration(((JavaPackageDeclarationBuilder)this.javaPackageDeclarationBuilder.get()).packageName("some.package").build()).className(this.className).build();
            this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().packageDeclaration(((JavaPackageDeclarationBuilder)this.javaPackageDeclarationBuilder.get()).packageName("some.package").build()).innerClass(inner).importStatement(((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example").build()).visibility(null).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Visibility is required!\nMust specify className!\nInner class 'AClassName' is not an inner class!\nNot allowed to have package declaration for an inner class!\nNot allowed to have import statements for an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissingInnerElementsOrderWhenSingleLineCommentsPresent() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).innerElementsOrder(new ArrayList()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"innerElementsOrder is required when comments are present!", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissingInnerElementsOrderWhenMultiLineCommentsPresent() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).multiLineComment(((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some comment").content("more content").build()).innerElementsOrder(new ArrayList()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"innerElementsOrder is required when comments are present!", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissingInnerElementsOrderWhenBothTypesOfCommentsPresent() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).multiLineComment(((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some comment").content("more content").build()).innerElementsOrder(new ArrayList()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"innerElementsOrder is required when comments are present!", (Object)e.getMessage());
        }
    }

    @Test
    public void testSpecifiedTooManySingleLineCommentsInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, null), Pair.of((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, null)})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Specified more single-line comments in innerElementsOrder than we have!", (Object)e.getMessage());
        }
    }

    @Test
    public void testSpecifiedTooManyMultiLineCommentsInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).multiLineComment(((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some comment").content("more content").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.MULTI_LINE_COMMENT, null), Pair.of((Object)JavaCodeTypes.MULTI_LINE_COMMENT, null)})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Specified more multi-line comments in innerElementsOrder than we have!", (Object)e.getMessage());
        }
    }

    @Test
    public void testReusedInnerClassNameInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.CLASS, (Object)"BClassName"), Pair.of((Object)JavaCodeTypes.CLASS, (Object)"BClassName")})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Already used inner class named: BClassName", (Object)e.getMessage());
        }
    }

    @Test
    public void testUnknownInnerClassNameInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.CLASS, (Object)"BClassName"), Pair.of((Object)JavaCodeTypes.CLASS, (Object)"CClassName")})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Unknown inner class name: CClassName", (Object)e.getMessage());
        }
    }

    @Test
    public void testReusedFieldNameInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.FIELD, (Object)"test"), Pair.of((Object)JavaCodeTypes.FIELD, (Object)"test")})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Already used field named: test", (Object)e.getMessage());
        }
    }

    @Test
    public void testUnknownFieldNameInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.FIELD, (Object)"test"), Pair.of((Object)JavaCodeTypes.FIELD, (Object)"derp")})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Unknown field name: derp", (Object)e.getMessage());
        }
    }

    @Test
    public void testReusedMethodNameInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("int").name("getVersion").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.METHOD, (Object)"getVersion()"), Pair.of((Object)JavaCodeTypes.METHOD, (Object)"getVersion()")})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Already used method named: getVersion()", (Object)e.getMessage());
        }
    }

    @Test
    public void testUnknownMethodNameInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("int").name("getVersion").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.METHOD, (Object)"getVersion()"), Pair.of((Object)JavaCodeTypes.METHOD, (Object)"getSomething()")})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Unknown method name: getSomething()", (Object)e.getMessage());
        }
    }

    @Test
    public void testUnknownInnerElementType() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.ANNOTATION, (Object)"something")})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)("Unknown inner element type: " + JavaCodeTypes.ANNOTATION.getStandardName()), (Object)e.getMessage());
        }
    }

    @Test
    public void testMissedOneSingleLineCommentInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some other comment").build()).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some third comment").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, null), Pair.of((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, null)})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Missed 1 single-line comments in innerElementsOrder!", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissedTwoSingleLineCommentsInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some other comment").build()).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some third comment").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, null)})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Missed 2 single-line comments in innerElementsOrder!", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissedOneMultiLineCommentInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).multiLineComment(((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some comment").build()).multiLineComment(((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some other comment").build()).multiLineComment(((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some third comment").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.MULTI_LINE_COMMENT, null), Pair.of((Object)JavaCodeTypes.MULTI_LINE_COMMENT, null)})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Missed 1 multi-line comments in innerElementsOrder!", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissedTwoMultiLineCommentsInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).multiLineComment(((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some comment").build()).multiLineComment(((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some other comment").build()).multiLineComment(((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some third comment").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.MULTI_LINE_COMMENT, null)})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Missed 2 multi-line comments in innerElementsOrder!", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissedOneInnerClassInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, null)})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"The following inner classes were not specified in innerElementsOrder: BClassName", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissedTwoInnerClassesInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, null)})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"The following inner classes were not specified in innerElementsOrder: BClassName,CClassName", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissedOneFieldInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("version").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, null)})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"The following fields were not specified in innerElementsOrder: version", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissedTwoFieldsInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("version").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("test").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, null)})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"The following fields were not specified in innerElementsOrder: version,test", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissedOneMethodInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("int").name("getVersion").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, null)})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"The following methods were not specified in innerElementsOrder: getVersion()", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissedTwoMethodsInnerElementsOrder() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("int").name("getVersion").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getTest").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, null)})).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"The following methods were not specified in innerElementsOrder: getVersion(),getTest()", (Object)e.getMessage());
        }
    }

    @Test
    public void testToString() {
        String javaString = "class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithPackageDeclaration() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageDeclaration(((JavaPackageDeclarationBuilder)this.javaPackageDeclarationBuilder.get()).packageName("some.package").build()).className(this.className).build();
        String javaString = "package some.package;\n\nclass AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithSuperClassName() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).superClassName("AnotherClassName").build();
        String javaString = "class AClassName extends AnotherClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithImplementsInterface() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).implementsInterfaceName("SomeInterface").build();
        String javaString = "class AClassName implements SomeInterface{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithMultipleImplementsInterfaces() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).implementsInterfaceName("SomeInterface").implementsInterfaceName("SomeOtherInterface").build();
        String javaString = "class AClassName implements SomeInterface, SomeOtherInterface{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithJavadoc() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).build();
        String javaString = "/**\n */\nclass AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithAnnotations() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        List annotations = ListUtil.createList((Object[])new JavaAnnotation[]{test, derp});
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).annotations(annotations).build();
        String javaString = "@Test\n@Derp\nclass AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithImport() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).importStatement(((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example.*").build()).build();
        String javaString = "import com.example.*;\n\nclass AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithImportsSameBaseInOrder() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).importStatements(ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.whatever").build()})).build();
        String javaString = "import com.example.*;\nimport com.whatever;\n\nclass AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithImportsSameBaseReverseOrder() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).importStatements(ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.whatever").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example.*").build()})).build();
        String javaString = "import com.example.*;\nimport com.whatever;\n\nclass AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithImportsDifferentBaseStrangeOrder() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).importStatements(ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.whatever").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.yep").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.test").build()})).build();
        String javaString = "import com.example.*;\nimport com.whatever;\n\nimport org.test;\nimport org.yep;\n\nclass AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithStaticImport() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).importStatement(((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.example.*").build()).build();
        String javaString = "import static com.example.*;\n\nclass AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithStaticImportsSameBaseInOrder() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).importStatements(ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.example.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.whatever").build()})).build();
        String javaString = "import static com.example.*;\nimport static com.whatever;\n\nclass AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithStaticImportsSameBaseReverseOrder() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).importStatements(ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.whatever").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.example.*").build()})).build();
        String javaString = "import static com.example.*;\nimport static com.whatever;\n\nclass AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithStaticImportsDifferentBaseStrangeOrder() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).importStatements(ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.whatever").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.yep").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.example.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.test").build()})).build();
        String javaString = "import static com.example.*;\nimport static com.whatever;\n\nimport static org.test;\nimport static org.yep;\n\nclass AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithRegularAndStaticImportsDifferentBaseStrangeOrder() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).importStatements(ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.whatever").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.yep").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.test").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.whatever.electric_boogaloo").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.yep.dope").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.example.test.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.test.yep").build()})).build();
        String javaString = "import com.example.*;\nimport com.whatever;\n\nimport org.test;\nimport org.yep;\n\nimport static com.example.test.*;\nimport static com.whatever.electric_boogaloo;\n\nimport static org.test.yep;\nimport static org.yep.dope;\n\nclass AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithVisibility() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).visibility(Visibility.PROTECTED).build();
        String javaString = "protected class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithSingleLineComment() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).build();
        String javaString = "class AClassName{\n\t\n\t// some comment\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithMultiLineComment() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).multiLineComment(((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some comment").content("more content").build()).build();
        String javaString = "class AClassName{\n\t\n\t/*\n\t * some comment\n\t * more content\n\t */\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithInnerClasses() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).build();
        String javaString = "class AClassName{\n\t\n\tclass BClassName{\n\t\t\n\t}\n\t\n\tclass CClassName{\n\t\t\n\t}\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithInnerClassesSwapOrder() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.CLASS, (Object)"CClassName"), Pair.of((Object)JavaCodeTypes.CLASS, (Object)"BClassName")})).build();
        String javaString = "class AClassName{\n\t\n\tclass CClassName{\n\t\t\n\t}\n\t\n\tclass BClassName{\n\t\t\n\t}\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithFields() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).build();
        String javaString = "class AClassName{\n\t\n\tint test;\n\tString derp;\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithFieldsSwapOrder() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.FIELD, (Object)"derp"), Pair.of((Object)JavaCodeTypes.FIELD, (Object)"test")})).build();
        String javaString = "class AClassName{\n\t\n\tString derp;\n\tint test;\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithFieldsWithJavadocsOnFields() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).javadoc(((JavadocBuilder)this.javadocBuilder.get()).condensed().content("something").build()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).build();
        String javaString = "class AClassName{\n\t\n\t/** something */\n\tint test;\n\tString derp;\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithMethods() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        String javaString = "class AClassName{\n\t\n\tAClassName(){ }\n\t\n\tString getSomething(int test){\n\t\treturn doSomething();\n\t}\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithMethodsSwapOrder() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.METHOD, (Object)"getSomething(int test)"), Pair.of((Object)JavaCodeTypes.METHOD, (Object)"init()")})).build();
        String javaString = "class AClassName{\n\t\n\tString getSomething(int test){\n\t\treturn doSomething();\n\t}\n\t\n\tAClassName(){ }\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithMethodsOrderNotSpecified() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).innerElementsOrder(new ArrayList()).build();
        String javaString = "class AClassName{\n\t\n\tAClassName(){ }\n\t\n\tString getSomething(int test){\n\t\treturn doSomething();\n\t}\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithFinal() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).isFinal().className(this.className).build();
        String javaString = "final class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithAbstract() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).isAbstract().className(this.className).build();
        String javaString = "abstract class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithEverythingOrderNotSpecified() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageDeclaration(((JavaPackageDeclarationBuilder)this.javaPackageDeclarationBuilder.get()).packageName("some.package").build()).importStatements(ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.whatever").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.yep").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.test").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.whatever.electric_boogaloo").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.yep.dope").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.example.test.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.test.yep").build()})).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).visibility(Visibility.PUBLIC).isFinal().className(this.className).superClassName("AnotherClassName").implementsInterfaceName("SomeInterface").implementsInterfaceName("SomeOtherInterface").innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).innerElementsOrder(new ArrayList()).build();
        String javaString = "package some.package;\n\nimport com.example.*;\nimport com.whatever;\n\nimport org.test;\nimport org.yep;\n\nimport static com.example.test.*;\nimport static com.whatever.electric_boogaloo;\n\nimport static org.test.yep;\nimport static org.yep.dope;\n\n/**\n */\n@Test\n@Derp\npublic final class AClassName extends AnotherClassName implements SomeInterface, SomeOtherInterface{\n\t\n\tclass BClassName{\n\t\t\n\t}\n\t\n\tclass CClassName{\n\t\t\n\t}\n\t\n\tint test;\n\tString derp;\n\t\n\tAClassName(){ }\n\t\n\tString getSomething(int test){\n\t\treturn doSomething();\n\t}\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithEverything() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageDeclaration(((JavaPackageDeclarationBuilder)this.javaPackageDeclarationBuilder.get()).packageName("some.package").build()).importStatements(ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.whatever").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.yep").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.test").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.whatever.electric_boogaloo").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.yep.dope").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.example.test.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.test.yep").build()})).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).visibility(Visibility.PUBLIC).isFinal().className(this.className).superClassName("AnotherClassName").implementsInterfaceName("SomeInterface").implementsInterfaceName("SomeOtherInterface").singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).multiLineComment(((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some comment").content("more content").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        String javaString = "package some.package;\n\nimport com.example.*;\nimport com.whatever;\n\nimport org.test;\nimport org.yep;\n\nimport static com.example.test.*;\nimport static com.whatever.electric_boogaloo;\n\nimport static org.test.yep;\nimport static org.yep.dope;\n\n/**\n */\n@Test\n@Derp\npublic final class AClassName extends AnotherClassName implements SomeInterface, SomeOtherInterface{\n\t\n\t// some comment\n\t/*\n\t * some comment\n\t * more content\n\t */\n\t\n\tclass BClassName{\n\t\t\n\t}\n\t\n\tclass CClassName{\n\t\t\n\t}\n\t\n\tint test;\n\tString derp;\n\t\n\tAClassName(){ }\n\t\n\tString getSomething(int test){\n\t\treturn doSomething();\n\t}\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithEverythingReordered() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageDeclaration(((JavaPackageDeclarationBuilder)this.javaPackageDeclarationBuilder.get()).packageName("some.package").build()).importStatements(ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.whatever").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.yep").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.test").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.whatever.electric_boogaloo").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.yep.dope").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.example.test.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.test.yep").build()})).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).visibility(Visibility.PUBLIC).isFinal().className(this.className).superClassName("AnotherClassName").implementsInterfaceName("SomeInterface").implementsInterfaceName("SomeOtherInterface").singleLineComment(((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("some comment").build()).multiLineComment(((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("some comment").content("more content").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).innerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.MULTI_LINE_COMMENT, null), Pair.of((Object)JavaCodeTypes.CLASS, (Object)"CClassName"), Pair.of((Object)JavaCodeTypes.FIELD, (Object)"derp"), Pair.of((Object)JavaCodeTypes.METHOD, (Object)"getSomething(int test)"), Pair.of((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, null), Pair.of((Object)JavaCodeTypes.METHOD, (Object)"init()"), Pair.of((Object)JavaCodeTypes.FIELD, (Object)"test"), Pair.of((Object)JavaCodeTypes.CLASS, (Object)"BClassName")})).build();
        String javaString = "package some.package;\n\nimport com.example.*;\nimport com.whatever;\n\nimport org.test;\nimport org.yep;\n\nimport static com.example.test.*;\nimport static com.whatever.electric_boogaloo;\n\nimport static org.test.yep;\nimport static org.yep.dope;\n\n/**\n */\n@Test\n@Derp\npublic final class AClassName extends AnotherClassName implements SomeInterface, SomeOtherInterface{\n\t\n\t/*\n\t * some comment\n\t * more content\n\t */\n\t\n\tclass CClassName{\n\t\t\n\t}\n\t\n\tString derp;\n\t\n\tString getSomething(int test){\n\t\treturn doSomething();\n\t}\n\t\n\t// some comment\n\tAClassName(){ }\n\t\n\tint test;\n\tclass BClassName{\n\t\t\n\t}\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringInnerClass() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().className(this.className).build();
        Assertions.assertEquals((Object)"class AClassName{\n\t\n}\n", (Object)this.clazz.toString());
    }

    @Test
    public void testToStringStaticInnerClass() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().isStatic().className(this.className).build();
        Assertions.assertEquals((Object)"static class AClassName{\n\t\n}\n", (Object)this.clazz.toString());
    }

    @Test
    public void testToStringFinalInnerClass() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().isFinal().className(this.className).build();
        Assertions.assertEquals((Object)"final class AClassName{\n\t\n}\n", (Object)this.clazz.toString());
    }

    @Test
    public void testToStringInnerClassWithEverything() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).visibility(Visibility.PUBLIC).isStatic().isFinal().className(this.className).superClassName("AnotherClassName").innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        String javaString = "/**\n */\n@Test\n@Derp\npublic static final class AClassName extends AnotherClassName{\n\t\n\tclass BClassName{\n\t\t\n\t}\n\t\n\tclass CClassName{\n\t\t\n\t}\n\t\n\tint test;\n\tString derp;\n\t\n\tAClassName(){ }\n\t\n\tString getSomething(int test){\n\t\treturn doSomething();\n\t}\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testEquals() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageDeclaration(((JavaPackageDeclarationBuilder)this.javaPackageDeclarationBuilder.get()).packageName("some.package").build()).importStatements(ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.whatever").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.yep").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.test").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.whatever.electric_boogaloo").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.yep.dope").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.example.test.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.test.yep").build()})).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).className(this.className).superClassName("AnotherClassName").innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        JavaClass otherClass = ((JavaClassBuilder)this.builder.get()).packageDeclaration(((JavaPackageDeclarationBuilder)this.javaPackageDeclarationBuilder.get()).packageName("some.package").build()).importStatements(ListUtil.createList((Object[])new JavaImportStatement[]{((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.whatever").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.yep").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("com.example.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).importName("org.test").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.whatever.electric_boogaloo").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.yep.dope").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("com.example.test.*").build(), ((JavaImportStatementBuilder)this.javaImportStatementBuilder.get()).isStatic().importName("org.test.yep").build()})).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).className(this.className).superClassName("AnotherClassName").innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        Assertions.assertEquals(this.clazz, (Object)otherClass);
    }

    @Test
    public void testEqualsNotEqual() {
        JavaClass otherClass = ((JavaClassBuilder)this.builder.get()).packageDeclaration(((JavaPackageDeclarationBuilder)this.javaPackageDeclarationBuilder.get()).packageName("some.package.different").build()).className(this.className).build();
        Assertions.assertNotEquals(this.clazz, (Object)otherClass);
    }

    @Test
    public void testEqualsNotSameType() {
        Assertions.assertNotEquals(this.clazz, (Object)"testing");
    }

    @Test
    public void testToBuilderCode() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeInnerClass() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().className(this.className).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.innerClass()\n\t\t.className(\"" + this.className + "\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithPackageName() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName("com.example").className(this.className).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.packageName(\"com.example\")\n\t\t.className(\"" + this.className + "\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithRegularImport() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).importName("com.something.*", false).className(this.className).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.importName(\"com.something.*\", false)\n\t\t.className(\"" + this.className + "\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithStaticImport() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).importName("com.something.else.*", true).className(this.className).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.importName(\"com.something.else.*\", true)\n\t\t.className(\"" + this.className + "\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithRegularAndStaticImports() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).importName("com.something.*", false).importName("com.something.else.*", true).className(this.className).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.importName(\"com.something.*\", false)\n\t\t.importName(\"com.something.else.*\", true)\n\t\t.className(\"" + this.className + "\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithJavadoc() {
        Javadoc javadoc = ((JavadocBuilder)this.javadocBuilder.get()).build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).javadoc(javadoc).className(this.className).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.javadoc(" + javadoc.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.className(\"" + this.className + "\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithOneAnnotation() {
        JavaAnnotation annotation = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).annotation(annotation).className(this.className).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.annotation(" + annotation.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.className(\"" + this.className + "\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithTwoAnnotations() {
        JavaAnnotation annotation = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation annotation2 = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).annotation(annotation).annotation(annotation2).className(this.className).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.annotation(" + annotation.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.annotation(" + annotation2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.className(\"" + this.className + "\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithVisibility() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).visibility(Visibility.PUBLIC).className(this.className).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.visibility(Visibility.PUBLIC)\n\t\t.className(\"" + this.className + "\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithAbstract() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).isAbstract().className(this.className).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.isAbstract()\n\t\t.className(\"" + this.className + "\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithStatic() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().isStatic().className(this.className).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.innerClass()\n\t\t.isStatic()\n\t\t.className(\"" + this.className + "\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithFinal() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).isFinal().className(this.className).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.isFinal()\n\t\t.className(\"" + this.className + "\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithExtends() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).superClassName("Something").build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.superClassName(\"Something\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithOneImplements() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).implementsInterfaceName("Test").build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.implementsInterfaceName(\"Test\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithTwoImplements() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).implementsInterfaceName("Test").implementsInterfaceName("Blah").build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.implementsInterfaceName(\"Test\")\n\t\t.implementsInterfaceName(\"Blah\")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithSingleLineComment() {
        JavaSingleLineComment singleLineComment = ((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("something useful").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(singleLineComment).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.singleLineComment(" + singleLineComment.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithTwoSingleLineComments() {
        JavaSingleLineComment singleLineComment = ((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("something useful").build();
        JavaSingleLineComment singleLineComment2 = ((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("something else useful").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).singleLineComment(singleLineComment).singleLineComment(singleLineComment2).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.singleLineComment(" + singleLineComment.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.singleLineComment(" + singleLineComment2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithMultiLineComment() {
        JavaMultiLineComment multiLineComment = ((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("something useful").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).multiLineComment(multiLineComment).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.multiLineComment(" + multiLineComment.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithTwoMultiLineComments() {
        JavaMultiLineComment multiLineComment = ((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("something useful").build();
        JavaMultiLineComment multiLineComment2 = ((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("something else useful").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).multiLineComment(multiLineComment).multiLineComment(multiLineComment2).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.multiLineComment(" + multiLineComment.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.multiLineComment(" + multiLineComment2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithInnerClass() {
        JavaClass innerClass = ((JavaClassBuilder)this.builder.get()).innerClass().className("Test").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).innerClass(innerClass).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.innerClass(" + innerClass.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithTwoInnerClasses() {
        JavaClass innerClass = ((JavaClassBuilder)this.builder.get()).innerClass().className("Test").build();
        JavaClass innerClass2 = ((JavaClassBuilder)this.builder.get()).innerClass().className("Test2").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).innerClass(innerClass).innerClass(innerClass2).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.innerClass(" + innerClass.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.innerClass(" + innerClass2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithField() {
        JavaField field = ((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("version").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).field(field).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.field(" + field.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithTwoFields() {
        JavaField field = ((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("version").build();
        JavaField field2 = ((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("something").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).field(field).field(field2).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.field(" + field.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.field(" + field2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithMethod() {
        JavaMethod method = ((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).method(method).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.method(" + method.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithTwoMethods() {
        JavaMethod method = ((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build();
        JavaMethod method2 = ((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("int").name("getVersion").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).method(method).method(method2).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.method(" + method.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.method(" + method2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithInnerStuffOrdered() {
        JavaSingleLineComment singleLineComment = ((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("something useful").build();
        JavaSingleLineComment singleLineComment2 = ((JavaSingleLineCommentBuilder)this.singleLineCommentBuilder.get()).content("something else useful").build();
        JavaMultiLineComment multiLineComment = ((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("something useful").build();
        JavaMultiLineComment multiLineComment2 = ((JavaMultiLineCommentBuilder)this.multiLineCommentBuilder.get()).content("something else useful").build();
        JavaClass innerClass = ((JavaClassBuilder)this.builder.get()).innerClass().className("Test").build();
        JavaClass innerClass2 = ((JavaClassBuilder)this.builder.get()).innerClass().className("Test2").build();
        JavaField field = ((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("version").build();
        JavaField field2 = ((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("something").build();
        JavaMethod method = ((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build();
        JavaMethod method2 = ((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("int").name("getVersion").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).multiLineComment(multiLineComment2).method(method2).field(field).singleLineComment(singleLineComment2).method(method).innerClass(innerClass2).multiLineComment(multiLineComment).field(field2).singleLineComment(singleLineComment).innerClass(innerClass).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.multiLineComment(" + multiLineComment2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.method(" + method2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.field(" + field.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.singleLineComment(" + singleLineComment2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.method(" + method.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.innerClass(" + innerClass2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.multiLineComment(" + multiLineComment.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.field(" + field2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.singleLineComment(" + singleLineComment.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.innerClass(" + innerClass.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithInnerStuffNotOrdered() {
        JavaClass innerClass = ((JavaClassBuilder)this.builder.get()).innerClass().className("Test").build();
        JavaClass innerClass2 = ((JavaClassBuilder)this.builder.get()).innerClass().className("Test2").build();
        JavaField field = ((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("version").build();
        JavaField field2 = ((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("something").build();
        JavaMethod method = ((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build();
        JavaMethod method2 = ((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("int").name("getVersion").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).method(method).field(field).method(method2).innerClass(innerClass).field(field2).innerClass(innerClass2).innerElementsOrder(new ArrayList()).build();
        Assertions.assertEquals((Object)(this.theClazz.getSimpleName() + ".builder()\n\t\t.className(\"" + this.className + "\")\n\t\t.innerClass(" + innerClass.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.innerClass(" + innerClass2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.field(" + field.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.field(" + field2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.method(" + method.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.method(" + method2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.build()"), (Object)this.clazz.toBuilderCode());
    }
}

