/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.javaclass;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.comment.UneditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.UneditableJavaSingleLineComment;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.field.UneditableJavaField;
import com.github.tadukoo.java.importstatement.EditableJavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.importstatement.UneditableJavaImportStatement;
import com.github.tadukoo.java.javaclass.DefaultJavaClassTest;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javaclass.UneditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.UneditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.method.UneditableJavaMethod;
import com.github.tadukoo.java.packagedeclaration.EditableJavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.UneditableJavaPackageDeclaration;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EditableJavaClassTest
extends DefaultJavaClassTest<EditableJavaClass> {
    public EditableJavaClassTest() {
        super(EditableJavaClass.class, EditableJavaClass::builder, EditableJavaPackageDeclaration::builder, EditableJavaImportStatement::builder, EditableJavaAnnotation::builder, EditableJavadoc::builder, EditableJavaSingleLineComment::builder, EditableJavaMultiLineComment::builder, EditableJavaField::builder, EditableJavaMethod::builder);
    }

    @Test
    public void testIsEditable() {
        Assertions.assertTrue((boolean)((EditableJavaClass)this.clazz).isEditable());
    }

    @Test
    public void testBuilderUneditablePackageDeclarationError() {
        try {
            EditableJavaClass.builder().packageDeclaration(UneditableJavaPackageDeclaration.builder().packageName("some.package").build()).className(this.className).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"package declaration is not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testAllBuilderUneditableImportStatementError() {
        try {
            EditableJavaClass.builder().importStatement(UneditableJavaImportStatement.builder().importName("some.import").build()).className(this.className).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some import statements are not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderUneditableJavadocError() {
        try {
            EditableJavaClass.builder().className(this.className).javadoc(UneditableJavadoc.builder().build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderUneditableAnnotationError() {
        try {
            EditableJavaClass.builder().className(this.className).annotation(UneditableJavaAnnotation.builder().name("Test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some annotations are not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderUneditableSingleLineCommentError() {
        try {
            EditableJavaClass.builder().className(this.className).singleLineComment(UneditableJavaSingleLineComment.builder().content("some comment").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some single-line comments are not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderUneditableMultiLineCommentError() {
        try {
            EditableJavaClass.builder().className(this.className).multiLineComment(UneditableJavaMultiLineComment.builder().content("some comment").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some multi-line comments are not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderUneditableInnerClassError() {
        try {
            EditableJavaClass.builder().className(this.className).innerClass(UneditableJavaClass.builder().innerClass().className(this.className).build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some inner classes are not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderUneditableFieldError() {
        try {
            EditableJavaClass.builder().className(this.className).field(UneditableJavaField.builder().type("String").name("test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some fields are not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderUneditableMethodError() {
        try {
            EditableJavaClass.builder().className(this.className).method(UneditableJavaMethod.builder().returnType("String").name("test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some methods are not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testAllBuilderSpecificErrors() {
        try {
            EditableJavaClass.builder().packageDeclaration(UneditableJavaPackageDeclaration.builder().packageName("some.package").build()).importStatement(UneditableJavaImportStatement.builder().importName("some.import").build()).className(this.className).javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).singleLineComment(UneditableJavaSingleLineComment.builder().content("some comment").build()).multiLineComment(UneditableJavaMultiLineComment.builder().content("some comment").build()).innerClass(UneditableJavaClass.builder().innerClass().className(this.className).build()).field(UneditableJavaField.builder().type("String").name("test").build()).method(UneditableJavaMethod.builder().returnType("String").name("test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"package declaration is not editable in this editable JavaClass\nsome import statements are not editable in this editable JavaClass\njavadoc is not editable in this editable JavaClass\nsome annotations are not editable in this editable JavaClass\nsome single-line comments are not editable in this editable JavaClass\nsome multi-line comments are not editable in this editable JavaClass\nsome inner classes are not editable in this editable JavaClass\nsome fields are not editable in this editable JavaClass\nsome methods are not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetInnerClass() {
        Assertions.assertFalse((boolean)((EditableJavaClass)this.clazz).isInnerClass());
        ((EditableJavaClass)this.clazz).setInnerClass(false);
        Assertions.assertFalse((boolean)((EditableJavaClass)this.clazz).isInnerClass());
        ((EditableJavaClass)this.clazz).setInnerClass(true);
        Assertions.assertTrue((boolean)((EditableJavaClass)this.clazz).isInnerClass());
    }

    @Test
    public void testSetPackageDeclaration() {
        JavaPackageDeclaration packageDeclaration = EditableJavaPackageDeclaration.builder().packageName("some.random.package.name").build();
        Assertions.assertNull((Object)((EditableJavaClass)this.clazz).getPackageDeclaration());
        ((EditableJavaClass)this.clazz).setPackageDeclaration(packageDeclaration);
        Assertions.assertEquals((Object)packageDeclaration, (Object)((EditableJavaClass)this.clazz).getPackageDeclaration());
    }

    @Test
    public void testSetPackageDeclarationUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setPackageDeclaration(UneditableJavaPackageDeclaration.builder().packageName("some.package").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable package declaration", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetPackageName() {
        Assertions.assertNull((Object)((EditableJavaClass)this.clazz).getPackageDeclaration());
        ((EditableJavaClass)this.clazz).setPackageName("some.random.package.name");
        Assertions.assertEquals((Object)EditableJavaPackageDeclaration.builder().packageName("some.random.package.name").build(), (Object)((EditableJavaClass)this.clazz).getPackageDeclaration());
    }

    @Test
    public void testAddImportStatement() {
        JavaImportStatement importStatement = EditableJavaImportStatement.builder().importName("com.example").build();
        JavaImportStatement importStatement2 = EditableJavaImportStatement.builder().importName("org.test").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getImportStatements());
        ((EditableJavaClass)this.clazz).addImportStatement(importStatement);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{importStatement}), (Object)((EditableJavaClass)this.clazz).getImportStatements());
        ((EditableJavaClass)this.clazz).addImportStatement(importStatement2);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{importStatement, importStatement2}), (Object)((EditableJavaClass)this.clazz).getImportStatements());
    }

    @Test
    public void testAddImportStatementUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addImportStatement(UneditableJavaImportStatement.builder().importName("com.example").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable import statements", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddImportStatements() {
        JavaImportStatement importStatement = EditableJavaImportStatement.builder().importName("com.example").build();
        JavaImportStatement importStatement2 = EditableJavaImportStatement.builder().importName("org.test").build();
        JavaImportStatement importStatement3 = EditableJavaImportStatement.builder().importName("java.whatever").build();
        JavaImportStatement importStatement4 = EditableJavaImportStatement.builder().importName("org.yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getImportStatements());
        ((EditableJavaClass)this.clazz).addImportStatements(ListUtil.createList((Object[])new JavaImportStatement[]{importStatement, importStatement2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{importStatement, importStatement2}), (Object)((EditableJavaClass)this.clazz).getImportStatements());
        ((EditableJavaClass)this.clazz).addImportStatements(ListUtil.createList((Object[])new JavaImportStatement[]{importStatement3, importStatement4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{importStatement, importStatement2, importStatement3, importStatement4}), (Object)((EditableJavaClass)this.clazz).getImportStatements());
    }

    @Test
    public void testAddImportStatementsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addImportStatements(ListUtil.createList((Object[])new JavaImportStatement[]{UneditableJavaImportStatement.builder().importName("com.example").build(), UneditableJavaImportStatement.builder().importName("yep").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable import statements", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetImportStatements() {
        JavaImportStatement importStatement = EditableJavaImportStatement.builder().importName("com.example").build();
        JavaImportStatement importStatement2 = EditableJavaImportStatement.builder().importName("org.test").build();
        JavaImportStatement importStatement3 = EditableJavaImportStatement.builder().importName("java.whatever").build();
        JavaImportStatement importStatement4 = EditableJavaImportStatement.builder().importName("org.yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getImportStatements());
        ((EditableJavaClass)this.clazz).setImportStatements(ListUtil.createList((Object[])new JavaImportStatement[]{importStatement, importStatement2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{importStatement, importStatement2}), (Object)((EditableJavaClass)this.clazz).getImportStatements());
        ((EditableJavaClass)this.clazz).setImportStatements(ListUtil.createList((Object[])new JavaImportStatement[]{importStatement3, importStatement4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{importStatement3, importStatement4}), (Object)((EditableJavaClass)this.clazz).getImportStatements());
    }

    @Test
    public void testSetImportStatementsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setImportStatements(ListUtil.createList((Object[])new JavaImportStatement[]{UneditableJavaImportStatement.builder().importName("com.example").build(), UneditableJavaImportStatement.builder().importName("yep").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable import statements", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddImportName() {
        String importName1 = "com.example";
        String importName2 = "org.test";
        JavaImportStatement importStatement = EditableJavaImportStatement.builder().importName(importName1).build();
        JavaImportStatement importStatement2 = EditableJavaImportStatement.builder().isStatic().importName(importName2).build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getImportStatements());
        ((EditableJavaClass)this.clazz).addImportName(importName1, false);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{importStatement}), (Object)((EditableJavaClass)this.clazz).getImportStatements());
        ((EditableJavaClass)this.clazz).addImportName(importName2, true);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{importStatement, importStatement2}), (Object)((EditableJavaClass)this.clazz).getImportStatements());
    }

    @Test
    public void testAddImportNames() {
        String importName1 = "com.example";
        String importName2 = "org.test";
        String importName3 = "java.whatever";
        String importName4 = "org.yep";
        JavaImportStatement importStatement = EditableJavaImportStatement.builder().importName(importName1).build();
        JavaImportStatement importStatement2 = EditableJavaImportStatement.builder().importName(importName2).build();
        JavaImportStatement importStatement3 = EditableJavaImportStatement.builder().isStatic().importName(importName3).build();
        JavaImportStatement importStatement4 = EditableJavaImportStatement.builder().isStatic().importName(importName4).build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getImportStatements());
        ((EditableJavaClass)this.clazz).addImportNames(ListUtil.createList((Object[])new String[]{importName1, importName2}), false);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{importStatement, importStatement2}), (Object)((EditableJavaClass)this.clazz).getImportStatements());
        ((EditableJavaClass)this.clazz).addImportNames(ListUtil.createList((Object[])new String[]{importName3, importName4}), true);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{importStatement, importStatement2, importStatement3, importStatement4}), (Object)((EditableJavaClass)this.clazz).getImportStatements());
    }

    @Test
    public void testSetImportNames() {
        String importName1 = "com.example";
        String importName2 = "org.test";
        String importName3 = "java.whatever";
        String importName4 = "org.yep";
        JavaImportStatement importStatement = EditableJavaImportStatement.builder().importName(importName1).build();
        JavaImportStatement importStatement2 = EditableJavaImportStatement.builder().importName(importName2).build();
        JavaImportStatement importStatement3 = EditableJavaImportStatement.builder().isStatic().importName(importName3).build();
        JavaImportStatement importStatement4 = EditableJavaImportStatement.builder().isStatic().importName(importName4).build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getImportStatements());
        ((EditableJavaClass)this.clazz).setImportNames(ListUtil.createList((Object[])new String[]{importName1, importName2}), false);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{importStatement, importStatement2}), (Object)((EditableJavaClass)this.clazz).getImportStatements());
        ((EditableJavaClass)this.clazz).setImportNames(ListUtil.createList((Object[])new String[]{importName3, importName4}), true);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaImportStatement[]{importStatement3, importStatement4}), (Object)((EditableJavaClass)this.clazz).getImportStatements());
    }

    @Test
    public void testSetJavadoc() {
        Assertions.assertNull((Object)((EditableJavaClass)this.clazz).getJavadoc());
        ((EditableJavaClass)this.clazz).setJavadoc(EditableJavadoc.builder().build());
        Assertions.assertEquals((Object)EditableJavadoc.builder().build(), (Object)((EditableJavaClass)this.clazz).getJavadoc());
    }

    @Test
    public void testSetJavadocUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setJavadoc(UneditableJavadoc.builder().build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Javadoc", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAnnotation() {
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getAnnotations());
        ((EditableJavaClass)this.clazz).addAnnotation(test);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test}), (Object)((EditableJavaClass)this.clazz).getAnnotations());
        ((EditableJavaClass)this.clazz).addAnnotation(derp);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)((EditableJavaClass)this.clazz).getAnnotations());
    }

    @Test
    public void testAddAnnotationUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addAnnotation(UneditableJavaAnnotation.builder().name("Test").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAnnotations() {
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        JavaAnnotation blah = EditableJavaAnnotation.builder().name("Blah").build();
        JavaAnnotation yep = EditableJavaAnnotation.builder().name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getAnnotations());
        ((EditableJavaClass)this.clazz).addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)((EditableJavaClass)this.clazz).getAnnotations());
        ((EditableJavaClass)this.clazz).addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp, blah, yep}), (Object)((EditableJavaClass)this.clazz).getAnnotations());
    }

    @Test
    public void testAddAnnotationsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{UneditableJavaAnnotation.builder().name("Test").build(), UneditableJavaAnnotation.builder().name("Derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetAnnotations() {
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        JavaAnnotation blah = EditableJavaAnnotation.builder().name("Blah").build();
        JavaAnnotation yep = EditableJavaAnnotation.builder().name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getAnnotations());
        ((EditableJavaClass)this.clazz).setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)((EditableJavaClass)this.clazz).getAnnotations());
        ((EditableJavaClass)this.clazz).setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}), (Object)((EditableJavaClass)this.clazz).getAnnotations());
    }

    @Test
    public void testSetAnnotationsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{UneditableJavaAnnotation.builder().name("Test").build(), UneditableJavaAnnotation.builder().name("Derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetVisibility() {
        Assertions.assertEquals((Object)Visibility.NONE, (Object)((EditableJavaClass)this.clazz).getVisibility());
        ((EditableJavaClass)this.clazz).setVisibility(Visibility.PRIVATE);
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)((EditableJavaClass)this.clazz).getVisibility());
    }

    @Test
    public void testSetAbstract() {
        Assertions.assertFalse((boolean)((EditableJavaClass)this.clazz).isAbstract());
        ((EditableJavaClass)this.clazz).setAbstract(false);
        Assertions.assertFalse((boolean)((EditableJavaClass)this.clazz).isAbstract());
        ((EditableJavaClass)this.clazz).setAbstract(true);
        Assertions.assertTrue((boolean)((EditableJavaClass)this.clazz).isAbstract());
    }

    @Test
    public void testSetStatic() {
        Assertions.assertFalse((boolean)((EditableJavaClass)this.clazz).isStatic());
        ((EditableJavaClass)this.clazz).setStatic(false);
        Assertions.assertFalse((boolean)((EditableJavaClass)this.clazz).isStatic());
        ((EditableJavaClass)this.clazz).setStatic(true);
        Assertions.assertTrue((boolean)((EditableJavaClass)this.clazz).isStatic());
    }

    @Test
    public void testSetFinal() {
        Assertions.assertFalse((boolean)((EditableJavaClass)this.clazz).isFinal());
        ((EditableJavaClass)this.clazz).setFinal(false);
        Assertions.assertFalse((boolean)((EditableJavaClass)this.clazz).isFinal());
        ((EditableJavaClass)this.clazz).setFinal(true);
        Assertions.assertTrue((boolean)((EditableJavaClass)this.clazz).isFinal());
    }

    @Test
    public void testSetClassName() {
        Assertions.assertEquals((Object)this.className, (Object)((EditableJavaClass)this.clazz).getClassName());
        ((EditableJavaClass)this.clazz).setClassName("SomethingElse");
        Assertions.assertEquals((Object)"SomethingElse", (Object)((EditableJavaClass)this.clazz).getClassName());
    }

    @Test
    public void testSetSuperClassName() {
        Assertions.assertNull((Object)((EditableJavaClass)this.clazz).getSuperClassName());
        ((EditableJavaClass)this.clazz).setSuperClassName("SomethingElse");
        Assertions.assertEquals((Object)"SomethingElse", (Object)((EditableJavaClass)this.clazz).getSuperClassName());
    }

    @Test
    public void testAddImplementsInterfaceName() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Object[0]), (Object)((EditableJavaClass)this.clazz).getImplementsInterfaceNames());
        ((EditableJavaClass)this.clazz).addImplementsInterfaceName("SomeInterface");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"SomeInterface"}), (Object)((EditableJavaClass)this.clazz).getImplementsInterfaceNames());
        ((EditableJavaClass)this.clazz).addImplementsInterfaceName("SomeOtherInterface");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"SomeInterface", "SomeOtherInterface"}), (Object)((EditableJavaClass)this.clazz).getImplementsInterfaceNames());
    }

    @Test
    public void testAddImplementsInterfaceNames() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Object[0]), (Object)((EditableJavaClass)this.clazz).getImplementsInterfaceNames());
        ((EditableJavaClass)this.clazz).addImplementsInterfaceNames(ListUtil.createList((Object[])new String[]{"SomeInterface", "SomeOtherInterface"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"SomeInterface", "SomeOtherInterface"}), (Object)((EditableJavaClass)this.clazz).getImplementsInterfaceNames());
        ((EditableJavaClass)this.clazz).addImplementsInterfaceNames(ListUtil.createList((Object[])new String[]{"AInterface", "BInterface"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"SomeInterface", "SomeOtherInterface", "AInterface", "BInterface"}), (Object)((EditableJavaClass)this.clazz).getImplementsInterfaceNames());
    }

    @Test
    public void testSetImplementsInterfaceNames() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Object[0]), (Object)((EditableJavaClass)this.clazz).getImplementsInterfaceNames());
        ((EditableJavaClass)this.clazz).setImplementsInterfaceNames(ListUtil.createList((Object[])new String[]{"SomeInterface", "SomeOtherInterface"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"SomeInterface", "SomeOtherInterface"}), (Object)((EditableJavaClass)this.clazz).getImplementsInterfaceNames());
        ((EditableJavaClass)this.clazz).setImplementsInterfaceNames(ListUtil.createList((Object[])new String[]{"AInterface", "BInterface"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"AInterface", "BInterface"}), (Object)((EditableJavaClass)this.clazz).getImplementsInterfaceNames());
    }

    @Test
    public void testAddSingleLineComment() {
        JavaSingleLineComment comment1 = EditableJavaSingleLineComment.builder().content("some comment").build();
        JavaSingleLineComment comment2 = EditableJavaSingleLineComment.builder().content("some other comment").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getSingleLineComments());
        ((EditableJavaClass)this.clazz).addSingleLineComment(comment1);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaSingleLineComment[]{comment1}), (Object)((EditableJavaClass)this.clazz).getSingleLineComments());
        ((EditableJavaClass)this.clazz).addSingleLineComment(comment2);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaSingleLineComment[]{comment1, comment2}), (Object)((EditableJavaClass)this.clazz).getSingleLineComments());
    }

    @Test
    public void testAddSingleLineCommentUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addSingleLineComment(UneditableJavaSingleLineComment.builder().content("some comment").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable single-line comments", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddSingleLineComments() {
        JavaSingleLineComment comment1 = EditableJavaSingleLineComment.builder().content("some comment").build();
        JavaSingleLineComment comment2 = EditableJavaSingleLineComment.builder().content("some other comment").build();
        JavaSingleLineComment comment3 = EditableJavaSingleLineComment.builder().content("some 3rd comment").build();
        JavaSingleLineComment comment4 = EditableJavaSingleLineComment.builder().content("some other 4th comment").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getSingleLineComments());
        ((EditableJavaClass)this.clazz).addSingleLineComments(ListUtil.createList((Object[])new JavaSingleLineComment[]{comment1, comment2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaSingleLineComment[]{comment1, comment2}), (Object)((EditableJavaClass)this.clazz).getSingleLineComments());
        ((EditableJavaClass)this.clazz).addSingleLineComments(ListUtil.createList((Object[])new JavaSingleLineComment[]{comment3, comment4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaSingleLineComment[]{comment1, comment2, comment3, comment4}), (Object)((EditableJavaClass)this.clazz).getSingleLineComments());
    }

    @Test
    public void testAddSingleLineCommentsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addSingleLineComments(ListUtil.createList((Object[])new JavaSingleLineComment[]{UneditableJavaSingleLineComment.builder().content("some comment").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable single-line comments", (Object)e.getMessage());
        }
    }

    @Override
    @Test
    public void testSetSingleLineComments() {
        JavaSingleLineComment comment1 = EditableJavaSingleLineComment.builder().content("some comment").build();
        JavaSingleLineComment comment2 = EditableJavaSingleLineComment.builder().content("some other comment").build();
        JavaSingleLineComment comment3 = EditableJavaSingleLineComment.builder().content("some 3rd comment").build();
        JavaSingleLineComment comment4 = EditableJavaSingleLineComment.builder().content("some other 4th comment").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getSingleLineComments());
        ((EditableJavaClass)this.clazz).setSingleLineComments(ListUtil.createList((Object[])new JavaSingleLineComment[]{comment1, comment2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaSingleLineComment[]{comment1, comment2}), (Object)((EditableJavaClass)this.clazz).getSingleLineComments());
        ((EditableJavaClass)this.clazz).setSingleLineComments(ListUtil.createList((Object[])new JavaSingleLineComment[]{comment3, comment4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaSingleLineComment[]{comment3, comment4}), (Object)((EditableJavaClass)this.clazz).getSingleLineComments());
    }

    @Test
    public void testSetSingleLineCommentsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setSingleLineComments(ListUtil.createList((Object[])new JavaSingleLineComment[]{UneditableJavaSingleLineComment.builder().content("some comment").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable single-line comments", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddMultiLineComment() {
        JavaMultiLineComment comment1 = EditableJavaMultiLineComment.builder().content("some comment").build();
        JavaMultiLineComment comment2 = EditableJavaMultiLineComment.builder().content("some other comment").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getMultiLineComments());
        ((EditableJavaClass)this.clazz).addMultiLineComment(comment1);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMultiLineComment[]{comment1}), (Object)((EditableJavaClass)this.clazz).getMultiLineComments());
        ((EditableJavaClass)this.clazz).addMultiLineComment(comment2);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMultiLineComment[]{comment1, comment2}), (Object)((EditableJavaClass)this.clazz).getMultiLineComments());
    }

    @Test
    public void testAddMultiLineCommentUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addMultiLineComment(UneditableJavaMultiLineComment.builder().content("some comment").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable multi-line comments", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddMultiLineComments() {
        JavaMultiLineComment comment1 = EditableJavaMultiLineComment.builder().content("some comment").build();
        JavaMultiLineComment comment2 = EditableJavaMultiLineComment.builder().content("some other comment").build();
        JavaMultiLineComment comment3 = EditableJavaMultiLineComment.builder().content("some 3rd comment").build();
        JavaMultiLineComment comment4 = EditableJavaMultiLineComment.builder().content("some other 4th comment").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getMultiLineComments());
        ((EditableJavaClass)this.clazz).addMultiLineComments(ListUtil.createList((Object[])new JavaMultiLineComment[]{comment1, comment2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMultiLineComment[]{comment1, comment2}), (Object)((EditableJavaClass)this.clazz).getMultiLineComments());
        ((EditableJavaClass)this.clazz).addMultiLineComments(ListUtil.createList((Object[])new JavaMultiLineComment[]{comment3, comment4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMultiLineComment[]{comment1, comment2, comment3, comment4}), (Object)((EditableJavaClass)this.clazz).getMultiLineComments());
    }

    @Test
    public void testAddMultiLineCommentsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addMultiLineComments(ListUtil.createList((Object[])new JavaMultiLineComment[]{UneditableJavaMultiLineComment.builder().content("some comment").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable multi-line comments", (Object)e.getMessage());
        }
    }

    @Override
    @Test
    public void testSetMultiLineComments() {
        JavaMultiLineComment comment1 = EditableJavaMultiLineComment.builder().content("some comment").build();
        JavaMultiLineComment comment2 = EditableJavaMultiLineComment.builder().content("some other comment").build();
        JavaMultiLineComment comment3 = EditableJavaMultiLineComment.builder().content("some 3rd comment").build();
        JavaMultiLineComment comment4 = EditableJavaMultiLineComment.builder().content("some other 4th comment").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getMultiLineComments());
        ((EditableJavaClass)this.clazz).setMultiLineComments(ListUtil.createList((Object[])new JavaMultiLineComment[]{comment1, comment2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMultiLineComment[]{comment1, comment2}), (Object)((EditableJavaClass)this.clazz).getMultiLineComments());
        ((EditableJavaClass)this.clazz).setMultiLineComments(ListUtil.createList((Object[])new JavaMultiLineComment[]{comment3, comment4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMultiLineComment[]{comment3, comment4}), (Object)((EditableJavaClass)this.clazz).getMultiLineComments());
    }

    @Test
    public void testSetMultiLineCommentsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setMultiLineComments(ListUtil.createList((Object[])new JavaMultiLineComment[]{UneditableJavaMultiLineComment.builder().content("some comment").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable multi-line comments", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddInnerClass() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().className("Derp").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
        ((EditableJavaClass)this.clazz).addInnerClass(clazz1);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaClass[]{clazz1}), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
        ((EditableJavaClass)this.clazz).addInnerClass(clazz2);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaClass[]{clazz1, clazz2}), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
    }

    @Test
    public void testAddInnerClassUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addInnerClass(UneditableJavaClass.builder().className("Test").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable inner classes", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddInnerClasses() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().className("Derp").build();
        JavaClass clazz3 = EditableJavaClass.builder().className("Blah").build();
        JavaClass clazz4 = EditableJavaClass.builder().className("Yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
        ((EditableJavaClass)this.clazz).addInnerClasses(ListUtil.createList((Object[])new JavaClass[]{clazz1, clazz2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaClass[]{clazz1, clazz2}), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
        ((EditableJavaClass)this.clazz).addInnerClasses(ListUtil.createList((Object[])new JavaClass[]{clazz3, clazz4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaClass[]{clazz1, clazz2, clazz3, clazz4}), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
    }

    @Test
    public void testAddInnerClassesUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addInnerClasses(ListUtil.createList((Object[])new JavaClass[]{UneditableJavaClass.builder().className("Test").build(), UneditableJavaClass.builder().className("Derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable inner classes", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetInnerClasses() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().className("Derp").build();
        JavaClass clazz3 = EditableJavaClass.builder().className("Blah").build();
        JavaClass clazz4 = EditableJavaClass.builder().className("Yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
        ((EditableJavaClass)this.clazz).setInnerClasses(ListUtil.createList((Object[])new JavaClass[]{clazz1, clazz2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaClass[]{clazz1, clazz2}), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
        ((EditableJavaClass)this.clazz).setInnerClasses(ListUtil.createList((Object[])new JavaClass[]{clazz3, clazz4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaClass[]{clazz3, clazz4}), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
    }

    @Test
    public void testSetInnerClassesUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setInnerClasses(ListUtil.createList((Object[])new JavaClass[]{UneditableJavaClass.builder().className("Test").build(), UneditableJavaClass.builder().className("Derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable inner classes", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddField() {
        JavaField field1 = EditableJavaField.builder().type("String").name("test").build();
        JavaField field2 = EditableJavaField.builder().type("int").name("derp").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getFields());
        ((EditableJavaClass)this.clazz).addField(field1);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaField[]{field1}), (Object)((EditableJavaClass)this.clazz).getFields());
        ((EditableJavaClass)this.clazz).addField(field2);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaField[]{field1, field2}), (Object)((EditableJavaClass)this.clazz).getFields());
    }

    @Test
    public void testAddFieldUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addField(UneditableJavaField.builder().type("String").name("test").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Fields", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddFields() {
        JavaField field1 = EditableJavaField.builder().type("String").name("test").build();
        JavaField field2 = EditableJavaField.builder().type("int").name("derp").build();
        JavaField field3 = EditableJavaField.builder().type("String").name("blah").build();
        JavaField field4 = EditableJavaField.builder().type("double").name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getFields());
        ((EditableJavaClass)this.clazz).addFields(ListUtil.createList((Object[])new JavaField[]{field1, field2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaField[]{field1, field2}), (Object)((EditableJavaClass)this.clazz).getFields());
        ((EditableJavaClass)this.clazz).addFields(ListUtil.createList((Object[])new JavaField[]{field3, field4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaField[]{field1, field2, field3, field4}), (Object)((EditableJavaClass)this.clazz).getFields());
    }

    @Test
    public void testAddFieldsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addFields(ListUtil.createList((Object[])new JavaField[]{UneditableJavaField.builder().type("String").name("test").build(), UneditableJavaField.builder().type("int").name("derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Fields", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetFields() {
        JavaField field1 = EditableJavaField.builder().type("String").name("test").build();
        JavaField field2 = EditableJavaField.builder().type("int").name("derp").build();
        JavaField field3 = EditableJavaField.builder().type("String").name("blah").build();
        JavaField field4 = EditableJavaField.builder().type("double").name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getFields());
        ((EditableJavaClass)this.clazz).setFields(ListUtil.createList((Object[])new JavaField[]{field1, field2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaField[]{field1, field2}), (Object)((EditableJavaClass)this.clazz).getFields());
        ((EditableJavaClass)this.clazz).setFields(ListUtil.createList((Object[])new JavaField[]{field3, field4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaField[]{field3, field4}), (Object)((EditableJavaClass)this.clazz).getFields());
    }

    @Test
    public void testSetFieldsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setFields(ListUtil.createList((Object[])new JavaField[]{UneditableJavaField.builder().type("String").name("test").build(), UneditableJavaField.builder().type("int").name("derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Fields", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddMethod() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("test").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("int").name("derp").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getMethods());
        ((EditableJavaClass)this.clazz).addMethod(method1);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMethod[]{method1}), (Object)((EditableJavaClass)this.clazz).getMethods());
        ((EditableJavaClass)this.clazz).addMethod(method2);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMethod[]{method1, method2}), (Object)((EditableJavaClass)this.clazz).getMethods());
    }

    @Test
    public void testAddMethodUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addMethod(UneditableJavaMethod.builder().returnType("String").name("test").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Methods", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddMethods() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("test").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("int").name("derp").build();
        JavaMethod method3 = EditableJavaMethod.builder().returnType("String").name("blah").build();
        JavaMethod method4 = EditableJavaMethod.builder().returnType("double").name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getMethods());
        ((EditableJavaClass)this.clazz).addMethods(ListUtil.createList((Object[])new JavaMethod[]{method1, method2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMethod[]{method1, method2}), (Object)((EditableJavaClass)this.clazz).getMethods());
        ((EditableJavaClass)this.clazz).addMethods(ListUtil.createList((Object[])new JavaMethod[]{method3, method4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMethod[]{method1, method2, method3, method4}), (Object)((EditableJavaClass)this.clazz).getMethods());
    }

    @Test
    public void testAddMethodsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addMethods(ListUtil.createList((Object[])new JavaMethod[]{UneditableJavaMethod.builder().returnType("String").name("test").build(), UneditableJavaMethod.builder().returnType("int").name("derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Methods", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetMethods() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("test").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("int").name("derp").build();
        JavaMethod method3 = EditableJavaMethod.builder().returnType("String").name("blah").build();
        JavaMethod method4 = EditableJavaMethod.builder().returnType("double").name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getMethods());
        ((EditableJavaClass)this.clazz).setMethods(ListUtil.createList((Object[])new JavaMethod[]{method1, method2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMethod[]{method1, method2}), (Object)((EditableJavaClass)this.clazz).getMethods());
        ((EditableJavaClass)this.clazz).setMethods(ListUtil.createList((Object[])new JavaMethod[]{method3, method4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMethod[]{method3, method4}), (Object)((EditableJavaClass)this.clazz).getMethods());
    }

    @Test
    public void testSetMethodsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setMethods(ListUtil.createList((Object[])new JavaMethod[]{UneditableJavaMethod.builder().returnType("String").name("test").build(), UneditableJavaMethod.builder().returnType("int").name("derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Methods", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetInnerElementsOrder() {
        List list1 = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.METHOD, (Object)"getVersion()")});
        List list2 = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.FIELD, (Object)"version")});
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getInnerElementsOrder());
        ((EditableJavaClass)this.clazz).setInnerElementsOrder(list1);
        Assertions.assertEquals((Object)list1, (Object)((EditableJavaClass)this.clazz).getInnerElementsOrder());
        ((EditableJavaClass)this.clazz).setInnerElementsOrder(list2);
        Assertions.assertEquals((Object)list2, (Object)((EditableJavaClass)this.clazz).getInnerElementsOrder());
    }

    @Test
    public void testToStringSkipsInvalidInnerElementType() {
        this.clazz = EditableJavaClass.builder().className(this.className).build();
        ((EditableJavaClass)this.clazz).setInnerElementsOrder(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)JavaCodeTypes.ANNOTATION, null)}));
        Assertions.assertEquals((Object)"class AClassName{\n}\n", (Object)((EditableJavaClass)this.clazz).toString());
    }
}

