/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.javaclass;

import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.comment.UneditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.UneditableJavaSingleLineComment;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.field.UneditableJavaField;
import com.github.tadukoo.java.importstatement.EditableJavaImportStatement;
import com.github.tadukoo.java.importstatement.UneditableJavaImportStatement;
import com.github.tadukoo.java.javaclass.DefaultJavaClassTest;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javaclass.UneditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.UneditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.method.UneditableJavaMethod;
import com.github.tadukoo.java.packagedeclaration.EditableJavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.UneditableJavaPackageDeclaration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UneditableJavaClassTest
extends DefaultJavaClassTest<UneditableJavaClass> {
    public UneditableJavaClassTest() {
        super(UneditableJavaClass.class, UneditableJavaClass::builder, UneditableJavaPackageDeclaration::builder, UneditableJavaImportStatement::builder, UneditableJavaAnnotation::builder, UneditableJavadoc::builder, UneditableJavaSingleLineComment::builder, UneditableJavaMultiLineComment::builder, UneditableJavaField::builder, UneditableJavaMethod::builder);
    }

    @Test
    public void testIsEditable() {
        Assertions.assertFalse((boolean)((UneditableJavaClass)this.clazz).isEditable());
    }

    @Test
    public void testBuilderEditablePackageDeclarationError() {
        try {
            UneditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("some.package").build()).className(this.className).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"package declaration is not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderEditableImportStatementError() {
        try {
            UneditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().importName("com.example").build()).className(this.className).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some import statements are not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderEditableJavadocError() {
        try {
            UneditableJavaClass.builder().className(this.className).javadoc(EditableJavadoc.builder().build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderEditableAnnotationError() {
        try {
            UneditableJavaClass.builder().className(this.className).annotation(EditableJavaAnnotation.builder().name("Test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some annotations are not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderEditableSingleLineCommentError() {
        try {
            UneditableJavaClass.builder().className(this.className).singleLineComment(EditableJavaSingleLineComment.builder().content("some comment").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some single-line comments are not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderEditableMultiLineCommentError() {
        try {
            UneditableJavaClass.builder().className(this.className).multiLineComment(EditableJavaMultiLineComment.builder().content("some comment").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some multi-line comments are not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderEditableInnerClassError() {
        try {
            UneditableJavaClass.builder().className(this.className).innerClass(EditableJavaClass.builder().innerClass().className(this.className).build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some inner classes are not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderEditableFieldError() {
        try {
            UneditableJavaClass.builder().className(this.className).field(EditableJavaField.builder().type("String").name("test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some fields are not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderEditableMethodError() {
        try {
            UneditableJavaClass.builder().className(this.className).method(EditableJavaMethod.builder().returnType("String").name("test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some methods are not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testAllBuilderSpecificErrors() {
        try {
            UneditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("some.package").build()).importStatement(EditableJavaImportStatement.builder().importName("com.example").build()).className(this.className).javadoc(EditableJavadoc.builder().build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).singleLineComment(EditableJavaSingleLineComment.builder().content("some comment").build()).multiLineComment(EditableJavaMultiLineComment.builder().content("some comment").build()).innerClass(EditableJavaClass.builder().innerClass().className(this.className).build()).field(EditableJavaField.builder().type("String").name("test").build()).method(EditableJavaMethod.builder().returnType("String").name("test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"package declaration is not uneditable in this uneditable JavaClass\nsome import statements are not uneditable in this uneditable JavaClass\njavadoc is not uneditable in this uneditable JavaClass\nsome annotations are not uneditable in this uneditable JavaClass\nsome single-line comments are not uneditable in this uneditable JavaClass\nsome multi-line comments are not uneditable in this uneditable JavaClass\nsome inner classes are not uneditable in this uneditable JavaClass\nsome fields are not uneditable in this uneditable JavaClass\nsome methods are not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }
}

