/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.method;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotationBuilder;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.javadoc.JavadocBuilder;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.method.JavaMethodBuilder;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.NoException;
import com.github.tadukoo.util.functional.supplier.ThrowingSupplier;
import com.github.tadukoo.util.tuple.Pair;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DefaultJavaMethodTest<MethodType extends JavaMethod> {
    private final Class<MethodType> clazz;
    private final ThrowingSupplier<JavaMethodBuilder<MethodType>, NoException> builder;
    private final ThrowingSupplier<JavadocBuilder<?>, NoException> javadocBuilder;
    private final ThrowingSupplier<JavaAnnotationBuilder<?>, NoException> javaAnnotationBuilder;
    protected MethodType method;
    protected String returnType;

    protected DefaultJavaMethodTest(Class<MethodType> clazz, ThrowingSupplier<JavaMethodBuilder<MethodType>, NoException> builder, ThrowingSupplier<JavadocBuilder<?>, NoException> javadocBuilder, ThrowingSupplier<JavaAnnotationBuilder<?>, NoException> javaAnnotationBuilder) {
        this.clazz = clazz;
        this.builder = builder;
        this.javadocBuilder = javadocBuilder;
        this.javaAnnotationBuilder = javaAnnotationBuilder;
    }

    @BeforeEach
    public void setup() {
        this.returnType = "int";
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).build();
    }

    @Test
    public void testGetJavaType() {
        Assertions.assertEquals((Object)JavaCodeTypes.METHOD, (Object)this.method.getJavaCodeType());
    }

    @Test
    public void testDefaultJavadoc() {
        Assertions.assertNull((Object)this.method.getJavadoc());
    }

    @Test
    public void testDefaultAnnotations() {
        Assertions.assertTrue((boolean)this.method.getAnnotations().isEmpty());
    }

    @Test
    public void testDefaultVisibility() {
        Assertions.assertEquals((Object)Visibility.NONE, (Object)this.method.getVisibility());
    }

    @Test
    public void testDefaultIsAbstract() {
        Assertions.assertFalse((boolean)this.method.isAbstract());
    }

    @Test
    public void testDefaultIsStatic() {
        Assertions.assertFalse((boolean)this.method.isStatic());
    }

    @Test
    public void testDefaultIsFinal() {
        Assertions.assertFalse((boolean)this.method.isFinal());
    }

    @Test
    public void testDefaultName() {
        Assertions.assertNull((Object)this.method.getName());
    }

    @Test
    public void testDefaultParameters() {
        Assertions.assertTrue((boolean)this.method.getParameters().isEmpty());
    }

    @Test
    public void testDefaultThrowTypes() {
        Assertions.assertTrue((boolean)this.method.getThrowTypes().isEmpty());
    }

    @Test
    public void testDefaultLines() {
        Assertions.assertTrue((boolean)this.method.getLines().isEmpty());
    }

    @Test
    public void testBuilderCopy() {
        JavaMethod otherMethod = ((JavaMethodBuilder)this.builder.get()).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().returnType(this.returnType).name("test").parameter("String", "type").parameter("int", "derp").throwType("Throwable").throwType("Exception").line("doSomething();").line("doSomethingElse();").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).copy(otherMethod).build();
        Assertions.assertEquals((Object)otherMethod, this.method);
    }

    @Test
    public void testBuilderSetJavadoc() {
        Javadoc javadoc = ((JavadocBuilder)this.javadocBuilder.get()).build();
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).javadoc(javadoc).build();
        Assertions.assertEquals((Object)javadoc, (Object)this.method.getJavadoc());
    }

    @Test
    public void testBuilderSetAnnotations() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        List annotations = ListUtil.createList((Object[])new JavaAnnotation[]{test, derp});
        this.method = ((JavaMethodBuilder)this.builder.get()).annotations(annotations).returnType("String").build();
        Assertions.assertEquals((Object)annotations, (Object)this.method.getAnnotations());
    }

    @Test
    public void testBuilderSetAnnotation() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).annotation(test).returnType("String").build();
        List annotations = this.method.getAnnotations();
        Assertions.assertEquals((int)1, (int)annotations.size());
        Assertions.assertEquals((Object)test, annotations.get(0));
    }

    @Test
    public void testBuilderSetVisibility() {
        this.method = ((JavaMethodBuilder)this.builder.get()).visibility(Visibility.PRIVATE).returnType("String").build();
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)this.method.getVisibility());
    }

    @Test
    public void testBuilderIsAbstract() {
        this.method = ((JavaMethodBuilder)this.builder.get()).isAbstract().returnType("String").build();
        Assertions.assertTrue((boolean)this.method.isAbstract());
    }

    @Test
    public void testBuilderSetIsAbstract() {
        this.method = ((JavaMethodBuilder)this.builder.get()).isAbstract(false).returnType("String").build();
        Assertions.assertFalse((boolean)this.method.isAbstract());
        this.method = ((JavaMethodBuilder)this.builder.get()).isAbstract(true).returnType("String").build();
        Assertions.assertTrue((boolean)this.method.isAbstract());
    }

    @Test
    public void testBuilderIsStatic() {
        this.method = ((JavaMethodBuilder)this.builder.get()).isStatic().returnType("String").build();
        Assertions.assertTrue((boolean)this.method.isStatic());
    }

    @Test
    public void testBuilderSetIsStatic() {
        this.method = ((JavaMethodBuilder)this.builder.get()).isStatic(false).returnType("String").build();
        Assertions.assertFalse((boolean)this.method.isStatic());
        this.method = ((JavaMethodBuilder)this.builder.get()).isStatic(true).returnType("String").build();
        Assertions.assertTrue((boolean)this.method.isStatic());
    }

    @Test
    public void testBuilderIsFinal() {
        this.method = ((JavaMethodBuilder)this.builder.get()).isFinal().returnType("String").build();
        Assertions.assertTrue((boolean)this.method.isFinal());
    }

    @Test
    public void testBuilderSetIsFinal() {
        this.method = ((JavaMethodBuilder)this.builder.get()).isFinal(false).returnType("String").build();
        Assertions.assertFalse((boolean)this.method.isFinal());
        this.method = ((JavaMethodBuilder)this.builder.get()).isFinal(true).returnType("String").build();
        Assertions.assertTrue((boolean)this.method.isFinal());
    }

    @Test
    public void testBuilderSetReturnType() {
        Assertions.assertEquals((Object)"int", (Object)this.method.getReturnType());
    }

    @Test
    public void testBuilderSetName() {
        this.method = ((JavaMethodBuilder)this.builder.get()).name("someName").returnType(this.returnType).build();
        Assertions.assertEquals((Object)"someName", (Object)this.method.getName());
    }

    @Test
    public void testBuilderSetParameters() {
        List parameters = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"int", (Object)"someInt"), Pair.of((Object)"String", (Object)"someText")});
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameters(parameters).build();
        Assertions.assertEquals((Object)parameters, (Object)this.method.getParameters());
    }

    @Test
    public void testBuilderSetParameterPair() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter(Pair.of((Object)"String", (Object)"someText")).build();
        List parameters = this.method.getParameters();
        Assertions.assertEquals((int)1, (int)parameters.size());
        Pair parameter = (Pair)parameters.get(0);
        Assertions.assertEquals((Object)"String", (Object)parameter.getLeft());
        Assertions.assertEquals((Object)"someText", (Object)parameter.getRight());
    }

    @Test
    public void testBuilderSetParameter() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("String", "someText").build();
        List parameters = this.method.getParameters();
        Assertions.assertEquals((int)1, (int)parameters.size());
        Pair parameter = (Pair)parameters.get(0);
        Assertions.assertEquals((Object)"String", (Object)parameter.getLeft());
        Assertions.assertEquals((Object)"someText", (Object)parameter.getRight());
    }

    @Test
    public void testBuilderSetThrowTypes() {
        List throwTypes = ListUtil.createList((Object[])new String[]{"Throwable", "Exception"});
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).throwTypes(throwTypes).build();
        Assertions.assertEquals((Object)throwTypes, (Object)this.method.getThrowTypes());
    }

    @Test
    public void testBuilderSetThrowType() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).throwType("Throwable").build();
        List throwTypes = this.method.getThrowTypes();
        Assertions.assertEquals((int)1, (int)throwTypes.size());
        Assertions.assertEquals((Object)"Throwable", throwTypes.get(0));
    }

    @Test
    public void testBuilderSetLines() {
        List lines = ListUtil.createList((Object[])new String[]{"doSomething();", "return 42;"});
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).lines(lines).build();
        Assertions.assertEquals((Object)lines, (Object)this.method.getLines());
    }

    @Test
    public void testBuilderSetLine() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).line("return 42;").build();
        List lines = this.method.getLines();
        Assertions.assertEquals((int)1, (int)lines.size());
        Assertions.assertEquals((Object)"return 42;", lines.get(0));
    }

    @Test
    public void testBuilderNullVisibility() {
        try {
            this.method = ((JavaMethodBuilder)this.builder.get()).visibility(null).returnType(this.returnType).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Visibility is required!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderNullReturnType() {
        try {
            this.method = ((JavaMethodBuilder)this.builder.get()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify returnType!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAllErrors() {
        try {
            this.method = ((JavaMethodBuilder)this.builder.get()).visibility(null).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Visibility is required!\nMust specify returnType!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAbstractAndPrivate() {
        try {
            this.method = ((JavaMethodBuilder)this.builder.get()).visibility(Visibility.PRIVATE).isAbstract().returnType("String").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Can't be abstract and private!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAbstractAndStatic() {
        try {
            this.method = ((JavaMethodBuilder)this.builder.get()).isAbstract().isStatic().returnType("String").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Can't be abstract and static!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAbstractAndFinal() {
        try {
            this.method = ((JavaMethodBuilder)this.builder.get()).isAbstract().isFinal().returnType("String").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Can't be abstract and final!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAbstractAndLines() {
        try {
            this.method = ((JavaMethodBuilder)this.builder.get()).isAbstract().returnType("String").line("return this").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Can't be abstract and have lines!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAllAbstractErrors() {
        try {
            this.method = ((JavaMethodBuilder)this.builder.get()).visibility(Visibility.PRIVATE).isAbstract().isStatic().isFinal().returnType("String").line("return this").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Can't be abstract and private!\nCan't be abstract and static!\nCan't be abstract and final!\nCan't be abstract and have lines!", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetUniqueNameConstructor() {
        Assertions.assertEquals((Object)"init()", (Object)this.method.getUniqueName());
    }

    @Test
    public void testGetUniqueNameConstructorWithParameter() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("String", "name").build();
        Assertions.assertEquals((Object)"init(String name)", (Object)this.method.getUniqueName());
    }

    @Test
    public void testGetUniqueNameConstructorWithMultipleParameters() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("String", "name").parameter("int", "version").build();
        Assertions.assertEquals((Object)"init(String name, int version)", (Object)this.method.getUniqueName());
    }

    @Test
    public void testGetUniqueName() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).name("test").build();
        Assertions.assertEquals((Object)"test()", (Object)this.method.getUniqueName());
    }

    @Test
    public void testGetUniqueNameWithParameter() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).name("test").parameter("String", "name").build();
        Assertions.assertEquals((Object)"test(String name)", (Object)this.method.getUniqueName());
    }

    @Test
    public void testGetUniqueNameWithMultipleParameters() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).name("test").parameter("String", "name").parameter("int", "version").build();
        Assertions.assertEquals((Object)"test(String name, int version)", (Object)this.method.getUniqueName());
    }

    @Test
    public void testToString() {
        String javaString = "int(){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithJavadoc() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).build();
        String javaString = "/**\n */\nint(){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithSingleAnnotation() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).annotation(test).build();
        String javaString = "@Test\nint(){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithAnnotations() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).annotation(test).annotation(derp).build();
        String javaString = "@Test\n@Derp\nint(){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithVisibility() {
        this.method = ((JavaMethodBuilder)this.builder.get()).visibility(Visibility.PRIVATE).returnType(this.returnType).build();
        String javaString = "private int(){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithIsAbstract() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).isAbstract().build();
        String javaString = "abstract int();";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithIsStatic() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).isStatic().build();
        String javaString = "static int(){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithIsFinal() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).isFinal().build();
        String javaString = "final int(){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithName() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).name("someMethod").build();
        String javaString = "int someMethod(){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithSingleParameter() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("String", "text").build();
        String javaString = "int(String text){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithParameters() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("String", "text").parameter("int", "something").build();
        String javaString = "int(String text, int something){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithLongParameters() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("String", "text").parameter("Testy", "testy").parameter("Test", "test1").parameter("Test", "test2").parameter("Test", "test3").parameter("Test", "test4").parameter("Test", "test5").parameter("Test", "test6").parameter("Test", "test7").build();
        String javaString = "int(\n\t\tString text, Testy testy, Test test1, Test test2, Test test3, Test test4, Test test5, Test test6, Test test7){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithLongParameters2Lines() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("String", "text").parameter("Testy", "testy").parameter("Test", "test1").parameter("Test", "test2").parameter("Test", "test3").parameter("Test", "test4").parameter("Test", "test5").parameter("Test", "test6").parameter("Test", "test7").parameter("Test", "test8").build();
        String javaString = "int(\n\t\tString text, Testy testy, Test test1, Test test2, Test test3, Test test4, Test test5, Test test6, Test test7, \n\t\tTest test8){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithLongSingleParameter() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("String", "aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah").build();
        String javaString = "int(\n\t\tString aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWith2LongSingleParameters() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("String", "aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah").parameter("String", "aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah2").build();
        String javaString = "int(\n\t\tString aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah, \n\t\tString aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah2){ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithSingleThrowType() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).throwType("Throwable").build();
        String javaString = "int() throws Throwable{ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithThrowTypes() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).throwType("Throwable").throwType("Exception").build();
        String javaString = "int() throws Throwable, Exception{ }";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithLines() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).line("doSomething();").line("return 42;").build();
        String javaString = "int(){\n\tdoSomething();\n\treturn 42;\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithEverything() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(test).annotation(derp).name("someMethod").visibility(Visibility.PUBLIC).isStatic().isFinal().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build();
        String javaString = "/**\n */\n@Test\n@Derp\npublic static final int someMethod(String text, int something) throws Throwable, Exception{\n\tdoSomething();\n\treturn 42;\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testEquals() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(test).annotation(derp).name("someMethod").isStatic().isFinal().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build();
        JavaMethod otherMethod = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(test).annotation(derp).name("someMethod").isStatic().isFinal().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build();
        Assertions.assertEquals(this.method, (Object)otherMethod);
    }

    @Test
    public void testEqualsNotEqual() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(test).annotation(derp).name("someMethod").isStatic().isFinal().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build();
        JavaMethod otherMethod = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(test).annotation(derp).name("someMethod").isStatic().isFinal().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 41;").build();
        Assertions.assertNotEquals(this.method, (Object)otherMethod);
    }

    @Test
    public void testEqualsDifferentTypes() {
        Assertions.assertNotEquals(this.method, (Object)"testing");
    }

    @Test
    public void testToBuilderCode() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithJavadoc() {
        Javadoc javadoc = ((JavadocBuilder)this.javadocBuilder.get()).build();
        this.method = ((JavaMethodBuilder)this.builder.get()).javadoc(javadoc).returnType(this.returnType).build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.javadoc(" + javadoc.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithOneAnnotation() {
        JavaAnnotation annotation = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).annotation(annotation).returnType(this.returnType).build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.annotation(" + annotation.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithTwoAnnotations() {
        JavaAnnotation annotation = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation annotation2 = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).annotation(annotation).annotation(annotation2).returnType(this.returnType).build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.annotation(" + annotation.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.annotation(" + annotation2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithVisibility() {
        this.method = ((JavaMethodBuilder)this.builder.get()).visibility(Visibility.PUBLIC).returnType(this.returnType).build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.visibility(Visibility.PUBLIC)\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithAbstract() {
        this.method = ((JavaMethodBuilder)this.builder.get()).isAbstract().returnType(this.returnType).build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.isAbstract()\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithStatic() {
        this.method = ((JavaMethodBuilder)this.builder.get()).isStatic().returnType(this.returnType).build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.isStatic()\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithFinal() {
        this.method = ((JavaMethodBuilder)this.builder.get()).isFinal().returnType(this.returnType).build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.isFinal()\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithName() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).name("something").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.name(\"something\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithOneParameter() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("int", "something").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.parameter(\"int\", \"something\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithTwoParameters() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("int", "something").parameter("String", "version").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.parameter(\"int\", \"something\")\n\t\t.parameter(\"String\", \"version\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithOneThrowType() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).throwType("Exception").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.throwType(\"Exception\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithTwoThrowTypes() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).throwType("Exception").throwType("Throwable").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.throwType(\"Exception\")\n\t\t.throwType(\"Throwable\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithOneLine() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).line("this.thing = thing;").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.line(\"this.thing = thing;\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithTwoLines() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).line("this.thing = thing;").line("return this;").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.line(\"this.thing = thing;\")\n\t\t.line(\"return this;\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }

    @Test
    public void testToBuilderCodeWithEverything() {
        Javadoc javadoc = ((JavadocBuilder)this.javadocBuilder.get()).build();
        JavaAnnotation annotation = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation annotation2 = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).javadoc(javadoc).annotation(annotation).annotation(annotation2).visibility(Visibility.PUBLIC).isStatic().isFinal().returnType(this.returnType).name("something").parameter("int", "something").parameter("String", "version").throwType("Exception").throwType("Throwable").line("this.thing = thing;").line("return this;").build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.javadoc(" + javadoc.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.annotation(" + annotation.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.annotation(" + annotation2.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t") + ")\n\t\t.visibility(Visibility.PUBLIC)\n\t\t.isStatic()\n\t\t.isFinal()\n\t\t.returnType(\"" + this.returnType + "\")\n\t\t.name(\"something\")\n\t\t.parameter(\"int\", \"something\")\n\t\t.parameter(\"String\", \"version\")\n\t\t.throwType(\"Exception\")\n\t\t.throwType(\"Throwable\")\n\t\t.line(\"this.thing = thing;\")\n\t\t.line(\"return this;\")\n\t\t.build()"), (Object)this.method.toBuilderCode());
    }
}

