/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.method;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.UneditableJavadoc;
import com.github.tadukoo.java.method.DefaultJavaMethodTest;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EditableJavaMethodTest
extends DefaultJavaMethodTest<EditableJavaMethod> {
    public EditableJavaMethodTest() {
        super(EditableJavaMethod.class, EditableJavaMethod::builder, EditableJavadoc::builder, EditableJavaAnnotation::builder);
    }

    @Test
    public void testIsEditable() {
        Assertions.assertTrue((boolean)((EditableJavaMethod)this.method).isEditable());
    }

    @Test
    public void testBuilderJavadocUneditable() {
        try {
            EditableJavaMethod.builder().returnType(this.returnType).javadoc(UneditableJavadoc.builder().build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not editable in this editable JavaMethod", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderJavaAnnotationEditable() {
        try {
            EditableJavaMethod.builder().returnType(this.returnType).annotation(UneditableJavaAnnotation.builder().name("Test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some annotations are not editable in this editable JavaMethod", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAllSpecificErrors() {
        try {
            EditableJavaMethod.builder().returnType(this.returnType).javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not editable in this editable JavaMethod\nsome annotations are not editable in this editable JavaMethod", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetJavadoc() {
        Assertions.assertNull((Object)((EditableJavaMethod)this.method).getJavadoc());
        ((EditableJavaMethod)this.method).setJavadoc(EditableJavadoc.builder().build());
        Assertions.assertEquals((Object)EditableJavadoc.builder().build(), (Object)((EditableJavaMethod)this.method).getJavadoc());
        ((EditableJavaMethod)this.method).setJavadoc(EditableJavadoc.builder().author("Me").build());
        Assertions.assertEquals((Object)EditableJavadoc.builder().author("Me").build(), (Object)((EditableJavaMethod)this.method).getJavadoc());
    }

    @Test
    public void testSetJavadocUneditable() {
        try {
            ((EditableJavaMethod)this.method).setJavadoc(UneditableJavadoc.builder().build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Method requires editable Javadoc", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAnnotation() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaMethod)this.method).getAnnotations());
        ((EditableJavaMethod)this.method).addAnnotation(EditableJavaAnnotation.builder().name("Test").build());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new EditableJavaAnnotation[]{(EditableJavaAnnotation)EditableJavaAnnotation.builder().name("Test").build()}), (Object)((EditableJavaMethod)this.method).getAnnotations());
        ((EditableJavaMethod)this.method).addAnnotation(EditableJavaAnnotation.builder().name("Derp").build());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new EditableJavaAnnotation[]{(EditableJavaAnnotation)EditableJavaAnnotation.builder().name("Test").build(), (EditableJavaAnnotation)EditableJavaAnnotation.builder().name("Derp").build()}), (Object)((EditableJavaMethod)this.method).getAnnotations());
    }

    @Test
    public void testAddAnnotationUneditable() {
        try {
            ((EditableJavaMethod)this.method).addAnnotation(UneditableJavaAnnotation.builder().name("Test").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Method requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAnnotations() {
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        JavaAnnotation blah = EditableJavaAnnotation.builder().name("Blah").build();
        JavaAnnotation yep = EditableJavaAnnotation.builder().name("Yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaMethod)this.method).getAnnotations());
        ((EditableJavaMethod)this.method).addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)((EditableJavaMethod)this.method).getAnnotations());
        ((EditableJavaMethod)this.method).addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp, blah, yep}), (Object)((EditableJavaMethod)this.method).getAnnotations());
    }

    @Test
    public void testAddAnnotationsUneditable() {
        try {
            JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
            JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
            ((EditableJavaMethod)this.method).addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Method requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetAnnotations() {
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        JavaAnnotation blah = EditableJavaAnnotation.builder().name("Blah").build();
        JavaAnnotation yep = EditableJavaAnnotation.builder().name("Yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaMethod)this.method).getAnnotations());
        ((EditableJavaMethod)this.method).setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)((EditableJavaMethod)this.method).getAnnotations());
        ((EditableJavaMethod)this.method).setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}), (Object)((EditableJavaMethod)this.method).getAnnotations());
    }

    @Test
    public void testSetAnnotationsUneditable() {
        try {
            JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
            JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
            ((EditableJavaMethod)this.method).setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Method requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetVisibility() {
        Assertions.assertEquals((Object)Visibility.NONE, (Object)((EditableJavaMethod)this.method).getVisibility());
        ((EditableJavaMethod)this.method).setVisibility(Visibility.PRIVATE);
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)((EditableJavaMethod)this.method).getVisibility());
    }

    @Test
    public void testSetAbstract() {
        Assertions.assertFalse((boolean)((EditableJavaMethod)this.method).isAbstract());
        ((EditableJavaMethod)this.method).setAbstract(true);
        Assertions.assertTrue((boolean)((EditableJavaMethod)this.method).isAbstract());
        ((EditableJavaMethod)this.method).setAbstract(true);
        Assertions.assertTrue((boolean)((EditableJavaMethod)this.method).isAbstract());
    }

    @Test
    public void testSetStatic() {
        Assertions.assertFalse((boolean)((EditableJavaMethod)this.method).isStatic());
        ((EditableJavaMethod)this.method).setStatic(true);
        Assertions.assertTrue((boolean)((EditableJavaMethod)this.method).isStatic());
        ((EditableJavaMethod)this.method).setStatic(true);
        Assertions.assertTrue((boolean)((EditableJavaMethod)this.method).isStatic());
    }

    @Test
    public void testSetFinal() {
        Assertions.assertFalse((boolean)((EditableJavaMethod)this.method).isFinal());
        ((EditableJavaMethod)this.method).setFinal(true);
        Assertions.assertTrue((boolean)((EditableJavaMethod)this.method).isFinal());
        ((EditableJavaMethod)this.method).setFinal(true);
        Assertions.assertTrue((boolean)((EditableJavaMethod)this.method).isFinal());
    }

    @Test
    public void testSetReturnType() {
        Assertions.assertEquals((Object)this.returnType, (Object)((EditableJavaMethod)this.method).getReturnType());
        ((EditableJavaMethod)this.method).setReturnType("String");
        Assertions.assertEquals((Object)"String", (Object)((EditableJavaMethod)this.method).getReturnType());
        ((EditableJavaMethod)this.method).setReturnType("Derp");
        Assertions.assertEquals((Object)"Derp", (Object)((EditableJavaMethod)this.method).getReturnType());
    }

    @Test
    public void testSetName() {
        Assertions.assertNull((Object)((EditableJavaMethod)this.method).getName());
        ((EditableJavaMethod)this.method).setName("something");
        Assertions.assertEquals((Object)"something", (Object)((EditableJavaMethod)this.method).getName());
        ((EditableJavaMethod)this.method).setName("somethingElse");
        Assertions.assertEquals((Object)"somethingElse", (Object)((EditableJavaMethod)this.method).getName());
    }

    @Test
    public void testAddParameterPieces() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaMethod)this.method).getParameters());
        ((EditableJavaMethod)this.method).addParameter("String", "test");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"String", (Object)"test")}), (Object)((EditableJavaMethod)this.method).getParameters());
        ((EditableJavaMethod)this.method).addParameter("int", "something");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"String", (Object)"test"), Pair.of((Object)"int", (Object)"something")}), (Object)((EditableJavaMethod)this.method).getParameters());
    }

    @Test
    public void testAddParameter() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaMethod)this.method).getParameters());
        ((EditableJavaMethod)this.method).addParameter(Pair.of((Object)"String", (Object)"test"));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"String", (Object)"test")}), (Object)((EditableJavaMethod)this.method).getParameters());
        ((EditableJavaMethod)this.method).addParameter(Pair.of((Object)"int", (Object)"something"));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"String", (Object)"test"), Pair.of((Object)"int", (Object)"something")}), (Object)((EditableJavaMethod)this.method).getParameters());
    }

    @Test
    public void testAddParameters() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaMethod)this.method).getParameters());
        ((EditableJavaMethod)this.method).addParameters(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"String", (Object)"test"), Pair.of((Object)"int", (Object)"something")}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"String", (Object)"test"), Pair.of((Object)"int", (Object)"something")}), (Object)((EditableJavaMethod)this.method).getParameters());
        ((EditableJavaMethod)this.method).addParameters(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"String", (Object)"derp"), Pair.of((Object)"double", (Object)"blah")}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"String", (Object)"test"), Pair.of((Object)"int", (Object)"something"), Pair.of((Object)"String", (Object)"derp"), Pair.of((Object)"double", (Object)"blah")}), (Object)((EditableJavaMethod)this.method).getParameters());
    }

    @Test
    public void testSetParameters() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaMethod)this.method).getParameters());
        ((EditableJavaMethod)this.method).setParameters(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"String", (Object)"test"), Pair.of((Object)"int", (Object)"something")}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"String", (Object)"test"), Pair.of((Object)"int", (Object)"something")}), (Object)((EditableJavaMethod)this.method).getParameters());
        ((EditableJavaMethod)this.method).setParameters(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"String", (Object)"derp"), Pair.of((Object)"double", (Object)"blah")}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"String", (Object)"derp"), Pair.of((Object)"double", (Object)"blah")}), (Object)((EditableJavaMethod)this.method).getParameters());
    }

    @Test
    public void testAddThrowType() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaMethod)this.method).getThrowTypes());
        ((EditableJavaMethod)this.method).addThrowType("NoException");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"NoException"}), (Object)((EditableJavaMethod)this.method).getThrowTypes());
        ((EditableJavaMethod)this.method).addThrowType("Throwable");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"NoException", "Throwable"}), (Object)((EditableJavaMethod)this.method).getThrowTypes());
    }

    @Test
    public void testAddThrowTypes() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaMethod)this.method).getThrowTypes());
        ((EditableJavaMethod)this.method).addThrowTypes(ListUtil.createList((Object[])new String[]{"NoException", "Throwable"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"NoException", "Throwable"}), (Object)((EditableJavaMethod)this.method).getThrowTypes());
        ((EditableJavaMethod)this.method).addThrowTypes(ListUtil.createList((Object[])new String[]{"String", "Exception"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"NoException", "Throwable", "String", "Exception"}), (Object)((EditableJavaMethod)this.method).getThrowTypes());
    }

    @Test
    public void testSetThrowTypes() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaMethod)this.method).getThrowTypes());
        ((EditableJavaMethod)this.method).setThrowTypes(ListUtil.createList((Object[])new String[]{"NoException", "Throwable"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"NoException", "Throwable"}), (Object)((EditableJavaMethod)this.method).getThrowTypes());
        ((EditableJavaMethod)this.method).setThrowTypes(ListUtil.createList((Object[])new String[]{"String", "Exception"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"String", "Exception"}), (Object)((EditableJavaMethod)this.method).getThrowTypes());
    }

    @Test
    public void testAddLine() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaMethod)this.method).getLines());
        ((EditableJavaMethod)this.method).addLine("String test = \"42\";");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"String test = \"42\";"}), (Object)((EditableJavaMethod)this.method).getLines());
        ((EditableJavaMethod)this.method).addLine("test.toString();");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"String test = \"42\";", "test.toString();"}), (Object)((EditableJavaMethod)this.method).getLines());
    }

    @Test
    public void testAddLines() {
        String line1 = "String test = \"42\";";
        String line2 = "test.toString();";
        String line3 = "String line1 = \"String test = \"42\";\";";
        String line4 = "// yep";
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaMethod)this.method).getLines());
        ((EditableJavaMethod)this.method).addLines(ListUtil.createList((Object[])new String[]{line1, line2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{line1, line2}), (Object)((EditableJavaMethod)this.method).getLines());
        ((EditableJavaMethod)this.method).addLines(ListUtil.createList((Object[])new String[]{line3, line4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{line1, line2, line3, line4}), (Object)((EditableJavaMethod)this.method).getLines());
    }

    @Test
    public void testSetLines() {
        String line1 = "String test = \"42\";";
        String line2 = "test.toString();";
        String line3 = "String line1 = \"String test = \"42\";\";";
        String line4 = "// yep";
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaMethod)this.method).getLines());
        ((EditableJavaMethod)this.method).setLines(ListUtil.createList((Object[])new String[]{line1, line2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{line1, line2}), (Object)((EditableJavaMethod)this.method).getLines());
        ((EditableJavaMethod)this.method).setLines(ListUtil.createList((Object[])new String[]{line3, line4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{line3, line4}), (Object)((EditableJavaMethod)this.method).getLines());
    }
}

