/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.packagedeclaration;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclarationBuilder;
import com.github.tadukoo.util.functional.NoException;
import com.github.tadukoo.util.functional.supplier.ThrowingSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DefaultJavaPackageDeclarationTest<PackageDeclarationType extends JavaPackageDeclaration> {
    private final Class<PackageDeclarationType> clazz;
    private final ThrowingSupplier<JavaPackageDeclarationBuilder<PackageDeclarationType>, NoException> builder;
    protected String packageName;
    protected PackageDeclarationType packageDeclaration;

    protected DefaultJavaPackageDeclarationTest(Class<PackageDeclarationType> clazz, ThrowingSupplier<JavaPackageDeclarationBuilder<PackageDeclarationType>, NoException> builder) {
        this.clazz = clazz;
        this.builder = builder;
    }

    @BeforeEach
    public void setup() {
        this.packageName = "com.example";
        this.packageDeclaration = ((JavaPackageDeclarationBuilder)this.builder.get()).packageName(this.packageName).build();
    }

    @Test
    public void testGetType() {
        Assertions.assertEquals((Object)JavaCodeTypes.PACKAGE_DECLARATION, (Object)this.packageDeclaration.getJavaCodeType());
    }

    @Test
    public void testBuilderCopy() {
        JavaPackageDeclaration otherPackageDeclaration = ((JavaPackageDeclarationBuilder)this.builder.get()).packageName(this.packageName).build();
        this.packageDeclaration = ((JavaPackageDeclarationBuilder)this.builder.get()).copy(otherPackageDeclaration).build();
        Assertions.assertEquals((Object)otherPackageDeclaration, this.packageDeclaration);
    }

    @Test
    public void testBuilderPackageName() {
        Assertions.assertEquals((Object)this.packageName, (Object)this.packageDeclaration.getPackageName());
    }

    @Test
    public void testBuilderErrorNoPackageName() {
        try {
            this.packageDeclaration = ((JavaPackageDeclarationBuilder)this.builder.get()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"packageName is required!", (Object)e.getMessage());
        }
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"package com.example;", (Object)this.packageDeclaration.toString());
    }

    @Test
    public void testEquals() {
        JavaPackageDeclaration otherPackageDeclaration = ((JavaPackageDeclarationBuilder)this.builder.get()).packageName(this.packageName).build();
        Assertions.assertEquals(this.packageDeclaration, (Object)otherPackageDeclaration);
    }

    @Test
    public void testEqualsNotEqual() {
        JavaPackageDeclaration otherPackageDeclaration = ((JavaPackageDeclarationBuilder)this.builder.get()).packageName("com.github.tadukoo").build();
        Assertions.assertNotEquals(this.packageDeclaration, (Object)otherPackageDeclaration);
    }

    @Test
    public void testEqualsDifferentType() {
        Assertions.assertNotEquals(this.packageDeclaration, (Object)"testing");
    }

    @Test
    public void testToBuilderCode() {
        this.packageDeclaration = ((JavaPackageDeclarationBuilder)this.builder.get()).packageName(this.packageName).build();
        Assertions.assertEquals((Object)(this.clazz.getSimpleName() + ".builder()\n\t\t.packageName(\"" + this.packageName + "\")\n\t\t.build()"), (Object)this.packageDeclaration.toBuilderCode());
    }
}

