/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.FullJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FullJavaParserCombinationErrorsTest
extends BaseJavaParserTest {
    @Test
    public void testTwoPackageDeclarations() {
        try {
            FullJavaParser.parseType((String)"package com.example;\npackage com.example.other;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered two package declarations!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testPackageDeclarationAfterClass() {
        try {
            FullJavaParser.parseType((String)"class Test{\n}\npackage com.example;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered package declaration after class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testImportStatementAfterClass() {
        try {
            FullJavaParser.parseType((String)"class Test{\n}\nimport com.example;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered import statement after class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testTwoJavadocs() {
        try {
            FullJavaParser.parseType((String)"/** {@inheritDoc} */\n/** something */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered two Javadocs!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testJavadocAfterField() {
        try {
            FullJavaParser.parseType((String)"String type;\n/** {@inheritDoc} */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered a Javadoc after field!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testJavadocAfterMethod() {
        try {
            FullJavaParser.parseType((String)"void test(){}\n/** {@inheritDoc} */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered a Javadoc after method!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testJavadocAfterClass() {
        try {
            FullJavaParser.parseType((String)"class Test{}\n/** {@inheritDoc} */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered a Javadoc after class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testAnnotationAfterClass() {
        try {
            FullJavaParser.parseType((String)"class Test{\n}\n@Test");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered annotation after class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testTwoFields() {
        try {
            FullJavaParser.parseType((String)"String type;\nint derp;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered two fields!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testClassBeforeField() {
        try {
            FullJavaParser.parseType((String)"class Test{\n}\nString type;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered field outside a class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testPackageDeclarationBeforeField() {
        try {
            FullJavaParser.parseType((String)"package some.package;\nString type;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered package declaration before field!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testImportStatementBeforeField() {
        try {
            FullJavaParser.parseType((String)"import some.classname;\nString type;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered import statements before field!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testTwoMethods() {
        try {
            FullJavaParser.parseType((String)"String something(){}\nint somethingElse(){}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered two methods!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testClassBeforeMethod() {
        try {
            FullJavaParser.parseType((String)"class Test{\n}\nString something(){}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered method outside a class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testPackageDeclarationBeforeMethod() {
        try {
            FullJavaParser.parseType((String)"package some.package;\nString something(){}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered package declaration before method!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testImportStatementBeforeMethod() {
        try {
            FullJavaParser.parseType((String)"import some.classname;\nString something(){}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered import statements before method!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testTwoOuterClasses() {
        try {
            FullJavaParser.parseType((String)"class Test{\n}\nclass Test2{\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered two outer level classes!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFieldBeforeClass() {
        try {
            FullJavaParser.parseType((String)"String type;\nclass Test{\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered fields outside a class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMethodBeforeClass() {
        try {
            FullJavaParser.parseType((String)"String something(){}\nclass Test{\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Encountered methods outside a class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFailedToDetermineFieldOrMethodAfterWhitespace() {
        try {
            FullJavaParser.parseType((String)"String something");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Failed to determine type from token 'String'"), (Object)e.getMessage());
        }
    }
}

