/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.classtypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.importstatement.EditableJavaImportStatement;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.packagedeclaration.EditableJavaPackageDeclaration;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseJavaClassParserTest
extends BaseJavaParserTest {
    private final ThrowingFunction<String, JavaClass, JavaParsingException> parseMethod;

    protected BaseJavaClassParserTest(ThrowingFunction<String, JavaClass, JavaParsingException> parseMethod) {
        this.parseMethod = parseMethod;
    }

    @Test
    public void testSimpleClass() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithPackageDeclaration() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"package com.example;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithImport() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"import com.example;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().importName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithMultipleImports() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"import com.example.Something;\nimport com.example.SomethingElse;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().importName("com.example.Something").build()).importStatement(EditableJavaImportStatement.builder().importName("com.example.SomethingElse").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithMultipleImportsAndLineBetween() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"import com.example.Something;\n\nimport org.example.SomethingElse;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().importName("com.example.Something").build()).importStatement(EditableJavaImportStatement.builder().importName("org.example.SomethingElse").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithStaticImport() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"import static com.example.SomethingStatic;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example.SomethingStatic").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithMultipleStaticImports() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"import static com.example.SomethingStatic;\nimport static com.example.SomethingElseStatic;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example.SomethingStatic").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example.SomethingElseStatic").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithMultipleStaticImportsAndLineBetween() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"import static com.example.SomethingStatic;\n\nimport static org.example.SomethingElseStatic;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example.SomethingStatic").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("org.example.SomethingElseStatic").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithJavadoc() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"/**\n * Something here\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n */\nclass Test{\n}");
        Assertions.assertEquals((Object)EditableJavaClass.builder().javadoc(EditableJavadoc.builder().content("Something here").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithSingleAnnotation() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"@Test\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithMultipleAnnotations() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"@Test\n@Derp(type=String.class)\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithVisibility() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"protected class Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().visibility(Visibility.PROTECTED).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithVisibilityPrivate() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"private class Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().visibility(Visibility.PRIVATE).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithVisibilityPublic() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"public class Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().visibility(Visibility.PUBLIC).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testAbstractClass() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"abstract class Test{\n}");
        Assertions.assertEquals((Object)EditableJavaClass.builder().isAbstract().className("Test").build(), (Object)clazz);
        Assertions.assertEquals((Object)"abstract class Test{\n\t\n}\n", (Object)clazz.toString());
    }

    @Test
    public void testStaticClass() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"static class Test{\n}\n");
        EditableJavaClass javaClass = (EditableJavaClass)EditableJavaClass.builder().className("Test").build();
        javaClass.setStatic(true);
        Assertions.assertEquals((Object)javaClass, (Object)clazz);
    }

    @Test
    public void testFinalClass() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"final class Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().isFinal().className("Test").build(), (Object)clazz);
    }

    @Test
    public void testClassWithModifiersReversed() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"final static private class Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().innerClass().visibility(Visibility.PRIVATE).isStatic().isFinal().className("Test").build(), (Object)clazz);
        Assertions.assertEquals((Object)"private static final class Test{\n\t\n}\n", (Object)clazz.toString());
    }

    @Test
    public void testClassWithSuperClass() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test extends Derp{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").superClassName("Derp").build(), (Object)clazz);
    }

    @Test
    public void testClassImplementsInterface() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test implements Derp{\n}");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp").build(), (Object)clazz);
    }

    @Test
    public void testClassImplementsMultipleInterfaces() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test implements Derp, Blah{\n}");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp").implementsInterfaceName("Blah").build(), (Object)clazz);
    }

    @Test
    public void testClassWithSingleLineComment() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test{\n\t// some comment\n}");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").singleLineComment(EditableJavaSingleLineComment.builder().content("some comment").build()).build(), (Object)clazz);
        Assertions.assertEquals((Object)"class Test{\n\t\n\t// some comment\n}\n", (Object)clazz.toString());
    }

    @Test
    public void testClassWithMultiLineComment() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test{\n\t/*\n\t * some comment\n\t */\n}");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").multiLineComment(EditableJavaMultiLineComment.builder().content("some comment").build()).build(), (Object)clazz);
        Assertions.assertEquals((Object)"class Test{\n\t\n\t/*\n\t * some comment\n\t */\n}\n", (Object)clazz.toString());
    }

    @Test
    public void testClassWithInnerClass() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test{\n\tclass Derp{\n\t}\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("Derp").build()).build(), (Object)clazz);
    }

    @Test
    public void testClassWithMultipleInnerClasses() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test{\n\tclass Derp{\n\t}\n\n\tclass Yep{\n\t}\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("Derp").build()).innerClass(EditableJavaClass.builder().innerClass().className("Yep").build()).build(), (Object)clazz);
    }

    @Test
    public void testClassWithField() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test{\n\tString name;\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("name").build()).build(), (Object)clazz);
    }

    @Test
    public void testClassWithMultipleFields() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test{\n\tString name;\n\tint derp;\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("name").build()).field(EditableJavaField.builder().type("int").name("derp").build()).build(), (Object)clazz);
    }

    @Test
    public void testClassWithMethod() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test{\n\tString type(){}\n}");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("type").build()).build(), (Object)clazz);
    }

    @Test
    public void testClassWithMultipleMethods() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test{\n\tString type(){}\n\tint getVersion(){}\n}");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("type").build()).method(EditableJavaMethod.builder().returnType("int").name("getVersion").build()).build(), (Object)clazz);
    }

    @Test
    public void testClassWithEverything() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"package com.example;\n\nimport com.example.Something;\n\nimport org.example.SomethingElse;\n\nimport static com.example.SomethingStatic;\n\nimport static org.example.SomethingElseStatic;\n\n/**\n * Something here\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n */\n@Example\n@Test(true)\n@Yep(type=String.class)\npublic static final class Test extends Derp implements Blah, Foo{\n\n\t// some comment\n\t/*\n\t * some comment\n\t */\n\tclass Derp{\n\t}\n\n\tclass Yep{\n\t}\n\n\tString name;\n\tint derp;\n\n\tString type(){}\n\tint getVersion(){}\n}\n");
        EditableJavaClass javaClass = (EditableJavaClass)EditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("com.example").build()).importStatement(EditableJavaImportStatement.builder().importName("com.example.Something").build()).importStatement(EditableJavaImportStatement.builder().importName("org.example.SomethingElse").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example.SomethingStatic").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("org.example.SomethingElseStatic").build()).javadoc(EditableJavadoc.builder().content("Something here").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").build()).annotation(EditableJavaAnnotation.builder().name("Example").build()).annotation(EditableJavaAnnotation.builder().name("Test").parameter("value", "true").build()).annotation(EditableJavaAnnotation.builder().name("Yep").parameter("type", "String.class").build()).visibility(Visibility.PUBLIC).isFinal().className("Test").superClassName("Derp").implementsInterfaceName("Blah").implementsInterfaceName("Foo").singleLineComment(EditableJavaSingleLineComment.builder().content("some comment").build()).multiLineComment(EditableJavaMultiLineComment.builder().content("some comment").build()).innerClass(EditableJavaClass.builder().innerClass().className("Derp").build()).innerClass(EditableJavaClass.builder().innerClass().className("Yep").build()).field(EditableJavaField.builder().type("String").name("name").build()).field(EditableJavaField.builder().type("int").name("derp").build()).method(EditableJavaMethod.builder().returnType("String").name("type").build()).method(EditableJavaMethod.builder().returnType("int").name("getVersion").build()).build();
        javaClass.setStatic(true);
        Assertions.assertEquals((Object)javaClass, (Object)clazz);
    }

    @Test
    public void testClassWithEverythingAndInnerClassesHaveEverythingToo() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"package com.example;\n\nimport com.example.Something;\n\nimport org.example.SomethingElse;\n\nimport static com.example.SomethingStatic;\n\nimport static org.example.SomethingElseStatic;\n\n/**\n * Something here\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n */\n@Example\n@Test(true)\n@Yep(type=String.class)\npublic final class Test extends Derp implements Blah, Foo{\n\n\t// some comment\n\t/*\n\t * some comment\n\t */\n\t/**\n\t * Something here\n\t * \n\t * @author Logan Ferree (Tadukoo)\n\t * @version Alpha v.0.1\n\t */\n\t@Test\n\t@Yep(true)\n\tprivate static final class Derp extends Blah implements Blah, Foo{\n\t\t// some comment\n\t\t/*\n\t\t * some comment\n\t\t */\n\t\t@Test\n\t\t@Derp(type = String.class)\n\t\tprotected static final String derp = \"Blah\";\n\t\t/** It's something alright */\n\t\t@Blah\n\t\tprotected int something;\n\n\t\t/**\n\t\t * @return the Version\n\t\t */\n\t\t@Blah\n\t\tprivate int getVersion(){return version;}\n\n\t\t@Test\n\t\t@Derp(type=String.class)\n\t\tprivate static String test(String type, int derp) throws Exception, Throwable{doSomething();doSomethingElse();}\n\t}\n\n\t/**\n\t * Something here\n\t * \n\t * @author Logan Ferree (Tadukoo)\n\t * @version Alpha v.0.1\n\t */\n\t@Derp\n\t@Yep(something=\"no\")\n\tprotected static final class Yep extends Something implements Blah, Foo{\n\t\t// some comment\n\t\t/*\n\t\t * some comment\n\t\t */\n\t\tpublic static final String someName = \"Test\";\n\t\t/** This is something else */\n\t\tprivate int somethingElse;\n\n\t\t/**\n\t\t * @return the Version\n\t\t */\n\t\t@Blah\n\t\tprivate int getVersion(){return version;}\n\n\t\t@Test\n\t\t@Derp(type=String.class)\n\t\tprivate static String test(String type, int derp) throws Exception, Throwable{doSomething();doSomethingElse();}\n\t}\n\n\t@Test\n\t@Derp(type = String.class)\n\tprivate static final String name = \"Test\";\n\t@Blah\n\tpublic int version;\n\n\t@Blah\n\tprivate int getVersion(){return version;}\n\n\t@Test\n\t@Derp(type=String.class)\n\tprivate static String test(String type, int derp) throws Exception, Throwable{doSomething();doSomethingElse();}\n}\n");
        EditableJavaClass javaClass = (EditableJavaClass)EditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("com.example").build()).importStatement(EditableJavaImportStatement.builder().importName("com.example.Something").build()).importStatement(EditableJavaImportStatement.builder().importName("org.example.SomethingElse").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example.SomethingStatic").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("org.example.SomethingElseStatic").build()).javadoc(EditableJavadoc.builder().content("Something here").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").build()).annotation(EditableJavaAnnotation.builder().name("Example").build()).annotation(EditableJavaAnnotation.builder().name("Test").parameter("value", "true").build()).annotation(EditableJavaAnnotation.builder().name("Yep").parameter("type", "String.class").build()).visibility(Visibility.PUBLIC).isFinal().className("Test").superClassName("Derp").implementsInterfaceName("Blah").implementsInterfaceName("Foo").singleLineComment(EditableJavaSingleLineComment.builder().content("some comment").build()).multiLineComment(EditableJavaMultiLineComment.builder().content("some comment").build()).innerClass(EditableJavaClass.builder().innerClass().javadoc(EditableJavadoc.builder().content("Something here").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Yep").parameter("value", "true").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().className("Derp").superClassName("Blah").implementsInterfaceName("Blah").implementsInterfaceName("Foo").singleLineComment(EditableJavaSingleLineComment.builder().content("some comment").build()).multiLineComment(EditableJavaMultiLineComment.builder().content("some comment").build()).field(EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PROTECTED).isStatic().isFinal().type("String").name("derp").value("\"Blah\"").build()).field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("It's something alright").build()).annotation(EditableJavaAnnotation.builder().name("Blah").build()).visibility(Visibility.PROTECTED).type("int").name("something").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().returnVal("the Version").build()).annotation(EditableJavaAnnotation.builder().name("Blah").build()).visibility(Visibility.PRIVATE).returnType("int").name("getVersion").line("return version;").build()).method(EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PRIVATE).isStatic().returnType("String").name("test").parameter("String", "type").parameter("int", "derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build()).build()).innerClass(EditableJavaClass.builder().innerClass().javadoc(EditableJavadoc.builder().content("Something here").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).annotation(EditableJavaAnnotation.builder().name("Yep").parameter("something", "\"no\"").build()).visibility(Visibility.PROTECTED).isStatic().isFinal().className("Yep").superClassName("Something").implementsInterfaceName("Blah").implementsInterfaceName("Foo").singleLineComment(EditableJavaSingleLineComment.builder().content("some comment").build()).multiLineComment(EditableJavaMultiLineComment.builder().content("some comment").build()).field(EditableJavaField.builder().visibility(Visibility.PUBLIC).isStatic().isFinal().type("String").name("someName").value("\"Test\"").build()).field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("This is something else").build()).visibility(Visibility.PRIVATE).type("int").name("somethingElse").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().returnVal("the Version").build()).annotation(EditableJavaAnnotation.builder().name("Blah").build()).visibility(Visibility.PRIVATE).returnType("int").name("getVersion").line("return version;").build()).method(EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PRIVATE).isStatic().returnType("String").name("test").parameter("String", "type").parameter("int", "derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build()).build()).field(EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().type("String").name("name").value("\"Test\"").build()).field(EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Blah").build()).visibility(Visibility.PUBLIC).type("int").name("version").build()).method(EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Blah").build()).visibility(Visibility.PRIVATE).returnType("int").name("getVersion").line("return version;").build()).method(EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PRIVATE).isStatic().returnType("String").name("test").parameter("String", "type").parameter("int", "derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build()).build();
        Assertions.assertEquals((Object)javaClass, (Object)clazz);
    }

    @Test
    public void testClassNameFail() {
        try {
            this.parseMethod.apply((Object)"class");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Failed to find class name!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testExtendsAfterBlockOpen() {
        try {
            this.parseMethod.apply((Object)"class Test{ extends\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "found 'extends' after hitting the block open token!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testSuperClassNameFail() {
        try {
            this.parseMethod.apply((Object)"class Test extends");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Failed to find super class name after 'extends'!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testImplementsAfterBlockOpen() {
        try {
            this.parseMethod.apply((Object)"class Test{ implements\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "found 'implements' after hitting the block open token!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testImplementsInterfaceNameFail() {
        try {
            this.parseMethod.apply((Object)"class Test implements");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Failed to find implements interface name after 'implements' or ','!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testImplementsCommaBeforeInterfaceName() {
        try {
            this.parseMethod.apply((Object)"class Test implements , {\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Encountered ',' before any interface names!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testCommaAsSeparateTokenInterfaceNamesThenNoFollowingInterfaceName() {
        try {
            this.parseMethod.apply((Object)"class Test implements Test ,");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Failed to find implements interface name after 'implements' or ','!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testBlockOpenTwice() {
        try {
            this.parseMethod.apply((Object)"class Test{{\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "We hit the block open token twice for the same class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testUnknownInnerType() {
        try {
            this.parseMethod.apply((Object)"class Test{\n\tsomething yep it is\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Unable to determine token: 'something'"), (Object)e.getMessage());
        }
    }

    @Test
    public void testHangingInnerJavadoc() {
        try {
            this.parseMethod.apply((Object)"class Test{\n\t/** {@inheritDoc} */\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Found Javadoc at end of class with nothing to attach it to!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testHangingInnerAnnotation() {
        try {
            this.parseMethod.apply((Object)"class Test{\n\t@Test\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Found annotations at end of class with nothing to attach them to!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testLeadingWhitespace() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"\t  \t\n\t class Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceAfterClass() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class \t \t\n  \t \tTest{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceAfterClassName() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test  \t\n\t  {\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceAfterOpenBrace() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test{\t   \t\n\n\t\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceAfterClosingBrace() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test  \t\n\t  {\n}\t    \t\n\t\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").build(), (Object)clazz);
    }

    @Test
    public void testInsaneWhitespaceSimpleClass() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"\t  \t\n\t class \t \t\n  \t \tTest{\t   \t\n\n\t\n}\t    \t\n\t\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespacePackageDeclarationLeading() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"\t     \t\n\t  package com.example;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespacePackageDeclarationBeforePackageName() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"package \t  \t\n\t  com.example;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespacePackageDeclarationWithinPackageName() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"package com     \t\n\n\t    .\t \t\n\t     example;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespacePackageDeclarationAfterPackageName() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"package com.example\n\t   \t;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespacePackageDeclarationTrailing() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"package com.example;\t  \t\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespacePackageDeclarationInsane() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"\t     \t\n\t  package \t  \t\n\t  com     \t\n\n\t    .\t \t\n\t     example\n\t   \t;\t  \t\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceImportStatementLeading() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"\t   \t\n\t  import com.example;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().importName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceImportStatementBeforeImportName() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"import \t \n\t     com.example;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().importName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceImportStatementWithinImportName() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"import com     \t\n\n\t    .\t        \n\t      example;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().importName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceImportStatementAfterImportName() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"import com.example     \t\n\n\t      ;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().importName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceImportStatementBeforeStatic() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"import    \t\n \t     static com.example;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceImportStatementAfterStatic() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"import static   \t\n \t     com.example;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceImportStatementInsane() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"\t   \t\n\t  import    \t\n \t     static   \t\n \t     com     \t\n\n\t    .\t        \n\t      example     \t\n\n\t      ;\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceAnnotationInsane() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"\t  \t @ \t  \tTest\t  (\t \ttype \t = \n  \t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\n\nclass Test{\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).className("Test").build(), (Object)clazz);
    }

    @Test
    public void testCommaAtStartOfInterfaceNameToken() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test implements Test ,Derp{\n}");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Test").implementsInterfaceName("Derp").build(), (Object)clazz);
    }

    @Test
    public void testCommaAsSeparateTokenInterfaceNames() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test implements Test , Derp{\n}");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Test").implementsInterfaceName("Derp").build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceFieldInsane() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test{\n\t\t  \t @ \t  \tTest\t  (\t \ttype \t = \t\n\t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\t     \t\n  \t\n \t    \t@       Derp   \t\n   \t public\t     \t\n   \t static\t     \t\n   \t final\t     \t  \t\n \tString \t  \t\n \t  type    \t   \t\n  \t =    \t   \t\n  \t \"\" \t  \t\n\t;     \t\n \t   \n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PUBLIC).isStatic().isFinal().type("String").name("type").value("\"\"").build()).build(), (Object)clazz);
    }

    @Test
    public void testWhitespaceMethodInsane() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"class Test{\n\t\t  \t @ \t  \tTest\t  (\t \ttype \t = \t\n\t\t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\t     \t\n\t\t    \t@       Derp   \t\n\t\t\t   \t\n\t\t\t    private     \t   \t\n\t\t    static     \t   \t\n\t\t    String     \t   \t\n\t\t    test     \t   \t\n\t\t    (     \t   \t\n\t\t    String     \t   \t\n\t\t    type     \t   \t\n\t\t    ,     \t   \t\n\t\t    int     \t   \t\n\t\t    derp     \t   \t\n\t\t    )     \t   \t\n\t\t    throws     \t   \t\n\t\t    Exception     \t   \t\n\t\t    ,     \t   \t\n\t\t    Throwable     \t   \t\n\t\t    {     \t   \t\n\t\t    doSomething()     \t   \t\n\t\t    ;     \t   \t\n\t\t    doSomethingElse()     \t   \t\n\t\t    ;     \t   \t\n\t\t    }     \t   \t\n\t\t     \n}");
        Assertions.assertEquals((Object)EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().returnType("String").name("test").parameter("String", "type").parameter("int", "derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build()).build(), (Object)clazz);
    }

    @Test
    public void testClassWithInsaneWhitespaceEverywhere() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"\t     \t\n\t  package \t  \t\n\t  com     \t\n\n\t    .\t \t\n\t     example\n\t   \t;\t  \t\n\n\t   \t\n\t  import    \t\n \t        \t\n \t     com     \t\n\n\t    .\t        \n\t      example     \t\n   .Something   \t\n\t      ;\n\t import     com.example.SomethingElse      \t;\t     \t    \t\n\n\t   \t\n\t  import    \t\n \t     static   \t\n \t     com     \t\n\n\t    .\t        \n\t      example     \t\n\t\t\t\t.SomethingStatic     \t\n\t      ;\n\t  \t import \t      \t static\t  com.example.SomethingElseStatic\t \t  ;\t     \t\n\n\t  \t @ \t  \tTest\t  (\t \ttype \t = \n  \t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\n\n\npublic\t  \t\n\t final\t  \t\n\t    class \t \t\n  \t \tTest{\t   \t\n\n\t  \t @ \t  \tTest\t  (\t \ttype \t = \t\n\t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\t     \t\n  \t\n \t    \t@       Derp   \t\n   \t public\t     \t\n   \t static\t     \t\n   \t final\t     \t  \t\n \tString \t  \t\n \t  type    \t   \t\n  \t =    \t   \t\n  \t \"\" \t  \t\n\t;     \t\n \t   \n \t  \t @ \t  \tTest\t  (\t \ttype \t = \t\n\t\t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\t     \t\n\t\t    \t@       Derp   \t\n\t\t\t   \t\n\t\t\t    private     \t   \t\n\t\t    static     \t   \t\n\t\t    String     \t   \t\n\t\t    test     \t   \t\n\t\t    (     \t   \t\n\t\t    String     \t   \t\n\t\t    type     \t   \t\n\t\t    ,     \t   \t\n\t\t    int     \t   \t\n\t\t    derp     \t   \t\n\t\t    )     \t   \t\n\t\t    throws     \t   \t\n\t\t    Exception     \t   \t\n\t\t    ,     \t   \t\n\t\t    Throwable     \t   \t\n\t\t    {     \t   \t\n\t\t    doSomething()     \t   \t\n\t\t    ;     \t   \t\n\t\t    doSomethingElse()     \t   \t\n\t\t    ;     \t   \t\n\t\t    }     \t   \t\n\t\t     \n\t\n}\t    \t\n\t\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("com.example").build()).importStatement(EditableJavaImportStatement.builder().importName("com.example.Something").build()).importStatement(EditableJavaImportStatement.builder().importName("com.example.SomethingElse").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example.SomethingStatic").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example.SomethingElseStatic").build()).annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).visibility(Visibility.PUBLIC).isFinal().className("Test").field(EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PUBLIC).isStatic().isFinal().type("String").name("type").value("\"\"").build()).method(EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().returnType("String").name("test").parameter("String", "type").parameter("int", "derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build()).build(), (Object)clazz);
    }

    @Test
    public void testLabelFormFieldIssue() throws JavaParsingException {
        JavaClass clazz = (JavaClass)this.parseMethod.apply((Object)"package com.github.tadukoo.view.form.field.string;\n\nimport com.github.tadukoo.view.components.TadukooLabel;\nimport com.github.tadukoo.view.form.field.FormField;\nimport com.github.tadukoo.view.form.field.annotation.FormFieldBuilder;\n\nimport javax.swing.JComponent;\nimport javax.swing.JLabel;\n\n/**\r\n * Represents a {@link FormField} for a Label\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.4\n */\n@FormFieldBuilder(type = String.class, defaultDefaultValue = \"\\\"\\\"\")\npublic class BetterLabelFormField extends FormField<String>{\n\t\n\t/** {@inheritDoc} */\n\t@Override\n\tpublic JComponent getJustComponent() throws Throwable{\n\t\treturn TadukooLabel.builder()\n\t\t\t\t.text(getDefaultValue())\n\t\t\t\t.foregroundPaint(getLabelForegroundPaint()).backgroundPaint(getLabelBackgroundPaint())\n\t\t\t\t.font(getLabelFontFamily(), getLabelFontStyle(), getLabelFontSize())\n\t\t\t\t.shapeInfo(getLabelShape()).border(getLabelBorder())\n\t\t\t\t.fontResourceLoader(getFontResourceLoader())\n\t\t\t\t.build();\n\t}\n\t\n\t/** {@inheritDoc} */\n\t@Override\n\tpublic String getValueFromJustComponent(JComponent component){\n\t\tif(component instanceof JLabel label){\n\t\t\treturn label.getText();\n\t\t}\n\t\treturn null;\n\t}\n}\n");
        Assertions.assertEquals((Object)EditableJavaClass.builder().packageName("com.github.tadukoo.view.form.field.string").importNames(ListUtil.createList((Object[])new String[]{"com.github.tadukoo.view.components.TadukooLabel", "com.github.tadukoo.view.form.field.FormField", "com.github.tadukoo.view.form.field.annotation.FormFieldBuilder", "javax.swing.JComponent", "javax.swing.JLabel"}), false).javadoc(EditableJavadoc.builder().content("Represents a {@link FormField} for a Label").author("Logan Ferree (Tadukoo)").version("Alpha v.0.4").build()).annotation(EditableJavaAnnotation.builder().name("FormFieldBuilder").parameter("type", "String.class").parameter("defaultDefaultValue", "\"\\\"\\\"\"").build()).visibility(Visibility.PUBLIC).className("BetterLabelFormField").superClassName("FormField<String>").method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("{@inheritDoc}").build()).annotation(EditableJavaAnnotation.builder().name("Override").build()).visibility(Visibility.PUBLIC).returnType("JComponent").name("getJustComponent").throwType("Throwable").line("return TadukooLabel.builder()").line("\t\t.text(getDefaultValue())").line("\t\t.foregroundPaint(getLabelForegroundPaint()).backgroundPaint(getLabelBackgroundPaint())").line("\t\t.font(getLabelFontFamily(), getLabelFontStyle(), getLabelFontSize())").line("\t\t.shapeInfo(getLabelShape()).border(getLabelBorder())").line("\t\t.fontResourceLoader(getFontResourceLoader())").line("\t\t.build();").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("{@inheritDoc}").build()).annotation(EditableJavaAnnotation.builder().name("Override").build()).visibility(Visibility.PUBLIC).returnType("String").name("getValueFromJustComponent").parameter("JComponent", "component").line("if(component instanceof JLabel label){").line("\treturn label.getText();").line("}").line("return null;").build()).build(), (Object)clazz);
        Assertions.assertEquals((Object)"package com.github.tadukoo.view.form.field.string;\n\nimport com.github.tadukoo.view.components.TadukooLabel;\nimport com.github.tadukoo.view.form.field.FormField;\nimport com.github.tadukoo.view.form.field.annotation.FormFieldBuilder;\n\nimport javax.swing.JComponent;\nimport javax.swing.JLabel;\n\n/**\n * Represents a {@link FormField} for a Label\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.4\n */\n@FormFieldBuilder(type = String.class, defaultDefaultValue = \"\\\"\\\"\")\npublic class BetterLabelFormField extends FormField<String>{\n\t\n\t/** {@inheritDoc} */\n\t@Override\n\tpublic JComponent getJustComponent() throws Throwable{\n\t\treturn TadukooLabel.builder()\n\t\t\t\t.text(getDefaultValue())\n\t\t\t\t.foregroundPaint(getLabelForegroundPaint()).backgroundPaint(getLabelBackgroundPaint())\n\t\t\t\t.font(getLabelFontFamily(), getLabelFontStyle(), getLabelFontSize())\n\t\t\t\t.shapeInfo(getLabelShape()).border(getLabelBorder())\n\t\t\t\t.fontResourceLoader(getFontResourceLoader())\n\t\t\t\t.build();\n\t}\n\t\n\t/** {@inheritDoc} */\n\t@Override\n\tpublic String getValueFromJustComponent(JComponent component){\n\t\tif(component instanceof JLabel label){\n\t\t\treturn label.getText();\n\t\t}\n\t\treturn null;\n\t}\n}\n", (Object)clazz.toString());
    }
}

