/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.classtypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.classtypes.BaseJavaClassParserTest;
import com.github.tadukoo.java.parsing.classtypes.JavaClassParser;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JavaClassParserTest
extends BaseJavaClassParserTest {
    public JavaClassParserTest() {
        super((ThrowingFunction<String, JavaClass, JavaParsingException>)((ThrowingFunction)JavaClassParser::parseClass));
    }

    @Test
    public void testMultiplePackageDeclarations() {
        try {
            JavaClassParser.parseClass((String)"package some.package;\npackage something.else;\nclass Test{\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Only one package declaration allowed on a class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testPackageDeclarationAfterClass() {
        try {
            JavaClassParser.parseClass((String)"class Test{\n}\npackage some.package;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Encountered package declaration after class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testImportStatementAfterClass() {
        try {
            JavaClassParser.parseClass((String)"class Test{\n}\nimport some.name;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Encountered import statement after class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMultipleJavadocs() {
        try {
            JavaClassParser.parseClass((String)"/** {@inheritDoc} */\n/** something */\nclass Test{\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Only one Javadoc allowed on a class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testJavadocAfterClass() {
        try {
            JavaClassParser.parseClass((String)"class Test{\n}\n/** {@inheritDoc} */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Encountered Javadoc after class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testAnnotationAfterClass() {
        try {
            JavaClassParser.parseClass((String)"class Test{\n}\n@Test");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Encountered annotation after class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMultipleClasses() {
        try {
            JavaClassParser.parseClass((String)"class Test{\n}\nclass Derp{\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Encountered multiple classes!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testParsedNotAClass() {
        try {
            JavaClassParser.parseClass((String)"@Test");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Failed to parse an actual class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFirstTokenNotClass() {
        try {
            JavaClassParser.parseClass((String)"Test{\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "The first token of a class must be 'class'"), (Object)e.getMessage());
        }
    }
}

