/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseJavaAnnotationParserTest
extends BaseJavaParserTest {
    private final ThrowingFunction<String, JavaAnnotation, JavaParsingException> parseMethod;

    protected BaseJavaAnnotationParserTest(ThrowingFunction<String, JavaAnnotation, JavaParsingException> parseMethod) {
        this.parseMethod = parseMethod;
    }

    @Test
    public void testSimpleAnnotation() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@Test");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        Assertions.assertEquals(new ArrayList(), (Object)annotation.getParameters());
        Assertions.assertEquals((Object)"@Test", (Object)annotation.toString());
    }

    @Test
    public void testAnnotationWithValueParameter() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@Test(true)");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"value", (Object)"true")}), (Object)annotation.getParameters());
        Assertions.assertEquals((Object)"@Test(true)", (Object)annotation.toString());
    }

    @Test
    public void testAnnotationWithParameter() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@Test(type = String.class)");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"type", (Object)"String.class")}), (Object)annotation.getParameters());
        Assertions.assertEquals((Object)"@Test(type = String.class)", (Object)annotation.toString());
    }

    @Test
    public void testAnnotationWithMultipleParameters() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@Test(type = String.class, defaultValue = \"\")");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"type", (Object)"String.class"), Pair.of((Object)"defaultValue", (Object)"\"\"")}), (Object)annotation.getParameters());
        Assertions.assertEquals((Object)"@Test(type = String.class, defaultValue = \"\")", (Object)annotation.toString());
    }

    @Test
    public void testParseAnnotationWhitespaceBefore() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)" \t@Test");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
    }

    @Test
    public void testParseAnnotationWhitespaceBeforeName() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@\t Test");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
    }

    @Test
    public void testParseAnnotationWhitespaceAfterName() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@Test \t");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
    }

    @Test
    public void testParseAnnotationWhitespaceBeforeParams() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@Test (type = String.class)");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"type", (Object)"String.class")}), (Object)annotation.getParameters());
    }

    @Test
    public void testParseAnnotationWhitespaceBeforeParamName() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@Test( \ttype = String.class)");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"type", (Object)"String.class")}), (Object)annotation.getParameters());
    }

    @Test
    public void testParseAnnotationWhitespaceAfterParamName() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@Test(type \t = String.class)");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"type", (Object)"String.class")}), (Object)annotation.getParameters());
    }

    @Test
    public void testParseAnnotationWhitespaceBeforeParamValue() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@Test(type =  \tString.class)");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"type", (Object)"String.class")}), (Object)annotation.getParameters());
    }

    @Test
    public void testParseAnnotationWhitespaceAfterParamValue() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@Test(type = String.class \t)");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"type", (Object)"String.class")}), (Object)annotation.getParameters());
    }

    @Test
    public void testParseAnnotationWhitespaceAfterParams() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@Test(type = String.class) \t");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"type", (Object)"String.class")}), (Object)annotation.getParameters());
    }

    @Test
    public void testParseAnnotationWhitespaceBeforeComma() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@Test(type = String.class  \t, defaultValue = \"\")");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"type", (Object)"String.class"), Pair.of((Object)"defaultValue", (Object)"\"\"")}), (Object)annotation.getParameters());
    }

    @Test
    public void testParseAnnotationWhitespaceAfterComma() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"@Test(type = String.class, \t  \t defaultValue = \"\")");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"type", (Object)"String.class"), Pair.of((Object)"defaultValue", (Object)"\"\"")}), (Object)annotation.getParameters());
    }

    @Test
    public void testParseAnnotationInsaneWhitespace() throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)this.parseMethod.apply((Object)"  \t  \t @ \t  \tTest\t  (\t \ttype \t = \t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t");
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"type", (Object)"String.class"), Pair.of((Object)"defaultValue", (Object)"\"\"")}), (Object)annotation.getParameters());
    }
}

