/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseJavaFieldParserTest
extends BaseJavaParserTest {
    private final ThrowingFunction<String, JavaField, JavaParsingException> parseMethod;

    protected BaseJavaFieldParserTest(ThrowingFunction<String, JavaField, JavaParsingException> parseMethod) {
        this.parseMethod = parseMethod;
    }

    @Test
    public void testSimpleField() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"String name;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().type("String").name("name").build(), (Object)field);
        Assertions.assertEquals((Object)"String name;", (Object)field.toString());
    }

    @Test
    public void testFieldWithVisibility() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"private String name;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().visibility(Visibility.PRIVATE).type("String").name("name").build(), (Object)field);
        Assertions.assertEquals((Object)"private String name;", (Object)field.toString());
    }

    @Test
    public void testFieldWithProtectedVisibility() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"protected String name;");
        Assertions.assertEquals((Object)EditableJavaField.builder().visibility(Visibility.PROTECTED).type("String").name("name").build(), (Object)field);
        Assertions.assertEquals((Object)"protected String name;", (Object)field.toString());
    }

    @Test
    public void testFieldWithPublicVisibility() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"public String name;");
        Assertions.assertEquals((Object)EditableJavaField.builder().visibility(Visibility.PUBLIC).type("String").name("name").build(), (Object)field);
        Assertions.assertEquals((Object)"public String name;", (Object)field.toString());
    }

    @Test
    public void testFieldWithAbstract() {
        try {
            this.parseMethod.apply((Object)"abstract String name;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "'abstract' is not a valid modifier on field!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFieldWithStatic() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"static String name;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().isStatic().type("String").name("name").build(), (Object)field);
        Assertions.assertEquals((Object)"static String name;", (Object)field.toString());
    }

    @Test
    public void testFieldWithFinal() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"final String name;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().isFinal().type("String").name("name").build(), (Object)field);
        Assertions.assertEquals((Object)"final String name;", (Object)field.toString());
    }

    @Test
    public void testFieldWithModifiersReversed() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"final static public String name;");
        Assertions.assertEquals((Object)EditableJavaField.builder().visibility(Visibility.PUBLIC).isStatic().isFinal().type("String").name("name").build(), (Object)field);
        Assertions.assertEquals((Object)"public static final String name;", (Object)field.toString());
    }

    @Test
    public void testFieldWithValue() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"String name = \"\";");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().type("String").name("name").value("\"\"").build(), (Object)field);
        Assertions.assertEquals((Object)"String name = \"\";", (Object)field.toString());
    }

    @Test
    public void testFieldWithAnnotation() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"@Test\nString name;");
        Assertions.assertEquals((Object)EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).type("String").name("name").build(), (Object)field);
        Assertions.assertEquals((Object)"@Test\nString name;", (Object)field.toString());
    }

    @Test
    public void testFieldWithMultipleAnnotations() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"@Test\n@Derp(type=String.class)\nString name;");
        Assertions.assertEquals((Object)EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).type("String").name("name").build(), (Object)field);
        Assertions.assertEquals((Object)"@Test\n@Derp(type = String.class)\nString name;", (Object)field.toString());
    }

    @Test
    public void testFieldWithJavadoc() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"/** {@inheritDoc} */\nString name;");
        Assertions.assertEquals((Object)EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("{@inheritDoc}").build()).type("String").name("name").build(), (Object)field);
        Assertions.assertEquals((Object)"/** {@inheritDoc} */\nString name;", (Object)field.toString());
    }

    @Test
    public void testFieldWithEverything() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"/** {@inheritDoc} */\n@Test\n@Derp(type=String.class)\nprivate static final String name = \"\";");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("{@inheritDoc}").build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().type("String").name("name").value("\"\"").build(), (Object)field);
        Assertions.assertEquals((Object)"/** {@inheritDoc} */\n@Test\n@Derp(type = String.class)\nprivate static final String name = \"\";", (Object)field.toString());
    }

    @Test
    public void testFieldWithValueNoSemicolon() {
        try {
            this.parseMethod.apply((Object)"String name = \"\"");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to find semicolon at end of field"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFieldWithEverythingNoSemicolon() {
        try {
            this.parseMethod.apply((Object)"private static final String name = \"\"");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to find semicolon at end of field"), (Object)e.getMessage());
        }
    }

    @Test
    public void testWhitespaceBeforeType() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"\t     \t  \t\n  \tString type;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceBeforeName() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"String \t  \t\n  \t  type;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceBeforeSemicolon() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"String type \t  \t\n \t;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceAfterSemicolon() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"String type;     \t\n  \t   ");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceBeforePrivate() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"\t     \t\n    \t private String type;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().visibility(Visibility.PRIVATE).type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"private String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceAfterPrivate() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"private\t     \t\n    \t String type;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().visibility(Visibility.PRIVATE).type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"private String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceBeforeProtected() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"\t     \t\n    \t protected String type;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().visibility(Visibility.PROTECTED).type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"protected String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceAfterProtected() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"protected\t     \t\n    \t String type;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().visibility(Visibility.PROTECTED).type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"protected String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceBeforePublic() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"\t     \t\n    \t public String type;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().visibility(Visibility.PUBLIC).type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"public String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceAfterPublic() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"public\t     \t\n    \t String type;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().visibility(Visibility.PUBLIC).type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"public String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceBeforeStatic() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"\t     \t\n    \t static String type;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().isStatic().type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"static String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceAfterStatic() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"static\t     \t\n    \t String type;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().isStatic().type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"static String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceBeforeFinal() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"\t     \t\n    \t final String type;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().isFinal().type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"final String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceAfterFinal() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"final\t     \t\n    \t String type;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().isFinal().type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"final String type;", (Object)field.toString());
    }

    @Test
    public void testWhitespaceBeforeEquals() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"String type    \t   \t\n   \t = \"\";");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().type("String").name("type").value("\"\"").build(), (Object)field);
        Assertions.assertEquals((Object)"String type = \"\";", (Object)field.toString());
    }

    @Test
    public void testWhitespaceBeforeValue() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"String type =    \t   \t\n   \t \"\";");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().type("String").name("type").value("\"\"").build(), (Object)field);
        Assertions.assertEquals((Object)"String type = \"\";", (Object)field.toString());
    }

    @Test
    public void testWhitespaceAfterValue() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"String type = \"\"    \t   \t\n   \t ;");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().type("String").name("type").value("\"\"").build(), (Object)field);
        Assertions.assertEquals((Object)"String type = \"\";", (Object)field.toString());
    }

    @Test
    public void testWhitespaceInValue() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"/** An array containing 0-9 and then A-F, used for converting to hex */\r\n\t\t\t\t\tpublic static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t'A', 'B', 'C', 'D', 'E', 'F'};");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("An array containing 0-9 and then A-F, used for converting to hex").build()).visibility(Visibility.PUBLIC).isStatic().isFinal().type("char[]").name("hexChars").value("new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',\n\t\t\t\t\t\t\t\t\t\t\t\t'A', 'B', 'C', 'D', 'E', 'F'}").build(), (Object)field);
        Assertions.assertEquals((Object)"/** An array containing 0-9 and then A-F, used for converting to hex */\npublic static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',\n\t\t\t\t\t\t\t\t\t\t\t\t'A', 'B', 'C', 'D', 'E', 'F'};", (Object)field.toString());
    }

    @Test
    public void testInsaneWhitespaceSimpleField() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"\t     \t  \t\n  \tString \t  \t\n  \t  type \t  \t\n \t;     \t\n  \t   ");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().type("String").name("type").build(), (Object)field);
        Assertions.assertEquals((Object)"String type;", (Object)field.toString());
    }

    @Test
    public void testInsaneWhitespaceEverythingField() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"\t     \t\n    \t public\t     \t\n    \t static\t     \t\n    \t final\t     \t  \t\n  \tString \t  \t\n  \t  type    \t   \t\n   \t =    \t   \t\n   \t \"\" \t  \t\n \t;     \t\n  \t   ");
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)EditableJavaField.builder().visibility(Visibility.PUBLIC).isStatic().isFinal().type("String").name("type").value("\"\"").build(), (Object)field);
        Assertions.assertEquals((Object)"public static final String type = \"\";", (Object)field.toString());
    }

    @Test
    public void testInsaneWhitespaceEverythingFieldWithAnnotations() throws JavaParsingException {
        JavaField field = (JavaField)this.parseMethod.apply((Object)"\t  \t @ \t  \tTest\t  (\t \ttype \t = \t\n\t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\t     \t\n  \t\n \t    \t@       Derp   \t\n   \t public\t     \t\n   \t static\t     \t\n   \t final\t     \t  \t\n \tString \t  \t\n \t  type    \t   \t\n  \t =    \t   \t\n  \t \"\" \t  \t\n\t;     \t\n \t   ");
        Assertions.assertEquals((Object)EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PUBLIC).isStatic().isFinal().type("String").name("type").value("\"\"").build(), (Object)field);
        Assertions.assertEquals((Object)"@Test(type = String.class, defaultValue = \"\")\n@Derp\npublic static final String type = \"\";", (Object)field.toString());
    }
}

