/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseJavaImportStatementParserTest
extends BaseJavaParserTest {
    private final ThrowingFunction<String, JavaImportStatement, JavaParsingException> parseMethod;

    protected BaseJavaImportStatementParserTest(ThrowingFunction<String, JavaImportStatement, JavaParsingException> parseMethod) {
        this.parseMethod = parseMethod;
    }

    @Test
    public void testSimpleImport() throws JavaParsingException {
        JavaImportStatement importStatement = (JavaImportStatement)this.parseMethod.apply((Object)"import com.example;");
        Assertions.assertFalse((boolean)importStatement.isStatic());
        Assertions.assertEquals((Object)"com.example", (Object)importStatement.getImportName());
    }

    @Test
    public void testStaticImport() throws JavaParsingException {
        JavaImportStatement importStatement = (JavaImportStatement)this.parseMethod.apply((Object)"import static com.example;");
        Assertions.assertTrue((boolean)importStatement.isStatic());
        Assertions.assertEquals((Object)"com.example", (Object)importStatement.getImportName());
    }

    @Test
    public void testErrorNoImportName() {
        try {
            this.parseMethod.apply((Object)"import ;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.IMPORT_STATEMENT, "Failed to find import name in import statement!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testErrorNoSemicolon() {
        try {
            this.parseMethod.apply((Object)"import com.example");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.IMPORT_STATEMENT, "Failed to find semicolon ending import statement!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testAllErrors() {
        try {
            this.parseMethod.apply((Object)"import ");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.IMPORT_STATEMENT, "Failed to find import name in import statement!\nFailed to find semicolon ending import statement!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testWhitespaceLeading() throws JavaParsingException {
        JavaImportStatement importStatement = (JavaImportStatement)this.parseMethod.apply((Object)"\t     \t\n    \n\t import com.example;");
        Assertions.assertFalse((boolean)importStatement.isStatic());
        Assertions.assertEquals((Object)"com.example", (Object)importStatement.getImportName());
    }

    @Test
    public void testWhitespaceAfterImport() throws JavaParsingException {
        JavaImportStatement importStatement = (JavaImportStatement)this.parseMethod.apply((Object)"import\t     \t\n    \n\t com.example;");
        Assertions.assertFalse((boolean)importStatement.isStatic());
        Assertions.assertEquals((Object)"com.example", (Object)importStatement.getImportName());
    }

    @Test
    public void testWhitespaceWithinImportName() throws JavaParsingException {
        JavaImportStatement importStatement = (JavaImportStatement)this.parseMethod.apply((Object)"import com\t     \n\t     .    \n   \t    example;");
        Assertions.assertFalse((boolean)importStatement.isStatic());
        Assertions.assertEquals((Object)"com.example", (Object)importStatement.getImportName());
    }

    @Test
    public void testWhitespaceAfterImportName() throws JavaParsingException {
        JavaImportStatement importStatement = (JavaImportStatement)this.parseMethod.apply((Object)"import com.example    \n\t\n   ;");
        Assertions.assertFalse((boolean)importStatement.isStatic());
        Assertions.assertEquals((Object)"com.example", (Object)importStatement.getImportName());
    }

    @Test
    public void testWhitespaceBeforeStatic() throws JavaParsingException {
        JavaImportStatement importStatement = (JavaImportStatement)this.parseMethod.apply((Object)"import     \n\t      \n    static com.example;");
        Assertions.assertTrue((boolean)importStatement.isStatic());
        Assertions.assertEquals((Object)"com.example", (Object)importStatement.getImportName());
    }

    @Test
    public void testWhitespaceAfterStatic() throws JavaParsingException {
        JavaImportStatement importStatement = (JavaImportStatement)this.parseMethod.apply((Object)"import static        \n\t     \n  com.example;");
        Assertions.assertTrue((boolean)importStatement.isStatic());
        Assertions.assertEquals((Object)"com.example", (Object)importStatement.getImportName());
    }

    @Test
    public void testWhitespaceInsane() throws JavaParsingException {
        JavaImportStatement importStatement = (JavaImportStatement)this.parseMethod.apply((Object)"\t     \t\n    \n\t import\t     \t\n    \n\t static        \n\t     \n  com\t     \n\t     .    \n   \t    example    \n\t\n   ;");
        Assertions.assertTrue((boolean)importStatement.isStatic());
        Assertions.assertEquals((Object)"com.example", (Object)importStatement.getImportName());
    }
}

