/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseJavaMethodParserTest
extends BaseJavaParserTest {
    private final ThrowingFunction<String, JavaMethod, JavaParsingException> parseMethod;

    protected BaseJavaMethodParserTest(ThrowingFunction<String, JavaMethod, JavaParsingException> parseMethod) {
        this.parseMethod = parseMethod;
    }

    @Test
    public void testSimpleMethod() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(){ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithName() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"String test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("String").name("test").build(), (Object)method);
        Assertions.assertEquals((Object)"String test(){ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithVisibility() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"private Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"private Test(){ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithVisibilityProtected() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"protected Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PROTECTED).returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"protected Test(){ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithVisibilityPublic() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"public Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"public Test(){ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithAbstract() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"abstract Test();");
        Assertions.assertEquals((Object)EditableJavaMethod.builder().isAbstract().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"abstract Test();", (Object)method.toString());
    }

    @Test
    public void testMethodWithStatic() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"static Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().isStatic().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"static Test(){ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithFinal() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"final Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().isFinal().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"final Test(){ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithReversedModifiers() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"final static protected Test(){}");
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PROTECTED).isStatic().isFinal().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"protected static final Test(){ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithParameter() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(String type){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").parameter("String", "type").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(String type){ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithMultipleParameters() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(String type, int derp){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").parameter("String", "type").parameter("int", "derp").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(String type, int derp){ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithThrows() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test() throws Exception{}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").build(), (Object)method);
        Assertions.assertEquals((Object)"Test() throws Exception{ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithMultipleThrows() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test() throws Exception, Throwable{}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").throwType("Throwable").build(), (Object)method);
        Assertions.assertEquals((Object)"Test() throws Exception, Throwable{ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithOneLineContent() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(){doSomething();}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").line("doSomething();").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(){\n\tdoSomething();\n}", (Object)method.toString());
    }

    @Test
    public void testMethodWithContent() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(){doSomething();doSomethingElse();}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").line("doSomething();").line("doSomethingElse();").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(){\n\tdoSomething();\n\tdoSomethingElse();\n}", (Object)method.toString());
    }

    @Test
    public void testMethodWithEverything() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"private static final String test(String type, int derp) throws Exception, Throwable{doSomething();doSomethingElse();}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).isStatic().isFinal().returnType("String").name("test").parameter("String", "type").parameter("int", "derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build(), (Object)method);
        Assertions.assertEquals((Object)"private static final String test(String type, int derp) throws Exception, Throwable{\n\tdoSomething();\n\tdoSomethingElse();\n}", (Object)method.toString());
    }

    @Test
    public void testMethodWithAnnotation() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"@Test\nTest(){}");
        Assertions.assertEquals((Object)EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"@Test\nTest(){ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithMultipleAnnotations() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"@Test\n@Derp(type=String.class)\nTest(){}");
        Assertions.assertEquals((Object)EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"@Test\n@Derp(type = String.class)\nTest(){ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithJavadoc() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"/** {@inheritDoc} */\nTest(){}");
        Assertions.assertEquals((Object)EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("{@inheritDoc}").build()).returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"/** {@inheritDoc} */\nTest(){ }", (Object)method.toString());
    }

    @Test
    public void testMethodWithEverythingAndAnnotations() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"/** {@inheritDoc} */\n@Test\n@Derp(type=String.class)\nprivate static final String test(String type, int derp) throws Exception, Throwable{doSomething();doSomethingElse();}");
        Assertions.assertEquals((Object)EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("{@inheritDoc}").build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().returnType("String").name("test").parameter("String", "type").parameter("int", "derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build(), (Object)method);
        Assertions.assertEquals((Object)"/** {@inheritDoc} */\n@Test\n@Derp(type = String.class)\nprivate static final String test(String type, int derp) throws Exception, Throwable{\n\tdoSomething();\n\tdoSomethingElse();\n}", (Object)method.toString());
    }

    @Test
    public void testMethodIncomplete() {
        try {
            this.parseMethod.apply((Object)"Test(){");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.METHOD, "Didn't complete the method"), (Object)e.getMessage());
        }
    }

    @Test
    public void testParametersIncomplete() {
        try {
            this.parseMethod.apply((Object)"Test(");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.METHOD, "Didn't complete parameters in method\nDidn't complete the method"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMethodWithLineWithNoSemicolon() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(){\n\tsomething.builder()\n\t\t\t.build();\n}");
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").line("something.builder()").line("\t\t.build();").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(){\n\tsomething.builder()\n\t\t\t.build();\n}", (Object)method.toString());
    }

    @Test
    public void testMethodWithBlankSpaceBetweenSemicolons() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(){\n\tfor(int i = 0;;){\n\t\tdoSomething();\n\t}\n}");
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").line("for(int i = 0;;){").line("\tdoSomething();").line("}").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(){\n\tfor(int i = 0;;){\n\t\tdoSomething();\n\t}\n}", (Object)method.toString());
    }

    @Test
    public void testMethodWithBlocksInside() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"public static String toHex(byte[] bytes){\n\tStringBuilder hex = new StringBuilder();\n\tfor(byte bite: bytes){\n\t\thex.append(toHex(bite));\n\t}\n\treturn hex.toString();\n}");
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).isStatic().returnType("String").name("toHex").parameter("byte[]", "bytes").line("StringBuilder hex = new StringBuilder();").line("for(byte bite: bytes){").line("\thex.append(toHex(bite));").line("}").line("return hex.toString();").build(), (Object)method);
        Assertions.assertEquals((Object)"public static String toHex(byte[] bytes){\n\tStringBuilder hex = new StringBuilder();\n\tfor(byte bite: bytes){\n\t\thex.append(toHex(bite));\n\t}\n\treturn hex.toString();\n}", (Object)method.toString());
    }

    @Test
    public void testMethodWithMoreBlocksInside() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"public static byte[] fromHex(String hex){\n\tint size = hex.length();\n\n\t// Check that the size is even\n\tif(size % 2 != 0){\n\t\tthrow new IllegalArgumentException(\"hex string must be an even length: \" + hex);\n\t}\n\n\t// Create byte array to store the bytes in\n\tbyte[] bites = new byte[size/2];\n\n\t// Iterate over the string, 2 characters at a time\n\tfor(int i = 0; i < size; i+=2){\n\t\tint highNibble = hexToInt(hex.charAt(i));\n\t\tint lowNibble = hexToInt(hex.charAt(i+1));\n\t\t// If either nibble came out -1, we have an illegal hex character\n\t\tif(highNibble == -1 || lowNibble == -1){\n\t\t\tthrow new IllegalArgumentException(\"hex string contains an illegal hex character: \" + hex);\n\t\t}\n\n\t\tbites[i/2] = (byte) (highNibble*16 + lowNibble);\n\t}\n\n\treturn bites;\n}");
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).isStatic().returnType("byte[]").name("fromHex").parameter("String", "hex").line("int size = hex.length();").line("").line("// Check that the size is even").line("if(size % 2 != 0){").line("\tthrow new IllegalArgumentException(\"hex string must be an even length: \" + hex);").line("}").line("").line("// Create byte array to store the bytes in").line("byte[] bites = new byte[size/2];").line("").line("// Iterate over the string, 2 characters at a time").line("for(int i = 0; i < size; i+=2){").line("\tint highNibble = hexToInt(hex.charAt(i));").line("\tint lowNibble = hexToInt(hex.charAt(i+1));").line("\t// If either nibble came out -1, we have an illegal hex character").line("\tif(highNibble == -1 || lowNibble == -1){").line("\t\tthrow new IllegalArgumentException(\"hex string contains an illegal hex character: \" + hex);").line("\t}").line("\t").line("\tbites[i/2] = (byte) (highNibble*16 + lowNibble);").line("}").line("").line("return bites;").build(), (Object)method);
        Assertions.assertEquals((Object)"public static byte[] fromHex(String hex){\n\tint size = hex.length();\n\t\n\t// Check that the size is even\n\tif(size % 2 != 0){\n\t\tthrow new IllegalArgumentException(\"hex string must be an even length: \" + hex);\n\t}\n\t\n\t// Create byte array to store the bytes in\n\tbyte[] bites = new byte[size/2];\n\t\n\t// Iterate over the string, 2 characters at a time\n\tfor(int i = 0; i < size; i+=2){\n\t\tint highNibble = hexToInt(hex.charAt(i));\n\t\tint lowNibble = hexToInt(hex.charAt(i+1));\n\t\t// If either nibble came out -1, we have an illegal hex character\n\t\tif(highNibble == -1 || lowNibble == -1){\n\t\t\tthrow new IllegalArgumentException(\"hex string contains an illegal hex character: \" + hex);\n\t\t}\n\t\t\n\t\tbites[i/2] = (byte) (highNibble*16 + lowNibble);\n\t}\n\t\n\treturn bites;\n}", (Object)method.toString());
    }

    @Test
    public void testMethodWithIfElseIfBlocks() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"public static int hexToInt(char hexChar){\n\tif('0' <= hexChar && hexChar <= '9'){\n\t\treturn hexChar - '0';\n\t}else if('A' <= hexChar && hexChar <= 'F'){\n\t\treturn hexChar - 'A' + 10;\n\t}else if('a' <= hexChar && hexChar <= 'f'){\n\t\treturn hexChar - 'a' + 10;\n\t}else{\n\t\treturn -1;\n\t}\n}");
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).isStatic().returnType("int").name("hexToInt").parameter("char", "hexChar").line("if('0' <= hexChar && hexChar <= '9'){").line("\treturn hexChar - '0';").line("}else if('A' <= hexChar && hexChar <= 'F'){").line("\treturn hexChar - 'A' + 10;").line("}else if('a' <= hexChar && hexChar <= 'f'){").line("\treturn hexChar - 'a' + 10;").line("}else{").line("\treturn -1;").line("}").build(), (Object)method);
        Assertions.assertEquals((Object)"public static int hexToInt(char hexChar){\n\tif('0' <= hexChar && hexChar <= '9'){\n\t\treturn hexChar - '0';\n\t}else if('A' <= hexChar && hexChar <= 'F'){\n\t\treturn hexChar - 'A' + 10;\n\t}else if('a' <= hexChar && hexChar <= 'f'){\n\t\treturn hexChar - 'a' + 10;\n\t}else{\n\t\treturn -1;\n\t}\n}", (Object)method.toString());
    }

    @Test
    public void testMethodWithThrowsAndInnerBlockOpenToken() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"public static List<File> listAllFiles(Path directoryPath) throws IOException{\n\ttry(Stream<Path> pathStream = Files.walk(directoryPath)){\n\t\treturn pathStream\n\t\t\t\t.filter(Files::isRegularFile)\n\t\t\t\t.map(Path::toFile)\n\t\t\t\t.collect(Collectors.toList());\n\t}\n}");
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).isStatic().returnType("List<File>").name("listAllFiles").parameter("Path", "directoryPath").throwType("IOException").line("try(Stream<Path> pathStream = Files.walk(directoryPath)){").line("\treturn pathStream").line("\t\t\t.filter(Files::isRegularFile)").line("\t\t\t.map(Path::toFile)").line("\t\t\t.collect(Collectors.toList());").line("}").build(), (Object)method);
        Assertions.assertEquals((Object)"public static List<File> listAllFiles(Path directoryPath) throws IOException{\n\ttry(Stream<Path> pathStream = Files.walk(directoryPath)){\n\t\treturn pathStream\n\t\t\t\t.filter(Files::isRegularFile)\n\t\t\t\t.map(Path::toFile)\n\t\t\t\t.collect(Collectors.toList());\n\t}\n}", (Object)method.toString());
    }

    @Test
    public void testNoWhitespaceSimpleMethod() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(){ }", (Object)method.toString());
    }

    @Test
    public void testNoWhitespaceEverythingMethod() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"private static String test(String type, int derp)throws Exception,Throwable{doSomething();doSomethingElse();}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).isStatic().returnType("String").name("test").parameter("String", "type").parameter("int", "derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build(), (Object)method);
        Assertions.assertEquals((Object)"private static String test(String type, int derp) throws Exception, Throwable{\n\tdoSomething();\n\tdoSomethingElse();\n}", (Object)method.toString());
    }

    @Test
    public void testLeadingWhitespace() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"\t    \n  \t    Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceAfterReturnType() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test    \t    \n  \t   (){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceInEmptyParameters() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test (    \t\n    \t    ){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceBetweenParametersAndOpen() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test()      \t\n  \t    \t{}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceInMethod() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(){       \t\n   \t    \t\n    \t }");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(){ }", (Object)method.toString());
    }

    @Test
    public void testTrailingWhitespace() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(){}     \t\n   \t    \t\n   \t");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceBeforePrivate() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"\t     \t  \n  \tprivate Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"private Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceBeforeProtected() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"\t     \t  \n  \tprotected Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PROTECTED).returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"protected Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceBeforePublic() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"\t     \t  \n  \tpublic Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"public Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceAfterPrivate() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"private\t     \t  \n  \tTest(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"private Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceAfterProtected() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"protected\t     \t  \n  \tTest(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PROTECTED).returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"protected Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceAfterPublic() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"public\t     \t  \n  \tTest(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"public Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceBeforeStatic() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"\t    \t     \t   \t\n  \t  \tstatic Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().isStatic().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"static Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceAfterStatic() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"static      \t     \t\n    \t    \t  Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().isStatic().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"static Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceBeforeFinal() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"\t    \t     \t   \t\n  \t  \tfinal Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().isFinal().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"final Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceAfterFinal() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"final      \t     \t\n    \t    \t  Test(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().isFinal().returnType("Test").build(), (Object)method);
        Assertions.assertEquals((Object)"final Test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceBeforeName() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"String    \t    \t\n   \t   \ttest(){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("String").name("test").build(), (Object)method);
        Assertions.assertEquals((Object)"String test(){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceBeforeParameterType() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(    \t     \t\n    \t   \t\n    String type){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").parameter("String", "type").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(String type){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceAfterParameterType() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(String    \t     \t\n    \t   \t\n    type){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").parameter("String", "type").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(String type){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceAfterParameterName() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(String type    \t     \t\n    \t   \t\n    \t ){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").parameter("String", "type").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(String type){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceBeforeParameterComma() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(String type    \t\n    \t   \t ,int derp){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").parameter("String", "type").parameter("int", "derp").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(String type, int derp){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceAfterParameterComma() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test(String type,    \t\n    \t   \t int derp){}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").parameter("String", "type").parameter("int", "derp").build(), (Object)method);
        Assertions.assertEquals((Object)"Test(String type, int derp){ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceBeforeThrows() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test()     \t   \t\n    \t    throws Exception{}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").build(), (Object)method);
        Assertions.assertEquals((Object)"Test() throws Exception{ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceAfterThrows() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test()throws     \t   \t\n    \t    Exception{}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").build(), (Object)method);
        Assertions.assertEquals((Object)"Test() throws Exception{ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceAfterThrowType() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test()throws Exception     \t   \t\n    \t    {}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").build(), (Object)method);
        Assertions.assertEquals((Object)"Test() throws Exception{ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceBeforeThrowComma() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test()throws Exception     \t   \t\n    \t    ,Throwable{}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").throwType("Throwable").build(), (Object)method);
        Assertions.assertEquals((Object)"Test() throws Exception, Throwable{ }", (Object)method.toString());
    }

    @Test
    public void testWhitespaceAfterThrowComma() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"Test()throws Exception,     \t   \t\n    \t    Throwable{}");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").throwType("Throwable").build(), (Object)method);
        Assertions.assertEquals((Object)"Test() throws Exception, Throwable{ }", (Object)method.toString());
    }

    @Test
    public void testInsaneWhitespace() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)" \t   \t\n\t    private     \t   \t\n    \t    static     \t   \t\n    \t    final      \t    \t\n    \t    String     \t   \t\n    \t    test     \t   \t\n    \t    (     \t   \t\n    \t    String     \t   \t\n    \t    type     \t   \t\n    \t    ,     \t   \t\n    \t    int     \t   \t\n    \t    derp     \t   \t\n    \t    )     \t   \t\n    \t    throws     \t   \t\n    \t    Exception     \t   \t\n    \t    ,     \t   \t\n    \t    Throwable     \t   \t\n    \t    {     \t   \t\n    \t    doSomething()     \t   \t\n    \t    ;     \t   \t\n    \t    doSomethingElse()     \t   \t\n    \t    ;     \t   \t\n    \t    }     \t   \t\n    \t     ");
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).isStatic().isFinal().returnType("String").name("test").parameter("String", "type").parameter("int", "derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build(), (Object)method);
        Assertions.assertEquals((Object)"private static final String test(String type, int derp) throws Exception, Throwable{\n\tdoSomething();\n\tdoSomethingElse();\n}", (Object)method.toString());
    }

    @Test
    public void testInsaneWhitespaceWithAnnotations() throws JavaParsingException {
        JavaMethod method = (JavaMethod)this.parseMethod.apply((Object)"\t  \t @ \t  \tTest\t  (\t \ttype \t = \t\n\t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\t     \t\n\t    \t@       Derp   \t\n\t\t   \t\n\t\t    private     \t   \t\n\t    static     \t   \t\n\t    final     \t   \t\n\t    String     \t   \t\n\t    test     \t   \t\n\t    (     \t   \t\n\t    String     \t   \t\n\t    type     \t   \t\n\t    ,     \t   \t\n\t    int     \t   \t\n\t    derp     \t   \t\n\t    )     \t   \t\n\t    throws     \t   \t\n\t    Exception     \t   \t\n\t    ,     \t   \t\n\t    Throwable     \t   \t\n\t    {     \t   \t\n\t    doSomething()     \t   \t\n\t    ;     \t   \t\n\t    doSomethingElse()     \t   \t\n\t    ;     \t   \t\n\t    }     \t   \t\n\t     ");
        Assertions.assertEquals((Object)EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().returnType("String").name("test").parameter("String", "type").parameter("int", "derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build(), (Object)method);
        Assertions.assertEquals((Object)"@Test(type = String.class, defaultValue = \"\")\n@Derp\nprivate static final String test(String type, int derp) throws Exception, Throwable{\n\tdoSomething();\n\tdoSomethingElse();\n}", (Object)method.toString());
    }
}

