/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseJavaPackageDeclarationParserTest
extends BaseJavaParserTest {
    private final ThrowingFunction<String, JavaPackageDeclaration, JavaParsingException> parseMethod;

    protected BaseJavaPackageDeclarationParserTest(ThrowingFunction<String, JavaPackageDeclaration, JavaParsingException> parseMethod) {
        this.parseMethod = parseMethod;
    }

    @Test
    public void testSimplePackageDeclaration() throws JavaParsingException {
        JavaPackageDeclaration packageDeclaration = (JavaPackageDeclaration)this.parseMethod.apply((Object)"package com.example;");
        Assertions.assertEquals((Object)"com.example", (Object)packageDeclaration.getPackageName());
    }

    @Test
    public void testPackageDeclarationNoPackageName() {
        try {
            this.parseMethod.apply((Object)"package ;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.PACKAGE_DECLARATION, "Failed to find package name in package declaration!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testPackageDeclarationNoSemicolon() {
        try {
            this.parseMethod.apply((Object)"package com.example");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.PACKAGE_DECLARATION, "Failed to find semicolon ending package declaration!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testPackageDeclarationNoPackageNameOrSemicolon() {
        try {
            this.parseMethod.apply((Object)"package");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.PACKAGE_DECLARATION, "Failed to find package name in package declaration!\nFailed to find semicolon ending package declaration!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testLeadingWhitespace() throws JavaParsingException {
        JavaPackageDeclaration packageDeclaration = (JavaPackageDeclaration)this.parseMethod.apply((Object)"\t    \t\npackage com.example;");
        Assertions.assertEquals((Object)"com.example", (Object)packageDeclaration.getPackageName());
    }

    @Test
    public void testWhitespaceBeforePackageName() throws JavaParsingException {
        JavaPackageDeclaration packageDeclaration = (JavaPackageDeclaration)this.parseMethod.apply((Object)"package\t  \t\n\tcom.example;");
        Assertions.assertEquals((Object)"com.example", (Object)packageDeclaration.getPackageName());
    }

    @Test
    public void testWhitespaceInPackageName() throws JavaParsingException {
        JavaPackageDeclaration packageDeclaration = (JavaPackageDeclaration)this.parseMethod.apply((Object)"package com\t \t\n\t.\n\t  example;");
        Assertions.assertEquals((Object)"com.example", (Object)packageDeclaration.getPackageName());
    }

    @Test
    public void testWhitespaceAfterPackageName() throws JavaParsingException {
        JavaPackageDeclaration packageDeclaration = (JavaPackageDeclaration)this.parseMethod.apply((Object)"package com.example  \t\n;");
        Assertions.assertEquals((Object)"com.example", (Object)packageDeclaration.getPackageName());
    }

    @Test
    public void testTrailingWhitespace() throws JavaParsingException {
        JavaPackageDeclaration packageDeclaration = (JavaPackageDeclaration)this.parseMethod.apply((Object)"package com.example;\t\n  \t");
        Assertions.assertEquals((Object)"com.example", (Object)packageDeclaration.getPackageName());
    }

    @Test
    public void testInsaneWhitespace() throws JavaParsingException {
        JavaPackageDeclaration packageDeclaration = (JavaPackageDeclaration)this.parseMethod.apply((Object)"\t    \tpackage\t  \t\n\tcom\t \t\n\t.\n\t  example  \t\n;\t\n  \t");
        Assertions.assertEquals((Object)"com.example", (Object)packageDeclaration.getPackageName());
    }
}

