/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.codetypes.BaseJavaAnnotationParserTest;
import com.github.tadukoo.java.parsing.codetypes.JavaAnnotationParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JavaAnnotationParserTest
extends BaseJavaAnnotationParserTest {
    public JavaAnnotationParserTest() {
        super((ThrowingFunction<String, JavaAnnotation, JavaParsingException>)((ThrowingFunction)JavaAnnotationParser::parseAnnotation));
    }

    @Test
    public void testMissingStartToken() {
        try {
            JavaAnnotationParser.parseAnnotation((List)ListUtil.createList((Object[])new String[]{"Test", "(", "type", "=", "String.class", ")"}), (int)0);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.ANNOTATION, "First token of annotation must start with '@'"), (Object)e.getMessage());
        }
    }

    @Test
    public void testAnnotationDoesNotMatchRegex() {
        try {
            JavaAnnotationParser.parseAnnotation((String)"Test(type = String.class)");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.ANNOTATION, "Failed to parse annotation"), (Object)e.getMessage());
        }
    }
}

