/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.codetypes.BaseJavaFieldParserTest;
import com.github.tadukoo.java.parsing.codetypes.JavaFieldParser;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JavaFieldParserTest
extends BaseJavaFieldParserTest {
    public JavaFieldParserTest() {
        super((ThrowingFunction<String, JavaField, JavaParsingException>)((ThrowingFunction)JavaFieldParser::parseField));
    }

    @Test
    public void testNoFieldParsed() {
        try {
            JavaFieldParser.parseField((String)"@Test");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to parse an actual field!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMultipleJavadocs() {
        try {
            JavaFieldParser.parseField((String)"/** {@inheritDoc} */\n/** something */\nString name;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Only one Javadoc allowed on a field!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testJavadocAfterField() {
        try {
            JavaFieldParser.parseField((String)"String name;\n/** {@inheritDoc} */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Encountered Javadoc after field!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testAnnotationAfterField() {
        try {
            JavaFieldParser.parseField((String)"String name;\n@Test");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Encountered annotation after field!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMultipleFields() {
        try {
            JavaFieldParser.parseField((String)"String name;\nint version;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Encountered multiple fields!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testSimpleFieldNoSemicolon() {
        try {
            JavaFieldParser.parseField((String)"String name");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to find semicolon at end of field"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFieldWithVisibilityNoSemicolon() {
        try {
            JavaFieldParser.parseField((String)"private String name");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to find semicolon at end of field"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFieldWithStaticNoSemicolon() {
        try {
            JavaFieldParser.parseField((String)"static String name");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to find semicolon at end of field"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFieldWithFinalNoSemicolon() {
        try {
            JavaFieldParser.parseField((String)"final String name");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to find semicolon at end of field"), (Object)e.getMessage());
        }
    }

    @Test
    public void testGarbage() {
        try {
            JavaFieldParser.parseField((String)"derp bloop scoop loop;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to parse a field"), (Object)e.getMessage());
        }
    }
}

