/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.codetypes.BaseJavaMethodParserTest;
import com.github.tadukoo.java.parsing.codetypes.JavaMethodParser;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JavaMethodParserTest
extends BaseJavaMethodParserTest {
    public JavaMethodParserTest() {
        super((ThrowingFunction<String, JavaMethod, JavaParsingException>)((ThrowingFunction)JavaMethodParser::parseMethod));
    }

    @Test
    public void testTooManyJavadocs() {
        try {
            JavaMethodParser.parseMethod((String)"/** {@inheritDoc} */\n/** some other Javadoc */\nTest(){}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.METHOD, "Only one Javadoc allowed on a method!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testJavadocAfterMethod() {
        try {
            JavaMethodParser.parseMethod((String)"Test(){}\n/** {@inheritDoc} */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.METHOD, "Encountered Javadoc after method!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testAnnotationAfterMethod() {
        try {
            JavaMethodParser.parseMethod((String)"Test(){}\n@Test");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.METHOD, "Encountered annotation after method!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMultipleMethods() {
        try {
            JavaMethodParser.parseMethod((String)"Test(){}\nTest(){}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.METHOD, "Encountered multiple methods!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testNotAMethod() {
        try {
            JavaMethodParser.parseMethod((String)"@Test");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.METHOD, "Failed to parse an actual method!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testNotAMethodParseJustMethod() {
        Assertions.assertNull((Object)JavaMethodParser.parseJustMethod((String)"@Test"));
    }
}

