/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.FullJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.codetypes.JavaTypeWithModifiersParser;
import com.github.tadukoo.util.ListUtil;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JavaTypeWithModifiersParserErrorsTest
extends BaseJavaParserTest {
    @Test
    public void testDoesNotStartWithModifierError() {
        try {
            JavaTypeWithModifiersParser.parseTypeWithModifiers((List)ListUtil.createList((Object[])new String[]{"String", " ", "type;"}), (int)0);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "First token of type with modifiers must be a modifier"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFailedToDetermineTypeError() {
        try {
            JavaTypeWithModifiersParser.parseTypeWithModifiers((List)ListUtil.createList((Object[])new String[]{"static", " ", "yep"}), (int)0);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, "Failed to determine type\nFailed to determine result type"), (Object)e.getMessage());
        }
    }

    @Test
    public void testDuplicateModifiersError() {
        try {
            FullJavaParser.parseType((String)"static static class Test{\n}\n");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Found duplicate modifier: 'static'"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMultipleDuplicateModifiersError() {
        try {
            FullJavaParser.parseType((String)"static static final final class Test{\n}\n");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Found duplicate modifier: 'static'\nFound duplicate modifier: 'final'"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMultipleVisibilityModifiersError() {
        try {
            FullJavaParser.parseType((String)"private public class Test{\n}\n");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Found multiple visibility modifiers"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFailedToDetermineResultTypeError() {
        try {
            FullJavaParser.parseType((String)"private\n");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.TYPE_WITH_MODIFIERS, "Failed to determine result type"), (Object)e.getMessage());
        }
    }

    @Test
    public void testAllErrors() {
        try {
            FullJavaParser.parseType((String)"private public static static final final\n");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.TYPE_WITH_MODIFIERS, "Found duplicate modifier: 'static'\nFound duplicate modifier: 'final'\nFound multiple visibility modifiers\nFailed to determine result type"), (Object)e.getMessage());
        }
    }
}

