/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.comment;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseJavaMultiLineCommentParserTest
extends BaseJavaParserTest {
    private final ThrowingFunction<String, JavaMultiLineComment, JavaParsingException> parseMethod;

    protected BaseJavaMultiLineCommentParserTest(ThrowingFunction<String, JavaMultiLineComment, JavaParsingException> parseMethod) {
        this.parseMethod = parseMethod;
    }

    @Test
    public void testEmptyComment() throws JavaParsingException {
        JavaMultiLineComment comment = (JavaMultiLineComment)this.parseMethod.apply((Object)"/*\n */");
        Assertions.assertEquals((Object)EditableJavaMultiLineComment.builder().build(), (Object)comment);
    }

    @Test
    public void testCommentWithContent() throws JavaParsingException {
        JavaMultiLineComment comment = (JavaMultiLineComment)this.parseMethod.apply((Object)"/*\n * something useful\n */");
        Assertions.assertEquals((Object)EditableJavaMultiLineComment.builder().content("something useful").build(), (Object)comment);
    }

    @Test
    public void testCommentWithMultipleLinesOfContent() throws JavaParsingException {
        JavaMultiLineComment comment = (JavaMultiLineComment)this.parseMethod.apply((Object)"/*\n * something useful\n * something else\n */");
        Assertions.assertEquals((Object)EditableJavaMultiLineComment.builder().content("something useful").content("something else").build(), (Object)comment);
    }

    @Test
    public void testCommentWithMultipleLinesOfContentAndBlankLine() throws JavaParsingException {
        JavaMultiLineComment comment = (JavaMultiLineComment)this.parseMethod.apply((Object)"/*\n * something useful\n * \n * something else\n */");
        Assertions.assertEquals((Object)EditableJavaMultiLineComment.builder().content("something useful").content("").content("something else").build(), (Object)comment);
    }

    @Test
    public void testCommentWithAsteriskInContent() throws JavaParsingException {
        JavaMultiLineComment comment = (JavaMultiLineComment)this.parseMethod.apply((Object)"/*\n * something * useful\n */");
        Assertions.assertEquals((Object)EditableJavaMultiLineComment.builder().content("something * useful").build(), (Object)comment);
    }

    @Test
    public void testMissingEndToken() {
        try {
            this.parseMethod.apply((Object)"/*");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.MULTI_LINE_COMMENT, "Failed to find closing multi-line comment token!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testCommentWithContentOnFirstLine() throws JavaParsingException {
        JavaMultiLineComment comment = (JavaMultiLineComment)this.parseMethod.apply((Object)"/* something useful\n */");
        Assertions.assertEquals((Object)EditableJavaMultiLineComment.builder().content("something useful").build(), (Object)comment);
    }

    @Test
    public void testCommentWithContentOnFirstLineNoSpace() throws JavaParsingException {
        JavaMultiLineComment comment = (JavaMultiLineComment)this.parseMethod.apply((Object)"/*something useful\n */");
        Assertions.assertEquals((Object)EditableJavaMultiLineComment.builder().content("something useful").build(), (Object)comment);
    }

    @Test
    public void testCommentWithContentOnLastLine() throws JavaParsingException {
        JavaMultiLineComment comment = (JavaMultiLineComment)this.parseMethod.apply((Object)"/*\n something useful */");
        Assertions.assertEquals((Object)EditableJavaMultiLineComment.builder().content("something useful").build(), (Object)comment);
    }

    @Test
    public void testCommentWithContentOnLastLineNoSpace() throws JavaParsingException {
        JavaMultiLineComment comment = (JavaMultiLineComment)this.parseMethod.apply((Object)"/*\n something useful*/");
        Assertions.assertEquals((Object)EditableJavaMultiLineComment.builder().content("something useful").build(), (Object)comment);
    }

    @Test
    public void testLeadingWhitespace() throws JavaParsingException {
        JavaMultiLineComment comment = (JavaMultiLineComment)this.parseMethod.apply((Object)"\t     \t  \t\n\t    \t\n\t     \t    /*\n * something\n */");
        Assertions.assertEquals((Object)EditableJavaMultiLineComment.builder().content("something").build(), (Object)comment);
    }

    @Test
    public void testTrailingWhitespace() throws JavaParsingException {
        JavaMultiLineComment comment = (JavaMultiLineComment)this.parseMethod.apply((Object)"/*\n * something\n */    \t\n \t     \t  \t\n\t    \t\n\t     \t    \t");
        Assertions.assertEquals((Object)EditableJavaMultiLineComment.builder().content("something").build(), (Object)comment);
    }

    @Test
    public void testInsaneWhitespace() throws JavaParsingException {
        JavaMultiLineComment comment = (JavaMultiLineComment)this.parseMethod.apply((Object)"\t     \t  \t\n\t    \t\n\t     \t    /*\n * something\n */    \t\n \t     \t  \t\n\t    \t\n\t     \t    \t");
        Assertions.assertEquals((Object)EditableJavaMultiLineComment.builder().content("something").build(), (Object)comment);
    }
}

