/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.comment;

import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseJavaSingleLineCommentParserTest
extends BaseJavaParserTest {
    private final ThrowingFunction<String, JavaSingleLineComment, JavaParsingException> parseMethod;

    protected BaseJavaSingleLineCommentParserTest(ThrowingFunction<String, JavaSingleLineComment, JavaParsingException> parseMethod) {
        this.parseMethod = parseMethod;
    }

    @Test
    public void testEmptyComment() throws JavaParsingException {
        JavaSingleLineComment comment = (JavaSingleLineComment)this.parseMethod.apply((Object)"//");
        Assertions.assertEquals((Object)EditableJavaSingleLineComment.builder().build(), (Object)comment);
        Assertions.assertEquals((Object)"// ", (Object)comment.toString());
    }

    @Test
    public void testCommentWithContent() throws JavaParsingException {
        JavaSingleLineComment comment = (JavaSingleLineComment)this.parseMethod.apply((Object)"// something useful here");
        Assertions.assertEquals((Object)EditableJavaSingleLineComment.builder().content("something useful here").build(), (Object)comment);
        Assertions.assertEquals((Object)"// something useful here", (Object)comment.toString());
    }

    @Test
    public void testCommentWithImmediateContent() throws JavaParsingException {
        JavaSingleLineComment comment = (JavaSingleLineComment)this.parseMethod.apply((Object)"//something useful here");
        Assertions.assertEquals((Object)EditableJavaSingleLineComment.builder().content("something useful here").build(), (Object)comment);
        Assertions.assertEquals((Object)"// something useful here", (Object)comment.toString());
    }

    @Test
    public void testLeadingWhitespace() throws JavaParsingException {
        JavaSingleLineComment comment = (JavaSingleLineComment)this.parseMethod.apply((Object)"\t     \t  \t\n\t    // something useful");
        Assertions.assertEquals((Object)EditableJavaSingleLineComment.builder().content("something useful").build(), (Object)comment);
        Assertions.assertEquals((Object)"// something useful", (Object)comment.toString());
    }

    @Test
    public void testTrailingWhitespace() throws JavaParsingException {
        JavaSingleLineComment comment = (JavaSingleLineComment)this.parseMethod.apply((Object)"// something useful \t    \t \t\n\t     \t");
        Assertions.assertEquals((Object)EditableJavaSingleLineComment.builder().content("something useful").build(), (Object)comment);
        Assertions.assertEquals((Object)"// something useful", (Object)comment.toString());
    }

    @Test
    public void testMoreTrailingWhitespace() throws JavaParsingException {
        JavaSingleLineComment comment = (JavaSingleLineComment)this.parseMethod.apply((Object)"// something useful \t      \t \t\n\t     \t\n\t  \t\n\t  \t");
        Assertions.assertEquals((Object)EditableJavaSingleLineComment.builder().content("something useful").build(), (Object)comment);
        Assertions.assertEquals((Object)"// something useful", (Object)comment.toString());
    }

    @Test
    public void testInsideWhitespace() throws JavaParsingException {
        JavaSingleLineComment comment = (JavaSingleLineComment)this.parseMethod.apply((Object)"// something \t     \t   useful");
        Assertions.assertEquals((Object)EditableJavaSingleLineComment.builder().content("something \t     \t   useful").build(), (Object)comment);
        Assertions.assertEquals((Object)"// something \t     \t   useful", (Object)comment.toString());
    }

    @Test
    public void testWhitespaceAfterStartToken() throws JavaParsingException {
        JavaSingleLineComment comment = (JavaSingleLineComment)this.parseMethod.apply((Object)"// \t     \t   something useful");
        Assertions.assertEquals((Object)EditableJavaSingleLineComment.builder().content("something useful").build(), (Object)comment);
        Assertions.assertEquals((Object)"// something useful", (Object)comment.toString());
    }

    @Test
    public void testInsaneWhitespace() throws JavaParsingException {
        JavaSingleLineComment comment = (JavaSingleLineComment)this.parseMethod.apply((Object)"\t     \t  \t\n\t    // \t     \t   something \t     \t   useful \t     \t  \t\n\t     \t");
        Assertions.assertEquals((Object)EditableJavaSingleLineComment.builder().content("something \t     \t   useful").build(), (Object)comment);
        Assertions.assertEquals((Object)"// something \t     \t   useful", (Object)comment.toString());
    }
}

