/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.comment;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseJavadocParserTest
extends BaseJavaParserTest {
    private final ThrowingFunction<String, Javadoc, JavaParsingException> parseMethod;

    protected BaseJavadocParserTest(ThrowingFunction<String, Javadoc, JavaParsingException> parseMethod) {
        this.parseMethod = parseMethod;
    }

    @Test
    public void testSimpleCondensed() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/** */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().build(), (Object)doc);
        Assertions.assertEquals((Object)"/** */", (Object)doc.toString());
    }

    @Test
    public void testSimpleNotCondensed() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\n */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n */", (Object)doc.toString());
    }

    @Test
    public void testCondensedWithContent() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/** some content */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().content("some content").build(), (Object)doc);
        Assertions.assertEquals((Object)"/** some content */", (Object)doc.toString());
    }

    @Test
    public void testNotCondensedWithContent() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\n * some content\n */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().content("some content").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * some content\n */", (Object)doc.toString());
    }

    @Test
    public void testCondensedWithAuthor() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/** @author Logan Ferree (Tadukoo) */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().author("Logan Ferree (Tadukoo)").build(), (Object)doc);
        Assertions.assertEquals((Object)"/** @author Logan Ferree (Tadukoo) */", (Object)doc.toString());
    }

    @Test
    public void testNotCondensedWithAuthor() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\n * @author Logan Ferree (Tadukoo)\n */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().author("Logan Ferree (Tadukoo)").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * @author Logan Ferree (Tadukoo)\n */", (Object)doc.toString());
    }

    @Test
    public void testCondensedWithVersion() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/** @version Beta v.0.5 */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().version("Beta v.0.5").build(), (Object)doc);
        Assertions.assertEquals((Object)"/** @version Beta v.0.5 */", (Object)doc.toString());
    }

    @Test
    public void testNotCondensedWithVersion() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\n * @version Beta v.0.5\n */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().version("Beta v.0.5").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * @version Beta v.0.5\n */", (Object)doc.toString());
    }

    @Test
    public void testCondensedWithSince() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/** @since Alpha v.0.1 */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().since("Alpha v.0.1").build(), (Object)doc);
        Assertions.assertEquals((Object)"/** @since Alpha v.0.1 */", (Object)doc.toString());
    }

    @Test
    public void testNotCondensedWithSince() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\n * @since Alpha v.0.1\n */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().since("Alpha v.0.1").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * @since Alpha v.0.1\n */", (Object)doc.toString());
    }

    @Test
    public void testCondensedWithParam() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/** @param type The type */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().param("type", "The type").build(), (Object)doc);
        Assertions.assertEquals((Object)"/** @param type The type */", (Object)doc.toString());
    }

    @Test
    public void testNotCondensedWithParam() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\n * @param type The type\n */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().param("type", "The type").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * @param type The type\n */", (Object)doc.toString());
    }

    @Test
    public void testCondensedWithReturn() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/** @return this, to continue building */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().returnVal("this, to continue building").build(), (Object)doc);
        Assertions.assertEquals((Object)"/** @return this, to continue building */", (Object)doc.toString());
    }

    @Test
    public void testNotCondensedWithReturn() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\n * @return this, to continue building\n */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().returnVal("this, to continue building").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * @return this, to continue building\n */", (Object)doc.toString());
    }

    @Test
    public void testCondensedWithThrows() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/** @throws Exception Because I can */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().throwsInfo("Exception", "Because I can").build(), (Object)doc);
        Assertions.assertEquals((Object)"/** @throws Exception Because I can */", (Object)doc.toString());
    }

    @Test
    public void testNotCondensedWithThrows() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\n * @throws Exception Because I can\n */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().throwsInfo("Exception", "Because I can").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * @throws Exception Because I can\n */", (Object)doc.toString());
    }

    @Test
    public void testCondensedWithEverything() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/** some content\n * @author Logan Ferree (Tadukoo)\n * @version Beta v.0.5\n * @since Alpha v.0.1\n * @param type The type\n * @param derp The int\n * @return this, to continue building\n * @throws Exception Because I can */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().content("some content").author("Logan Ferree (Tadukoo)").version("Beta v.0.5").since("Alpha v.0.1").param("type", "The type").param("derp", "The int").returnVal("this, to continue building").throwsInfo("Exception", "Because I can").build(), (Object)doc);
        Assertions.assertEquals((Object)"/** some content\n * \n * @author Logan Ferree (Tadukoo)\n * @version Beta v.0.5\n * @since Alpha v.0.1\n * \n * @param type The type\n * @param derp The int\n * @return this, to continue building\n * @throws Exception Because I can */", (Object)doc.toString());
    }

    @Test
    public void testNotCondensedWithEverything() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\n * some content\n * @author Logan Ferree (Tadukoo)\n * @version Beta v.0.5\n * @since Alpha v.0.1\n * @param type The type\n * @param derp The int\n * @return this, to continue building\n * @throws Exception Because I can\n */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().content("some content").author("Logan Ferree (Tadukoo)").version("Beta v.0.5").since("Alpha v.0.1").param("type", "The type").param("derp", "The int").returnVal("this, to continue building").throwsInfo("Exception", "Because I can").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * some content\n * \n * @author Logan Ferree (Tadukoo)\n * @version Beta v.0.5\n * @since Alpha v.0.1\n * \n * @param type The type\n * @param derp The int\n * @return this, to continue building\n * @throws Exception Because I can\n */", (Object)doc.toString());
    }

    @Test
    public void testUnknownAnnotationCondensed() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/** @garbage something */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().content("@garbage something").build(), (Object)doc);
        Assertions.assertEquals((Object)"/** @garbage something */", (Object)doc.toString());
    }

    @Test
    public void testUnknownAnnotationNotCondensed() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\n * @garbage something\n */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().content("@garbage something").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * @garbage something\n */", (Object)doc.toString());
    }

    @Test
    public void testBlankContentLine() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\n * something\n * \n * something else\n */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().content("something").content("something else").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * something\n * something else\n */", (Object)doc.toString());
    }

    @Test
    public void testStartTokenInContent() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\n * /**\n */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().content("/**").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * /**\n */", (Object)doc.toString());
    }

    @Test
    public void testInheritDoc() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/** {@inheritDoc} */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().content("{@inheritDoc}").build(), (Object)doc);
        Assertions.assertEquals((Object)"/** {@inheritDoc} */", (Object)doc.toString());
    }

    @Test
    public void testBracedContent() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/** {content} */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().content("{content}").build(), (Object)doc);
        Assertions.assertEquals((Object)"/** {content} */", (Object)doc.toString());
    }

    @Test
    public void testContentRightAfterStartToken() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**some content */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().content("some content").build(), (Object)doc);
        Assertions.assertEquals((Object)"/** some content */", (Object)doc.toString());
    }

    @Test
    public void testAnnotationRightAfterStartToken() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**@author Logan Ferree (Tadukoo) */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().condensed().author("Logan Ferree (Tadukoo)").build(), (Object)doc);
        Assertions.assertEquals((Object)"/** @author Logan Ferree (Tadukoo) */", (Object)doc.toString());
    }

    @Test
    public void testLeadingWhitespace() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"\t     \t   \t\n\t    \t  \t\n\t   /**\n * some content\n */");
        Assertions.assertEquals((Object)EditableJavadoc.builder().content("some content").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * some content\n */", (Object)doc.toString());
    }

    @Test
    public void testTrailingWhitespace() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\n * some content\n */   \t\n \t     \t   \t\n\t    \t  \t\n\t    ");
        Assertions.assertEquals((Object)EditableJavadoc.builder().content("some content").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * some content\n */", (Object)doc.toString());
    }

    @Test
    public void testDoubleAuthors() {
        try {
            this.parseMethod.apply((Object)"/** @author Logan Ferree (Tadukoo)\n * @author Shea */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.JAVADOC, "Found multiple author strings"), (Object)e.getMessage());
        }
    }

    @Test
    public void testTripleAuthors() {
        try {
            this.parseMethod.apply((Object)"/** @author Logan Ferree (Tadukoo)\n * @author Shea\n * @author Zack */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.JAVADOC, "Found multiple author strings"), (Object)e.getMessage());
        }
    }

    @Test
    public void testDoubleVersions() {
        try {
            this.parseMethod.apply((Object)"/** @version Beta v.0.5\n * @version Beta v.0.4 */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.JAVADOC, "Found multiple version strings"), (Object)e.getMessage());
        }
    }

    @Test
    public void testTripleVersions() {
        try {
            this.parseMethod.apply((Object)"/** @version Beta v.0.5\n * @version Beta v.0.4\n * @version Alpha v.0.1 */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.JAVADOC, "Found multiple version strings"), (Object)e.getMessage());
        }
    }

    @Test
    public void testDoubleSince() {
        try {
            this.parseMethod.apply((Object)"/** @since Beta v.0.5\n * @since Beta v.0.4 */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.JAVADOC, "Found multiple since strings"), (Object)e.getMessage());
        }
    }

    @Test
    public void testTripleSince() {
        try {
            this.parseMethod.apply((Object)"/** @since Beta v.0.5\n * @since Beta v.0.4\n * @since Alpha v.0.1 */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.JAVADOC, "Found multiple since strings"), (Object)e.getMessage());
        }
    }

    @Test
    public void testDoubleReturns() {
        try {
            this.parseMethod.apply((Object)"/** @return this, to continue building\n * @return The type */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.JAVADOC, "Found multiple return strings"), (Object)e.getMessage());
        }
    }

    @Test
    public void testTripleReturns() {
        try {
            this.parseMethod.apply((Object)"/** @return this, to continue building\n * @return The type\n * @return I don't even know */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.JAVADOC, "Found multiple return strings"), (Object)e.getMessage());
        }
    }

    @Test
    public void testLabelFormFieldIssue() throws JavaParsingException {
        Javadoc doc = (Javadoc)this.parseMethod.apply((Object)"/**\r\n * Represents a {@link FormField} for a Label\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.4\n */\n");
        Assertions.assertEquals((Object)EditableJavadoc.builder().content("Represents a {@link FormField} for a Label").author("Logan Ferree (Tadukoo)").version("Alpha v.0.4").build(), (Object)doc);
        Assertions.assertEquals((Object)"/**\n * Represents a {@link FormField} for a Label\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.4\n */", (Object)doc.toString());
    }
}

