/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.comment;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.comment.BaseJavaSingleLineCommentParserTest;
import com.github.tadukoo.java.parsing.comment.JavaSingleLineCommentParser;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JavaSingleLineCommentParserTest
extends BaseJavaSingleLineCommentParserTest {
    public JavaSingleLineCommentParserTest() {
        super((ThrowingFunction<String, JavaSingleLineComment, JavaParsingException>)((ThrowingFunction)JavaSingleLineCommentParser::parseSingleLineComment));
    }

    @Test
    public void testExtraContentFoundError() {
        try {
            JavaSingleLineCommentParser.parseSingleLineComment((String)"// some comment\n// some other comment");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.SINGLE_LINE_COMMENT, "Found extra content after the single-line comment!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testCommentDoesNotStartWithTokenError() {
        try {
            JavaSingleLineCommentParser.parseSingleLineComment((String)"/* some comment */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.SINGLE_LINE_COMMENT, "First token of single-line comment must start with '//'"), (Object)e.getMessage());
        }
    }
}

