/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.annotation;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class JavaAnnotation
implements JavaCodeType {
    private final boolean editable;
    protected String name;
    protected String canonicalName;
    protected List<Pair<String, String>> parameters;

    protected JavaAnnotation(boolean editable, String name, String canonicalName, List<Pair<String, String>> parameters) {
        this.editable = editable;
        this.name = name;
        this.canonicalName = canonicalName;
        this.parameters = parameters;
    }

    @Override
    public JavaCodeTypes getJavaCodeType() {
        return JavaCodeTypes.ANNOTATION;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getName() {
        return this.name;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public List<Pair<String, String>> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getParametersMap() {
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        for (Pair<String, String> parameter : this.parameters) {
            parametersMap.put((String)parameter.getLeft(), (String)parameter.getRight());
        }
        return parametersMap;
    }

    public String toString() {
        StringBuilder annotation = new StringBuilder("@").append(this.name);
        if (ListUtil.isNotBlank(this.parameters)) {
            annotation.append("(");
            if (this.parameters.size() == 1 && StringUtil.equals((String)((String)this.parameters.get(0).getLeft()), (String)"value")) {
                annotation.append((String)this.parameters.get(0).getRight());
            } else {
                for (Pair<String, String> parameter : this.parameters) {
                    annotation.append((String)parameter.getLeft()).append(' ').append("=").append(' ').append((String)parameter.getRight()).append(",").append(' ');
                }
                annotation.delete(annotation.length() - 2, annotation.length());
            }
            annotation.append(")");
        }
        return annotation.toString();
    }

    public boolean equals(Object otherAnnotation) {
        if (otherAnnotation instanceof JavaAnnotation) {
            JavaAnnotation annotation = (JavaAnnotation)otherAnnotation;
            return StringUtil.equals((String)this.toString(), (String)annotation.toString());
        }
        return false;
    }

    @Override
    public String toBuilderCode() {
        StringBuilder codeString = new StringBuilder(this.getClass().getSimpleName()).append(".builder()");
        codeString.append("\n\t\t").append(".name(\"").append(this.name).append("\")");
        if (StringUtil.isNotBlank((String)this.canonicalName)) {
            codeString.append("\n\t\t").append(".canonicalName(\"").append(this.canonicalName).append("\")");
        }
        if (ListUtil.isNotBlank(this.parameters)) {
            for (Pair<String, String> parameter : this.parameters) {
                codeString.append("\n\t\t").append(".parameter(\"").append((String)parameter.getLeft()).append("\", \"").append(((String)parameter.getRight()).replace("\"", "\\\"")).append("\")");
            }
        }
        codeString.append("\n\t\t").append(".build()");
        return codeString.toString();
    }
}

