/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.comment;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import java.util.List;

public abstract class JavaMultiLineComment
implements JavaCodeType {
    private final boolean editable;
    protected List<String> content;

    protected JavaMultiLineComment(boolean editable, List<String> content) {
        this.editable = editable;
        this.content = content;
    }

    @Override
    public JavaCodeTypes getJavaCodeType() {
        return JavaCodeTypes.MULTI_LINE_COMMENT;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public List<String> getContent() {
        return this.content;
    }

    public String toString() {
        StringBuilder text = new StringBuilder("/*");
        if (ListUtil.isNotBlank(this.content)) {
            for (String line : this.content) {
                text.append("\n ").append("*").append(' ').append(line);
            }
        }
        text.append("\n ").append("*/");
        return text.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaMultiLineComment) {
            JavaMultiLineComment comment = (JavaMultiLineComment)obj;
            return StringUtil.equals((String)this.toString(), (String)comment.toString());
        }
        return false;
    }

    @Override
    public String toBuilderCode() {
        StringBuilder codeString = new StringBuilder(this.getClass().getSimpleName()).append(".builder()");
        if (ListUtil.isNotBlank(this.content)) {
            for (String line : this.content) {
                codeString.append("\n\t\t").append(".content(\"").append(this.escapeQuotes(line)).append("\")");
            }
        }
        codeString.append("\n\t\t").append(".build()");
        return codeString.toString();
    }
}

